/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.SqlTimestamp;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSqlTimestamp {
    @Test
    public void testMillisToString() {
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(0L, TimeUnit.MILLISECONDS), (String)"1970-01-01 00:00:00.000");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(1L, TimeUnit.MILLISECONDS), (String)"1970-01-01 00:00:00.001");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(999L, TimeUnit.MILLISECONDS), (String)"1970-01-01 00:00:00.999");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(1000L, TimeUnit.MILLISECONDS), (String)"1970-01-01 00:00:01.000");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(-1L, TimeUnit.MILLISECONDS), (String)"1969-12-31 23:59:59.999");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(-999L, TimeUnit.MILLISECONDS), (String)"1969-12-31 23:59:59.001");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(-60000000000789L, TimeUnit.MILLISECONDS), (String)"0068-09-03 13:19:59.211");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(1650483250507L, TimeUnit.MILLISECONDS), (String)"2022-04-20 19:34:10.507");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(60000000000789L, TimeUnit.MILLISECONDS), (String)"3871-04-29 10:40:00.789");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(230000000000999L, TimeUnit.MILLISECONDS), (String)"9258-05-30 00:53:20.999");
    }

    @Test
    public void testMicrosToString() {
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(0L, TimeUnit.MICROSECONDS), (String)"1970-01-01 00:00:00.000000");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(1L, TimeUnit.MICROSECONDS), (String)"1970-01-01 00:00:00.000001");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(999999L, TimeUnit.MICROSECONDS), (String)"1970-01-01 00:00:00.999999");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(1000000L, TimeUnit.MICROSECONDS), (String)"1970-01-01 00:00:01.000000");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(-1L, TimeUnit.MICROSECONDS), (String)"1969-12-31 23:59:59.999999");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(-999999L, TimeUnit.MICROSECONDS), (String)"1969-12-31 23:59:59.000001");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(-60000000000000789L, TimeUnit.MICROSECONDS), (String)"0068-09-03 13:19:59.999211");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(1650483250000507L, TimeUnit.MICROSECONDS), (String)"2022-04-20 19:34:10.000507");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(60000000000123789L, TimeUnit.MICROSECONDS), (String)"3871-04-29 10:40:00.123789");
        Assert.assertEquals((String)TestSqlTimestamp.toSqlTimestampString(230000000000999999L, TimeUnit.MICROSECONDS), (String)"9258-05-30 00:53:20.999999");
    }

    @Test
    public void testEqualsHashcodeMillis() {
        SqlTimestamp t1Millis = new SqlTimestamp(0L, TimeUnit.MILLISECONDS);
        SqlTimestamp t2Millis = new SqlTimestamp(0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)t1Millis, (Object)t2Millis);
        Assert.assertEquals((int)t1Millis.hashCode(), (int)t2Millis.hashCode());
        SqlTimestamp t3Millis = new SqlTimestamp(1L, TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((Object)t1Millis, (Object)t3Millis);
        SqlTimestamp t1Micros = new SqlTimestamp(0L, TimeUnit.MICROSECONDS);
        Assert.assertNotEquals((Object)t1Millis, (Object)t1Micros);
    }

    @Test
    public void testEqualsHashcodeMicroseconds() {
        SqlTimestamp t1Micros = new SqlTimestamp(0L, TimeUnit.MICROSECONDS);
        SqlTimestamp t2Micros = new SqlTimestamp(0L, TimeUnit.MICROSECONDS);
        Assert.assertEquals((Object)t1Micros, (Object)t2Micros);
        Assert.assertEquals((int)t1Micros.hashCode(), (int)t2Micros.hashCode());
        SqlTimestamp t3Micros = new SqlTimestamp(1L, TimeUnit.MICROSECONDS);
        Assert.assertNotEquals((Object)t1Micros, (Object)t3Micros);
        SqlTimestamp t1Millis = new SqlTimestamp(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((Object)t1Micros, (Object)t1Millis);
    }

    private static String toSqlTimestampString(long value, TimeUnit precision) {
        SqlTimestamp timestamp = new SqlTimestamp(value, precision);
        return timestamp.toString();
    }
}

