/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeSignatureParameterUnion;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTypeSignatureParameterUnionSerde {
    private static final ThriftCatalog COMMON_CATALOG = new ThriftCatalog();
    private static final ThriftCodecManager COMPILER_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of());
    private static final ThriftCodecManager COMPILER_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of());
    private static final ThriftCodec<TypeSignatureParameterUnion> COMPILER_READ_CODEC = COMPILER_READ_CODEC_MANAGER.getCodec(TypeSignatureParameterUnion.class);
    private static final ThriftCodec<TypeSignatureParameterUnion> COMPILER_WRITE_CODEC = COMPILER_WRITE_CODEC_MANAGER.getCodec(TypeSignatureParameterUnion.class);
    private static final ThriftCodecManager REFLECTION_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of());
    private static final ThriftCodecManager REFLECTION_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of());
    private static final ThriftCodec<TypeSignatureParameterUnion> REFLECTION_READ_CODEC = REFLECTION_READ_CODEC_MANAGER.getCodec(TypeSignatureParameterUnion.class);
    private static final ThriftCodec<TypeSignatureParameterUnion> REFLECTION_WRITE_CODEC = REFLECTION_WRITE_CODEC_MANAGER.getCodec(TypeSignatureParameterUnion.class);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    private static final TypeSignature FAKE_TYPE_SIGNATURE = new TypeSignature("FAKE_BASE", new TypeSignatureParameter[0]);
    private TypeSignatureParameterUnion typeSignatureParameterUnion;

    @BeforeMethod
    public void setUp() {
        this.typeSignatureParameterUnion = new TypeSignatureParameterUnion(FAKE_TYPE_SIGNATURE);
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_READ_CODEC, COMPILER_WRITE_CODEC}, {COMPILER_READ_CODEC, REFLECTION_WRITE_CODEC}, {REFLECTION_READ_CODEC, COMPILER_WRITE_CODEC}, {REFLECTION_READ_CODEC, REFLECTION_WRITE_CODEC}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodec<TypeSignatureParameterUnion> readCodec, ThriftCodec<TypeSignatureParameterUnion> writeCodec) throws Exception {
        TypeSignatureParameterUnion typeSignatureParameterUnion = this.getRoundTripSerialize(readCodec, writeCodec, TBinaryProtocol::new);
        this.assertSerde(typeSignatureParameterUnion);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodec<TypeSignatureParameterUnion> readCodec, ThriftCodec<TypeSignatureParameterUnion> writeCodec) throws Exception {
        TypeSignatureParameterUnion typeSignatureParameterUnion = this.getRoundTripSerialize(readCodec, writeCodec, TCompactProtocol::new);
        this.assertSerde(typeSignatureParameterUnion);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodec<TypeSignatureParameterUnion> readCodec, ThriftCodec<TypeSignatureParameterUnion> writeCodec) throws Exception {
        TypeSignatureParameterUnion typeSignatureParameterUnion = this.getRoundTripSerialize(readCodec, writeCodec, TFacebookCompactProtocol::new);
        this.assertSerde(typeSignatureParameterUnion);
    }

    private TypeSignatureParameterUnion getRoundTripSerialize(ThriftCodec<TypeSignatureParameterUnion> readCodec, ThriftCodec<TypeSignatureParameterUnion> writeCodec, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write((Object)this.typeSignatureParameterUnion, (TProtocolWriter)protocol);
        return (TypeSignatureParameterUnion)readCodec.read((TProtocolReader)protocol);
    }

    private void assertSerde(TypeSignatureParameterUnion typeSignatureParameterUnion) {
        TypeSignature typeSignature = typeSignatureParameterUnion.getTypeSignature();
        Assert.assertEquals((Object)typeSignature, (Object)FAKE_TYPE_SIGNATURE);
    }
}

