/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import com.facebook.presto.common.array.Long2IntOpenHashMap;
import java.util.HashMap;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLong2IntOpenHashMap {
    private final Random random = new Random();

    @Test
    public void testAddAndGet() {
        this.testAddAndGet(10);
        this.testAddAndGet(1000);
    }

    @Test
    public void testRemove() {
        this.testRemove(10);
        this.testRemove(1000);
    }

    @Test
    public void testNull() {
        this.testNull(10);
        this.testNull(1000);
    }

    private void testAddAndGet(int entries) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        Long2IntOpenHashMap long2IntOpenHashMap = new Long2IntOpenHashMap();
        Assert.assertEquals((int)long2IntOpenHashMap.size(), (int)0);
        int defaultReturnValue = long2IntOpenHashMap.getDefaultReturnValue();
        for (int i = 0; i < entries; ++i) {
            long key2 = this.random.nextInt(1024);
            int value2 = this.random.nextInt(1024);
            Integer oldValue = (Integer)map.get(key2);
            map.put(key2, (oldValue == null ? defaultReturnValue : oldValue) + value2);
            long2IntOpenHashMap.addTo(key2, value2);
            Assert.assertEquals((int)long2IntOpenHashMap.get(key2), (int)((Integer)map.get(key2)));
            if (key2 <= 0L) continue;
            Assert.assertEquals((int)long2IntOpenHashMap.get(-key2), (int)defaultReturnValue);
        }
        Assert.assertEquals((int)map.size(), (int)long2IntOpenHashMap.size());
        map.forEach((key, value) -> Assert.assertEquals((int)long2IntOpenHashMap.get(key.longValue()), (int)value));
    }

    private void testRemove(int entries) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        Long2IntOpenHashMap long2IntOpenHashMap = new Long2IntOpenHashMap();
        long2IntOpenHashMap.setDefaultReturnValue(-1);
        Assert.assertEquals((int)long2IntOpenHashMap.size(), (int)0);
        int defaultReturnValue = long2IntOpenHashMap.getDefaultReturnValue();
        for (int i = 0; i < entries; ++i) {
            long key2 = this.random.nextInt(1024);
            int value2 = this.random.nextInt(1024);
            Integer oldValue = (Integer)map.get(key2);
            map.put(key2, (oldValue == null ? defaultReturnValue : oldValue) + value2);
            long2IntOpenHashMap.addTo(key2, value2);
        }
        Assert.assertEquals((int)long2IntOpenHashMap.size(), (int)map.size());
        map.forEach((key, value) -> {
            if (key > 0L) {
                Assert.assertEquals((int)long2IntOpenHashMap.remove(-key.longValue()), (int)defaultReturnValue);
            }
            Assert.assertEquals((int)long2IntOpenHashMap.remove(key.longValue()), (int)value);
        });
        Assert.assertEquals((int)long2IntOpenHashMap.size(), (int)0);
    }

    private void testNull(int entries) {
        Long2IntOpenHashMap long2IntOpenHashMap = new Long2IntOpenHashMap();
        Assert.assertEquals((boolean)long2IntOpenHashMap.containsNullKey, (boolean)false);
        for (int i = 0; i < entries; ++i) {
            long2IntOpenHashMap.addTo(0L, 1);
            Assert.assertEquals((boolean)long2IntOpenHashMap.containsNullKey, (boolean)true);
            Assert.assertEquals((int)long2IntOpenHashMap.size(), (int)1);
            Assert.assertEquals((int)long2IntOpenHashMap.get(0L), (int)(i + 1));
        }
        int nullCount = long2IntOpenHashMap.remove(0L);
        Assert.assertEquals((int)nullCount, (int)entries);
        Assert.assertEquals((boolean)long2IntOpenHashMap.containsNullKey, (boolean)false);
        Assert.assertEquals((int)long2IntOpenHashMap.size(), (int)0);
        Assert.assertEquals((int)long2IntOpenHashMap.get(0L), (int)long2IntOpenHashMap.getDefaultReturnValue());
    }
}

