/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharEnumType;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeSignature {
    @Test
    public void parseSignatureWithLiterals() {
        TypeSignature result = TypeSignature.parseTypeSignature((String)"decimal(X,42)", (Set)ImmutableSet.of((Object)"X"));
        Assert.assertEquals((int)result.getParameters().size(), (int)2);
        Assert.assertEquals((boolean)((TypeSignatureParameter)result.getParameters().get(0)).isVariable(), (boolean)true);
        Assert.assertEquals((boolean)((TypeSignatureParameter)result.getParameters().get(1)).isLongLiteral(), (boolean)true);
    }

    @Test
    public void parseNamedTypeSignature() {
        TestTypeSignature.assertRowSignature("cat.sch.pair:row(a bigint,b array(bigint),c row(a bigint))", TestTypeSignature.namedRowSignature("cat.sch.pair", TestTypeSignature.namedParameter("a", false, this.signature("bigint")), TestTypeSignature.namedParameter("b", false, TestTypeSignature.array(this.signature("bigint"))), TestTypeSignature.namedParameter("c", false, TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.signature("bigint"))))));
        TestTypeSignature.assertSignature("CAT.SCH.TROW:ROW(a CAT.SCH.TV:VARCHAR,b ARRAY(BIGINT),c ROW(a BIGINT))", "cat.sch.trow:ROW", (List<String>)ImmutableList.of((Object)"a cat.sch.tv:VARCHAR", (Object)"b ARRAY(BIGINT)", (Object)"c ROW(a BIGINT)"), "cat.sch.trow:ROW(a cat.sch.tv:VARCHAR,b ARRAY(BIGINT),c ROW(a BIGINT))");
    }

    @Test
    public void parseRowSignature() {
        TestTypeSignature.assertRowSignature("row(a bigint,b varchar)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.signature("bigint")), TestTypeSignature.namedParameter("b", false, this.varchar())));
        TestTypeSignature.assertRowSignature("row(__a__ bigint,_b@_: _varchar)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("__a__", false, this.signature("bigint")), TestTypeSignature.namedParameter("_b@_:", false, this.signature("_varchar"))));
        TestTypeSignature.assertRowSignature("row(a bigint,b array(bigint),c row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.signature("bigint")), TestTypeSignature.namedParameter("b", false, TestTypeSignature.array(this.signature("bigint"))), TestTypeSignature.namedParameter("c", false, TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("row(a varchar(10),b row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.varchar(10L)), TestTypeSignature.namedParameter("b", false, TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("array(row(col0 bigint,col1 double))", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", false, this.signature("bigint")), TestTypeSignature.namedParameter("col1", false, this.signature("double")))));
        TestTypeSignature.assertRowSignature("row(col0 array(row(col0 bigint,col1 double)))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", false, TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", false, this.signature("bigint")), TestTypeSignature.namedParameter("col1", false, this.signature("double")))))));
        TestTypeSignature.assertRowSignature("row(a decimal(p1,s1),b decimal(p2,s2))", (Set<String>)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2"), TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.decimal("p1", "s1")), TestTypeSignature.namedParameter("b", false, this.decimal("p2", "s2"))));
        TestTypeSignature.assertRowSignature("row(bigint,varchar)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint")), TestTypeSignature.unnamedParameter(this.varchar())));
        TestTypeSignature.assertRowSignature("row(bigint,array(bigint),row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint")), TestTypeSignature.unnamedParameter(TestTypeSignature.array(this.signature("bigint"))), TestTypeSignature.unnamedParameter(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("row(varchar(10),b row(bigint))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.varchar(10L)), TestTypeSignature.namedParameter("b", false, TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("array(row(col0 bigint,double))", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", false, this.signature("bigint")), TestTypeSignature.unnamedParameter(this.signature("double")))));
        TestTypeSignature.assertRowSignature("row(col0 array(row(bigint,double)))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", false, TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint")), TestTypeSignature.unnamedParameter(this.signature("double")))))));
        TestTypeSignature.assertRowSignature("row(a decimal(p1,s1),decimal(p2,s2))", (Set<String>)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2"), TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.decimal("p1", "s1")), TestTypeSignature.unnamedParameter(this.decimal("p2", "s2"))));
        TestTypeSignature.assertRowSignature("row(time time with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("time", false, this.signature("time with time zone"))));
        TestTypeSignature.assertRowSignature("row(time timestamp with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("time", false, this.signature("timestamp with time zone"))));
        TestTypeSignature.assertRowSignature("row(interval interval day to second)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("interval", false, this.signature("interval day to second"))));
        TestTypeSignature.assertRowSignature("row(interval interval year to month)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("interval", false, this.signature("interval year to month"))));
        TestTypeSignature.assertRowSignature("row(double double precision)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("double", false, this.signature("double precision"))));
        TestTypeSignature.assertRowSignature("row(time with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("time with time zone"))));
        TestTypeSignature.assertRowSignature("row(timestamp with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("timestamp with time zone"))));
        TestTypeSignature.assertRowSignature("row(interval day to second)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("interval day to second"))));
        TestTypeSignature.assertRowSignature("row(interval year to month)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("interval year to month"))));
        TestTypeSignature.assertRowSignature("row(double precision)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("double precision"))));
        TestTypeSignature.assertRowSignature("row(array(time with time zone))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(TestTypeSignature.array(this.signature("time with time zone")))));
        TestTypeSignature.assertRowSignature("row(map(timestamp with time zone,interval day to second))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(TestTypeSignature.map(this.signature("timestamp with time zone"), this.signature("interval day to second")))));
        TestTypeSignature.assertRowSignature("row(\"time with time zone\" time with time zone,\"double\" double)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("time with time zone", true, this.signature("time with time zone")), TestTypeSignature.namedParameter("double", true, this.signature("double"))));
        TestTypeSignature.assertSignature("row( time  time with time zone, array( interval day to seconds ) )", "row", (List<String>)ImmutableList.of((Object)"time time with time zone", (Object)"array(interval day to seconds)"), "row(time time with time zone,array(interval day to seconds))");
        TestTypeSignature.assertRowSignature("RoW(a bigint,b varchar)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", false, this.signature("bigint")), TestTypeSignature.namedParameter("b", false, this.varchar())));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"row(col iNt)"), (Object)TypeSignature.parseTypeSignature((String)"row(col integer)"));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"row(a Int(p1))"), (Object)TypeSignature.parseTypeSignature((String)"row(a integer(p1))"));
        TestTypeSignature.assertRowSignature("row(\"time\" with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("time", true, this.signature("with time zone"))));
    }

    private TypeSignature varchar() {
        return new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.of((long)Integer.MAX_VALUE)});
    }

    private TypeSignature varchar(long length) {
        return new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.of((long)length)});
    }

    private TypeSignature decimal(String precisionVariable, String scaleVariable) {
        return new TypeSignature("decimal", (List)ImmutableList.of((Object)TypeSignatureParameter.of((String)precisionVariable), (Object)TypeSignatureParameter.of((String)scaleVariable)));
    }

    private static TypeSignature rowSignature(NamedTypeSignature ... columns) {
        return new TypeSignature("row", Lists.transform(Arrays.asList(columns), TypeSignatureParameter::of));
    }

    private static TypeSignature namedRowSignature(String distinctTypeName, NamedTypeSignature ... columns) {
        return new TypeSignature(distinctTypeName + ":row", Lists.transform(Arrays.asList(columns), TypeSignatureParameter::of));
    }

    private static NamedTypeSignature namedParameter(String name, boolean delimited, TypeSignature value) {
        return new NamedTypeSignature(Optional.of(new RowFieldName(name, delimited)), value);
    }

    private static NamedTypeSignature unnamedParameter(TypeSignature value) {
        return new NamedTypeSignature(Optional.empty(), value);
    }

    private static TypeSignature array(TypeSignature type) {
        return new TypeSignature("array", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)type)});
    }

    private static TypeSignature map(TypeSignature keyType, TypeSignature valueType) {
        return new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)keyType), TypeSignatureParameter.of((TypeSignature)valueType)});
    }

    private TypeSignature signature(String name) {
        return new TypeSignature(name, new TypeSignatureParameter[0]);
    }

    @Test
    public void parseSignature() {
        TestTypeSignature.assertSignature("boolean", "boolean", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("varchar", "varchar", (List<String>)ImmutableList.of((Object)Integer.toString(Integer.MAX_VALUE)));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"int"), (Object)TypeSignature.parseTypeSignature((String)"integer"));
        TestTypeSignature.assertSignature("array(bigint)", "array", (List<String>)ImmutableList.of((Object)"bigint"));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"array(int)"), (Object)TypeSignature.parseTypeSignature((String)"array(integer)"));
        TestTypeSignature.assertSignature("array(array(bigint))", "array", (List<String>)ImmutableList.of((Object)"array(bigint)"));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"array(array(int))"), (Object)TypeSignature.parseTypeSignature((String)"array(array(integer))"));
        TestTypeSignature.assertSignature("array(timestamp with time zone)", "array", (List<String>)ImmutableList.of((Object)"timestamp with time zone"));
        TestTypeSignature.assertSignature("map(bigint,bigint)", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"bigint"));
        TestTypeSignature.assertSignature("map(bigint,array(bigint))", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"array(bigint)"));
        TestTypeSignature.assertSignature("map(bigint,map(bigint,map(varchar,bigint)))", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"map(bigint,map(varchar,bigint))"));
        this.assertSignatureFail("blah()");
        this.assertSignatureFail("array()");
        this.assertSignatureFail("map()");
        this.assertSignatureFail("x", (Set<String>)ImmutableSet.of((Object)"x"));
        TestTypeSignature.assertSignature("rowxxx(a)", "rowxxx", (List<String>)ImmutableList.of((Object)"a"));
    }

    @Test
    public void parseWithLiteralParameters() {
        TestTypeSignature.assertSignature("foo(42)", "foo", (List<String>)ImmutableList.of((Object)"42"));
        TestTypeSignature.assertSignature("varchar(10)", "varchar", (List<String>)ImmutableList.of((Object)"10"));
    }

    @Test
    public void testVarchar() {
        Assert.assertEquals((String)VarcharType.VARCHAR.getTypeSignature().toString(), (String)"varchar");
        Assert.assertEquals((String)VarcharType.createVarcharType((int)42).getTypeSignature().toString(), (String)"varchar(42)");
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"varchar"), (Object)VarcharType.createUnboundedVarcharType().getTypeSignature());
        Assert.assertEquals((Object)VarcharType.createUnboundedVarcharType().getTypeSignature(), (Object)TypeSignature.parseTypeSignature((String)"varchar"));
        Assert.assertEquals((int)TypeSignature.parseTypeSignature((String)"varchar").hashCode(), (int)VarcharType.createUnboundedVarcharType().getTypeSignature().hashCode());
        Assert.assertNotEquals((Object)VarcharType.createUnboundedVarcharType().getTypeSignature(), (Object)TypeSignature.parseTypeSignature((String)"varchar(10)"));
    }

    @Test
    public void testIsCalculated() {
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"bigint").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"decimal(p, s)", (Set)ImmutableSet.of((Object)"p", (Object)"s")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"decimal(2, 1)").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"array(decimal(p, s))", (Set)ImmutableSet.of((Object)"p", (Object)"s")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"array(decimal(2, 1))").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"map(decimal(p1, s1),decimal(p2, s2))", (Set)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"map(decimal(2, 1),decimal(3, 1))").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"row(a decimal(p1,s1),b decimal(p2,s2))", (Set)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"row(a decimal(2,1),b decimal(3,2))").isCalculated());
    }

    @Test
    public void testEnumSignature() {
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"VarcharEnum(test.enum.test_enum{\"test\" :\"EI======\", \"hello\": \"EA======\" , \"a\":\"PV5XW===\" })"), (Object)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.test_enum", (Map)ImmutableMap.of((Object)"a", (Object)"}{{", (Object)"hello", (Object)" ", (Object)"test", (Object)"\""))).getTypeSignature());
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"VarcharEnum(test.enum.test_enum{\"my  key\" :\"4CSK5YFFQLQKJMXAUWG6BJFP\"})"), (Object)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.test_enum", (Map)ImmutableMap.of((Object)"my  key", (Object)"\u092e\u0942\u0932\u094d\u092f"))).getTypeSignature());
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"bigintenum(TEST.ENUM.OTHER_ENUM{\"hello\" :  -5, \"AaA\"  : 9999 })"), (Object)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.other_enum", (Map)ImmutableMap.of((Object)"hello", (Object)-5L, (Object)"AAA", (Object)9999L))).getTypeSignature());
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"VarcharEnum(test.enum.my_enum{\"))(\" :\"FF5X2===\"})"), (Object)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"))(", (Object)"){}"))).getTypeSignature());
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"map(VarcharEnum(test.enum.my_enum{\"k\": \"OYUSSKI=\"}), BigintEnum(test.enum.my_enum_2{\"k\": 1}))"), (Object)new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.my_enum_2", (Map)ImmutableMap.of((Object)"k", (Object)1L))).getTypeSignature())}));
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\"})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\", 2})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{a: 2})");
        this.assertSignatureFail("VarcharEnum(test.enum.test_enum{\"a\" \"b\"})");
        this.assertSignatureFail("VarcharEnum(test.enum.test_enum{:\"a\"})");
        this.assertSignatureFail("VarcharEnum(test.enum.test_enum{,\"a\"})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{{\"a\": 2})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"a\":: 2})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": {\"k1\": 1}})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": 2}haha)");
        this.assertSignatureFail("VarcharEnum(test.enum.test_enum{\"k\": 2})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": \"2\"})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": 2-})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": -})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": 2.29})");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": \"2})");
        this.assertSignatureFail("VarcharEnum(test.enum.test_enum{\"k\": \"2\")");
        this.assertSignatureFail("BigintEnum(test.enum.test_enum{\"k\": \"2\"}");
    }

    private static void assertRowSignature(String typeName, Set<String> literalParameters, TypeSignature expectedSignature) {
        TypeSignature signature = TypeSignature.parseTypeSignature((String)typeName, literalParameters);
        Assert.assertEquals((Object)signature, (Object)expectedSignature);
        Assert.assertEquals((String)signature.toString(), (String)typeName);
    }

    private static void assertRowSignature(String typeName, TypeSignature expectedSignature) {
        TestTypeSignature.assertRowSignature(typeName, (Set<String>)ImmutableSet.of(), expectedSignature);
    }

    private static void assertSignature(String typeName, String base, List<String> parameters) {
        TestTypeSignature.assertSignature(typeName, base, parameters, typeName.replace("<", "(").replace(">", ")"));
    }

    private static void assertSignature(String typeName, String base, List<String> parameters, String expectedTypeName) {
        TypeSignature signature = TypeSignature.parseTypeSignature((String)typeName);
        Assert.assertEquals((String)signature.getBase(), (String)base);
        Assert.assertEquals((int)signature.getParameters().size(), (int)parameters.size());
        for (int i = 0; i < signature.getParameters().size(); ++i) {
            Assert.assertEquals((String)((TypeSignatureParameter)signature.getParameters().get(i)).toString(), (String)parameters.get(i));
        }
        Assert.assertEquals((String)signature.toString(), (String)expectedTypeName);
    }

    private void assertSignatureFail(String typeName) {
        try {
            TypeSignature.parseTypeSignature((String)typeName);
            Assert.fail((String)"Type signature should fail to parse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void assertSignatureFail(String typeName, Set<String> literalCalculationParameters) {
        try {
            TypeSignature.parseTypeSignature((String)typeName, literalCalculationParameters);
            Assert.fail((String)"Type signature should fail to parse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

