/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.predicate;

import com.facebook.presto.common.array.ByteArrayUtils;
import com.facebook.presto.common.predicate.TupleDomainFilterUtils;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;

public interface TupleDomainFilter {
    public static final TupleDomainFilter ALWAYS_FALSE = new AlwaysFalse();
    public static final TupleDomainFilter IS_NULL = new IsNull();
    public static final TupleDomainFilter IS_NOT_NULL = new IsNotNull();

    public boolean isDeterministic();

    public boolean testNull();

    public boolean testNonNull();

    public boolean testLong(long var1);

    public boolean testDouble(double var1);

    public boolean testFloat(float var1);

    public boolean testDecimal(long var1, long var3);

    public boolean testBoolean(boolean var1);

    public boolean testBytes(byte[] var1, int var2, int var3);

    public boolean testLength(int var1);

    public int getPrecedingPositionsToFail();

    public int getSucceedingPositionsToFail();

    public boolean isPositionalFilter();

    public static class NullsFilter
    extends BasePositionalFilter {
        private boolean[] nullsAllowed;
        private boolean[] nonNullsAllowed;

        public void setup(boolean[] nullsAllowed, boolean[] nonNullsAllowed, int[] offsets) {
            this.nullsAllowed = Objects.requireNonNull(nullsAllowed, "nullsAllowed is null");
            this.nonNullsAllowed = Objects.requireNonNull(nonNullsAllowed, "nonNullsAllowed is null");
            this.offsets = Objects.requireNonNull(offsets, "offsets is null");
            this.reset();
        }

        @Override
        public boolean testNull() {
            this.advance();
            return this.recordTestResult(this.nullsAllowed[this.filterIndex++]);
        }

        @Override
        public boolean testNonNull() {
            this.advance();
            return this.recordTestResult(this.nonNullsAllowed[this.filterIndex++]);
        }

        @Override
        public boolean testLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testFloat(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testDecimal(long low, long high) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testBoolean(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testLength(int length) {
            throw new UnsupportedOperationException();
        }
    }

    public static class PositionalFilter
    extends BasePositionalFilter {
        private TupleDomainFilter[] filters;

        public void setFilters(TupleDomainFilter[] filters, int[] offsets) {
            this.filters = Objects.requireNonNull(filters, "filters is null");
            this.offsets = Objects.requireNonNull(offsets, "offsets is null");
            this.reset();
        }

        @Override
        public boolean testNull() {
            this.advance();
            TupleDomainFilter filter = this.filters[this.filterIndex++];
            if (filter == null) {
                return true;
            }
            return this.recordTestResult(filter.testNull());
        }

        @Override
        public boolean testNonNull() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testLong(long value) {
            this.advance();
            TupleDomainFilter filter = this.filters[this.filterIndex++];
            if (filter == null) {
                return true;
            }
            return this.recordTestResult(filter.testLong(value));
        }

        @Override
        public boolean testDouble(double value) {
            this.advance();
            TupleDomainFilter filter = this.filters[this.filterIndex++];
            if (filter == null) {
                return true;
            }
            return this.recordTestResult(filter.testDouble(value));
        }

        @Override
        public boolean testFloat(float value) {
            this.advance();
            TupleDomainFilter filter = this.filters[this.filterIndex++];
            if (filter == null) {
                return true;
            }
            return this.recordTestResult(filter.testFloat(value));
        }

        @Override
        public boolean testDecimal(long low, long high) {
            this.advance();
            TupleDomainFilter filter = this.filters[this.filterIndex++];
            if (filter == null) {
                return true;
            }
            return this.recordTestResult(filter.testDecimal(low, high));
        }

        @Override
        public boolean testBoolean(boolean value) {
            this.advance();
            TupleDomainFilter filter = this.filters[this.filterIndex++];
            if (filter == null) {
                return true;
            }
            return this.recordTestResult(filter.testBoolean(value));
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            this.advance();
            TupleDomainFilter filter = this.filters[this.filterIndex++];
            if (filter == null) {
                return true;
            }
            return this.recordTestResult(filter.testBytes(buffer, offset, length));
        }

        @Override
        public boolean testLength(int length) {
            return true;
        }
    }

    public static abstract class BasePositionalFilter
    implements TupleDomainFilter {
        protected int filterIndex;
        protected int[] offsets;
        private int offsetIndex;
        private boolean[] failed;
        private int precedingPositionsToFail;
        private int succeedingPositionsToFail;

        @Override
        public boolean isDeterministic() {
            return false;
        }

        public boolean[] getFailed() {
            return this.failed;
        }

        @Override
        public int getPrecedingPositionsToFail() {
            return this.precedingPositionsToFail;
        }

        @Override
        public int getSucceedingPositionsToFail() {
            return this.succeedingPositionsToFail;
        }

        @Override
        public boolean isPositionalFilter() {
            return true;
        }

        protected void reset() {
            this.filterIndex = 0;
            this.offsetIndex = 1;
            if (this.failed == null || this.failed.length < this.offsets.length) {
                this.failed = new boolean[this.offsets.length];
            } else {
                Arrays.fill(this.failed, false);
            }
            this.failed[0] = false;
            this.precedingPositionsToFail = 0;
            this.succeedingPositionsToFail = 0;
        }

        protected void advance() {
            while (this.filterIndex == this.offsets[this.offsetIndex]) {
                this.precedingPositionsToFail = 0;
                this.succeedingPositionsToFail = 0;
                this.failed[this.offsetIndex] = false;
                ++this.offsetIndex;
            }
        }

        protected boolean recordTestResult(boolean result) {
            if (!result) {
                this.failed[this.offsetIndex - 1] = true;
                this.precedingPositionsToFail = this.filterIndex - this.offsets[this.offsetIndex - 1] - 1;
                this.succeedingPositionsToFail = this.offsets[this.offsetIndex] - this.filterIndex;
                this.filterIndex = this.offsets[this.offsetIndex];
            }
            return result;
        }
    }

    public static class MultiRange
    extends AbstractTupleDomainFilter {
        private final TupleDomainFilter[] filters;
        private final boolean nanAllowedAndUsesOldNanDefinition;

        private MultiRange(List<TupleDomainFilter> filters, boolean nullAllowed, boolean nanAllowedAndUsesOldNanDefinition) {
            super(true, nullAllowed);
            Objects.requireNonNull(filters, "filters is null");
            TupleDomainFilterUtils.checkArgument(filters.size() > 1, "filters must contain at least 2 entries");
            this.filters = filters.toArray(new TupleDomainFilter[0]);
            this.nanAllowedAndUsesOldNanDefinition = nanAllowedAndUsesOldNanDefinition;
        }

        public static MultiRange of(List<TupleDomainFilter> filters, boolean nullAllowed, boolean nanAllowedAndUsesOldNanDefinition) {
            return new MultiRange(filters, nullAllowed, nanAllowedAndUsesOldNanDefinition);
        }

        @Override
        public boolean testDouble(double value) {
            if (Double.isNaN(value) && this.nanAllowedAndUsesOldNanDefinition) {
                return true;
            }
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testDouble(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testFloat(float value) {
            if (Float.isNaN(value) && this.nanAllowedAndUsesOldNanDefinition) {
                return this.nanAllowedAndUsesOldNanDefinition;
            }
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testFloat(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testDecimal(low, high)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testBytes(buffer, offset, length)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testLength(int length) {
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testLength(length)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiRange that = (MultiRange)o;
            return Arrays.equals(this.filters, that.filters) && this.nullAllowed == that.nullAllowed && this.nanAllowedAndUsesOldNanDefinition == that.nanAllowedAndUsesOldNanDefinition;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.filters), this.nullAllowed, this.nanAllowedAndUsesOldNanDefinition);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{filters='").append(Arrays.toString(this.filters));
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append(", nanAllowedAndUsesOldNanDefinition=").append(this.nanAllowedAndUsesOldNanDefinition);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class BigintMultiRange
    extends AbstractTupleDomainFilter {
        private final BigintRange[] ranges;
        private final long[] longLowerBounds;

        private BigintMultiRange(List<BigintRange> ranges, boolean nullAllowed) {
            super(true, nullAllowed);
            Objects.requireNonNull(ranges, "ranges is null");
            TupleDomainFilterUtils.checkArgument(!ranges.isEmpty(), "ranges is empty");
            this.ranges = ranges.toArray(new BigintRange[0]);
            this.longLowerBounds = ranges.stream().mapToLong(BigintRange::getLower).toArray();
            for (int i = 1; i < this.longLowerBounds.length; ++i) {
                TupleDomainFilterUtils.checkArgument(this.longLowerBounds[i] >= ranges.get(i - 1).getUpper(), "bigint ranges must not overlap");
            }
        }

        public static BigintMultiRange of(List<BigintRange> ranges, boolean nullAllowed) {
            return new BigintMultiRange(ranges, nullAllowed);
        }

        @Override
        public boolean testLong(long value) {
            int i = Arrays.binarySearch(this.longLowerBounds, value);
            if (i >= 0) {
                return true;
            }
            int place = -i - 1;
            if (place == 0) {
                return false;
            }
            return this.ranges[place - 1].testLong(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigintMultiRange that = (BigintMultiRange)o;
            return Arrays.equals(this.ranges, that.ranges) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.ranges), this.nullAllowed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{ranges='").append(Arrays.toString(this.ranges));
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class BytesValuesExclusive
    extends AbstractTupleDomainFilter {
        private final BytesValues delegate;

        private BytesValuesExclusive(byte[][] values, boolean nullAllowed) {
            super(true, nullAllowed);
            this.delegate = BytesValues.of(values, nullAllowed);
        }

        public static BytesValuesExclusive of(byte[][] values, boolean nullAllowed) {
            return new BytesValuesExclusive(values, nullAllowed);
        }

        @Override
        public boolean testBytes(byte[] value, int offset, int length) {
            if (!this.delegate.testLength(length)) {
                return true;
            }
            return !this.delegate.testBytes(value, offset, length);
        }

        @Override
        public boolean testLength(int length) {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BytesValuesExclusive that = (BytesValuesExclusive)o;
            return this.nullAllowed == that.nullAllowed && this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate, this.nullAllowed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{delegate='").append(this.delegate);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class BytesValues
    extends AbstractTupleDomainFilter {
        private final byte[][] values;
        private final byte[][] hashTable;
        private final int hashTableSizeMask;
        private final long[] bloom;
        private final int bloomSize;
        private final boolean[] lengthExists;

        private BytesValues(byte[][] values, boolean nullAllowed) {
            super(true, nullAllowed);
            Objects.requireNonNull(values, "values is null");
            TupleDomainFilterUtils.checkArgument(values.length > 0, "values must not be empty");
            this.values = values;
            this.lengthExists = new boolean[Arrays.stream(values).mapToInt(value -> ((byte[])value).length).max().getAsInt() + 1];
            int hashTableSize = Integer.highestOneBit(values.length * 4);
            this.hashTableSizeMask = hashTableSize - 1;
            this.hashTable = new byte[hashTableSize][];
            this.bloomSize = Math.max(1, hashTableSize / 8);
            this.bloom = new long[this.bloomSize];
            block0: for (byte[] value2 : values) {
                int position;
                this.lengthExists[value2.length] = true;
                long hashCode = ByteArrayUtils.hash(value2, 0, value2.length);
                int n = this.bloomIndex(hashCode);
                this.bloom[n] = this.bloom[n] | BytesValues.bloomMask(hashCode);
                for (int i = position = (int)(hashCode & (long)this.hashTableSizeMask); i <= position + this.hashTableSizeMask; ++i) {
                    int index = i & this.hashTableSizeMask;
                    if (this.hashTable[index] == null) {
                        this.hashTable[index] = value2;
                        continue block0;
                    }
                    if (ByteArrayUtils.compareRanges(value2, 0, value2.length, this.hashTable[index], 0, this.hashTable[index].length) == 0) continue block0;
                }
            }
        }

        public static BytesValues of(byte[][] values, boolean nullAllowed) {
            return new BytesValues(values, nullAllowed);
        }

        @Override
        public boolean testBytes(byte[] value, int offset, int length) {
            int position;
            long hashCode = ByteArrayUtils.hash(value, offset, length);
            if (!this.testBloom(hashCode)) {
                return false;
            }
            for (int i = position = (int)(hashCode & (long)this.hashTableSizeMask); i <= position + this.hashTableSizeMask; ++i) {
                int index = i & this.hashTableSizeMask;
                byte[] entry = this.hashTable[index];
                if (entry == null) {
                    return false;
                }
                if (ByteArrayUtils.compareRanges(value, offset, length, entry, 0, entry.length) != 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testLength(int length) {
            return length < this.lengthExists.length && this.lengthExists[length];
        }

        private static long bloomMask(long hashCode) {
            return 1L << (int)(hashCode >> 20 & 0x3FL) | 1L << (int)(hashCode >> 26 & 0x3FL) | 1L << (int)(hashCode >> 32 & 0x3FL);
        }

        private int bloomIndex(long hashCode) {
            return (int)(hashCode >> 38 & (long)(this.bloomSize - 1));
        }

        private boolean testBloom(long hashCode) {
            int index;
            long mask = BytesValues.bloomMask(hashCode);
            return mask == (this.bloom[index = this.bloomIndex(hashCode)] & mask);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BytesValues that = (BytesValues)o;
            return this.nullAllowed == that.nullAllowed && Arrays.deepEquals((Object[])this.values, (Object[])that.values);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode((Object[])this.values), this.nullAllowed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{values='").append(Arrays.toString((Object[])this.values));
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class BytesRange
    extends AbstractTupleDomainFilter {
        private final byte[] lower;
        private final byte[] upper;
        private final boolean lowerExclusive;
        private final boolean upperExclusive;
        private final boolean singleValue;

        private BytesRange(byte[] lower, boolean lowerExclusive, byte[] upper, boolean upperExclusive, boolean nullAllowed) {
            super(true, nullAllowed);
            this.lower = lower;
            this.upper = upper;
            this.lowerExclusive = lowerExclusive;
            this.upperExclusive = upperExclusive;
            this.singleValue = !lowerExclusive && !upperExclusive && Arrays.equals(upper, lower);
        }

        public static BytesRange of(byte[] lower, boolean lowerExclusive, byte[] upper, boolean upperExclusive, boolean nullAllowed) {
            return new BytesRange(lower, lowerExclusive, upper, upperExclusive, nullAllowed);
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            int compare;
            if (this.singleValue) {
                if (length != this.lower.length) {
                    return false;
                }
                for (int i = 0; i < length; ++i) {
                    if (buffer[i + offset] == this.lower[i]) continue;
                    return false;
                }
                return true;
            }
            if (this.lower != null && ((compare = ByteArrayUtils.compareRanges(buffer, offset, length, this.lower, 0, this.lower.length)) < 0 || this.lowerExclusive && compare == 0)) {
                return false;
            }
            if (this.upper != null) {
                compare = ByteArrayUtils.compareRanges(buffer, offset, length, this.upper, 0, this.upper.length);
                return compare < 0 || !this.upperExclusive && compare == 0;
            }
            return true;
        }

        @Override
        public boolean testLength(int length) {
            return !this.singleValue || this.lower.length == length;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.lower), this.lowerExclusive, Arrays.hashCode(this.upper), this.upperExclusive, this.nullAllowed);
        }

        public boolean isSingleValue() {
            return this.singleValue;
        }

        public byte[] getLower() {
            return this.lower;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BytesRange other = (BytesRange)obj;
            return Arrays.equals(this.lower, other.lower) && this.lowerExclusive == other.lowerExclusive && Arrays.equals(this.upper, other.upper) && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{lower='").append(Arrays.toString(this.lower));
            sb.append(", lowerExclusive=").append(this.lowerExclusive);
            sb.append(", upper='").append(Arrays.toString(this.upper));
            sb.append(", upperExclusive=").append(this.upperExclusive);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class LongDecimalRange
    extends AbstractRange {
        private final long lowerLow;
        private final long lowerHigh;
        private final long upperLow;
        private final long upperHigh;

        private LongDecimalRange(long lowerLow, long lowerHigh, boolean lowerUnbounded, boolean lowerExclusive, long upperLow, long upperHigh, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            this.lowerLow = lowerLow;
            this.lowerHigh = lowerHigh;
            this.upperLow = upperLow;
            this.upperHigh = upperHigh;
        }

        public static LongDecimalRange of(long lowerLow, long lowerHigh, boolean lowerUnbounded, boolean lowerExclusive, long upperLow, long upperHigh, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new LongDecimalRange(lowerLow, lowerHigh, lowerUnbounded, lowerExclusive, upperLow, upperHigh, upperUnbounded, upperExclusive, nullAllowed);
        }

        @Override
        public boolean testDecimal(long valueLow, long valueHigh) {
            int result;
            if (!this.lowerUnbounded) {
                result = UnscaledDecimal128Arithmetic.compare(valueLow, valueHigh, this.lowerLow, this.lowerHigh);
                if (result < 0) {
                    return false;
                }
                if (this.lowerExclusive && result == 0) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                result = UnscaledDecimal128Arithmetic.compare(valueLow, valueHigh, this.upperLow, this.upperHigh);
                if (result > 0) {
                    return false;
                }
                if (this.upperExclusive && result == 0) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.lowerLow, this.lowerHigh, this.lowerUnbounded, this.lowerExclusive, this.upperLow, this.upperHigh, this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LongDecimalRange other = (LongDecimalRange)obj;
            return this.lowerLow == other.lowerLow && this.lowerHigh == other.lowerHigh && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && this.upperLow == other.upperLow && this.upperHigh == other.upperHigh && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{lowerLow='").append(this.lowerLow);
            sb.append(", lowerHigh=").append(this.lowerHigh);
            sb.append(", lowerUnbounded=").append(this.lowerUnbounded);
            sb.append(", lowerExclusive=").append(this.lowerExclusive);
            sb.append(", upperLow='").append(this.upperLow);
            sb.append(", upperHigh='").append(this.upperHigh);
            sb.append(", upperUnbounded=").append(this.upperUnbounded);
            sb.append(", upperExclusive=").append(this.upperExclusive);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    @Deprecated
    public static class OldFloatRange
    extends AbstractRange {
        private final float lower;
        private final float upper;

        private OldFloatRange(float lower, boolean lowerUnbounded, boolean lowerExclusive, float upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            TupleDomainFilterUtils.checkArgument(lowerUnbounded || !Float.isNaN(lower), "lower should either be unbounded or not NaN");
            TupleDomainFilterUtils.checkArgument(upperUnbounded || !Float.isNaN(upper), "upper should either be unbounded or not NaN");
            this.lower = lower;
            this.upper = upper;
        }

        public static OldFloatRange of(float lower, boolean lowerUnbounded, boolean lowerExclusive, float upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new OldFloatRange(lower, lowerUnbounded, lowerExclusive, upper, upperUnbounded, upperExclusive, nullAllowed);
        }

        @Override
        public boolean testFloat(float value) {
            if (Float.isNaN(value)) {
                return false;
            }
            if (!this.lowerUnbounded) {
                if (value < this.lower) {
                    return false;
                }
                if (this.lowerExclusive && this.lower == value) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                if (value > this.upper) {
                    return false;
                }
                if (this.upperExclusive && value == this.upper) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.lower), this.lowerUnbounded, this.lowerExclusive, Float.valueOf(this.upper), this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OldFloatRange other = (OldFloatRange)obj;
            return this.lower == other.lower && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && this.upper == other.upper && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{lower='").append(this.lower);
            sb.append(", lowerUnbounded=").append(this.lowerUnbounded);
            sb.append(", lowerExclusive=").append(this.lowerExclusive);
            sb.append(", upper='").append(this.upper);
            sb.append(", upperUnbounded=").append(this.upperUnbounded);
            sb.append(", upperExclusive=").append(this.upperExclusive);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class FloatRange
    extends AbstractRange {
        private final float lower;
        private final float upper;

        private FloatRange(float lower, boolean lowerUnbounded, boolean lowerExclusive, float upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            this.lower = lower;
            this.upper = upper;
        }

        public static FloatRange of(float lower, boolean lowerUnbounded, boolean lowerExclusive, float upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new FloatRange(lower, lowerUnbounded, lowerExclusive, upper, upperUnbounded, upperExclusive, nullAllowed);
        }

        @Override
        public boolean testFloat(float value) {
            int comparison;
            if (!this.lowerUnbounded) {
                comparison = TypeUtils.realCompare(value, this.lower);
                if (comparison == -1) {
                    return false;
                }
                if (this.lowerExclusive && comparison == 0) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                comparison = TypeUtils.realCompare(value, this.upper);
                if (comparison == 1) {
                    return false;
                }
                if (this.upperExclusive && comparison == 0) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(TypeUtils.realHashCode(this.lower), this.lowerUnbounded, this.lowerExclusive, TypeUtils.realHashCode(this.upper), this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FloatRange other = (FloatRange)obj;
            return TypeUtils.realEquals(this.lower, other.lower) && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && TypeUtils.realEquals(this.upper, other.upper) && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{lower='").append(this.lower);
            sb.append(", lowerUnbounded=").append(this.lowerUnbounded);
            sb.append(", lowerExclusive=").append(this.lowerExclusive);
            sb.append(", upper='").append(this.upper);
            sb.append(", upperUnbounded=").append(this.upperUnbounded);
            sb.append(", upperExclusive=").append(this.upperExclusive);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    @Deprecated
    public static class OldDoubleRange
    extends AbstractRange {
        private final double lower;
        private final double upper;

        protected OldDoubleRange(double lower, boolean lowerUnbounded, boolean lowerExclusive, double upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            TupleDomainFilterUtils.checkArgument(lowerUnbounded || !Double.isNaN(lower), "lower should either be unbounded or not NaN");
            TupleDomainFilterUtils.checkArgument(upperUnbounded || !Double.isNaN(upper), "upper should either be unbounded or not NaN");
            this.lower = lower;
            this.upper = upper;
        }

        public static OldDoubleRange of(double lower, boolean lowerUnbounded, boolean lowerExclusive, double upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new OldDoubleRange(lower, lowerUnbounded, lowerExclusive, upper, upperUnbounded, upperExclusive, nullAllowed);
        }

        public double getLower() {
            return this.lower;
        }

        public double getUpper() {
            return this.upper;
        }

        @Override
        public boolean testDouble(double value) {
            if (Double.isNaN(value)) {
                return false;
            }
            if (!this.lowerUnbounded) {
                if (value < this.lower) {
                    return false;
                }
                if (this.lowerExclusive && this.lower == value) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                if (value > this.upper) {
                    return false;
                }
                if (this.upperExclusive && value == this.upper) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.lower, this.lowerUnbounded, this.lowerExclusive, this.upper, this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OldDoubleRange other = (OldDoubleRange)obj;
            return this.lower == other.lower && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && this.upper == other.upper && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{lower='").append(this.lower);
            sb.append(", lowerUnbounded=").append(this.lowerUnbounded);
            sb.append(", lowerExclusive=").append(this.lowerExclusive);
            sb.append(", upper='").append(this.upper);
            sb.append(", upperUnbounded=").append(this.upperUnbounded);
            sb.append(", upperExclusive=").append(this.upperExclusive);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class DoubleRange
    extends AbstractRange {
        private final double lower;
        private final double upper;

        protected DoubleRange(double lower, boolean lowerUnbounded, boolean lowerExclusive, double upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            this.lower = lower;
            this.upper = upper;
        }

        public static DoubleRange of(double lower, boolean lowerUnbounded, boolean lowerExclusive, double upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new DoubleRange(lower, lowerUnbounded, lowerExclusive, upper, upperUnbounded, upperExclusive, nullAllowed);
        }

        public double getLower() {
            return this.lower;
        }

        public double getUpper() {
            return this.upper;
        }

        @Override
        public boolean testDouble(double value) {
            int comparison;
            if (!this.lowerUnbounded) {
                comparison = TypeUtils.doubleCompare(value, this.lower);
                if (comparison == -1) {
                    return false;
                }
                if (this.lowerExclusive && comparison == 0) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                comparison = TypeUtils.doubleCompare(value, this.upper);
                if (comparison == 1) {
                    return false;
                }
                if (this.upperExclusive && comparison == 0) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(TypeUtils.doubleHashCode(this.lower), this.lowerUnbounded, this.lowerExclusive, TypeUtils.doubleHashCode(this.upper), this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DoubleRange other = (DoubleRange)obj;
            return TypeUtils.doubleEquals(this.lower, other.lower) && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && TypeUtils.doubleEquals(this.upper, other.upper) && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{lower='").append(this.lower);
            sb.append(", lowerUnbounded=").append(this.lowerUnbounded);
            sb.append(", lowerExclusive=").append(this.lowerExclusive);
            sb.append(", upper='").append(this.upper);
            sb.append(", upperUnbounded=").append(this.upperUnbounded);
            sb.append(", upperExclusive=").append(this.upperExclusive);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class AbstractRange
    extends AbstractTupleDomainFilter {
        protected final boolean lowerUnbounded;
        protected final boolean lowerExclusive;
        protected final boolean upperUnbounded;
        protected final boolean upperExclusive;

        private AbstractRange(boolean lowerUnbounded, boolean lowerExclusive, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(true, nullAllowed);
            this.lowerUnbounded = lowerUnbounded;
            this.lowerExclusive = lowerExclusive;
            this.upperUnbounded = upperUnbounded;
            this.upperExclusive = upperExclusive;
        }

        public boolean getLowerUnbounded() {
            return this.lowerUnbounded;
        }

        public boolean getLowerExclusive() {
            return this.lowerExclusive;
        }

        public boolean getUpperUnbounded() {
            return this.upperUnbounded;
        }

        public boolean getUpperExclusive() {
            return this.upperExclusive;
        }
    }

    public static class BigintValuesUsingBitmask
    extends AbstractTupleDomainFilter {
        private final BitSet bitmask;
        private final long min;
        private final long max;

        private BigintValuesUsingBitmask(long min, long max, long[] values, boolean nullAllowed) {
            super(true, nullAllowed);
            Objects.requireNonNull(values, "values is null");
            TupleDomainFilterUtils.checkArgument(min < max, "min must be less than max");
            TupleDomainFilterUtils.checkArgument(values.length > 1, "values must contain at least 2 entries");
            this.min = min;
            this.max = max;
            this.bitmask = new BitSet(Math.toIntExact(max - min + 1L));
            for (int i = 0; i < values.length; ++i) {
                this.bitmask.set((int)(values[i] - min));
            }
        }

        public static BigintValuesUsingBitmask of(long min, long max, long[] values, boolean nullAllowed) {
            return new BigintValuesUsingBitmask(min, max, values, nullAllowed);
        }

        @Override
        public boolean testLong(long value) {
            if (value < this.min || value > this.max) {
                return false;
            }
            return this.bitmask.get((int)(value - this.min));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigintValuesUsingBitmask that = (BigintValuesUsingBitmask)o;
            return this.min == that.min && this.max == that.max && this.bitmask.equals(that.bitmask) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max, this.bitmask, this.nullAllowed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{min='").append(this.min);
            sb.append(", max=").append(this.max);
            sb.append(", bitmask=").append(this.bitmask);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class BigintValuesUsingHashTable
    extends AbstractTupleDomainFilter {
        private static final long EMPTY_MARKER = -2401053089476968723L;
        private static final long M = -4132994306676758123L;
        private final long min;
        private final long max;
        private final long[] hashTable;
        private final int size;
        private boolean containsEmptyMarker;

        private BigintValuesUsingHashTable(long min, long max, long[] values, boolean nullAllowed) {
            super(true, nullAllowed);
            Objects.requireNonNull(values, "values is null");
            TupleDomainFilterUtils.checkArgument(min < max, "min must be less than max");
            TupleDomainFilterUtils.checkArgument(values.length > 1, "values must contain at least 2 entries");
            this.min = min;
            this.max = max;
            this.size = Integer.highestOneBit(values.length * 3);
            this.hashTable = new long[this.size];
            Arrays.fill(this.hashTable, -2401053089476968723L);
            block0: for (long value : values) {
                int position;
                if (value == -2401053089476968723L) {
                    this.containsEmptyMarker = true;
                    continue;
                }
                for (int i = position = (int)(value * -4132994306676758123L & (long)(this.size - 1)); i < position + this.size; ++i) {
                    int index = i & this.size - 1;
                    if (this.hashTable[index] != -2401053089476968723L) continue;
                    this.hashTable[index] = value;
                    continue block0;
                }
            }
        }

        public static BigintValuesUsingHashTable of(long min, long max, long[] values, boolean nullAllowed) {
            return new BigintValuesUsingHashTable(min, max, values, nullAllowed);
        }

        @Override
        public boolean testLong(long value) {
            int pos;
            if (this.containsEmptyMarker && value == -2401053089476968723L) {
                return true;
            }
            if (value < this.min || value > this.max) {
                return false;
            }
            for (int i = pos = (int)(value * -4132994306676758123L & (long)(this.size - 1)); i < pos + this.size; ++i) {
                int idx = i & this.size - 1;
                long l = this.hashTable[idx];
                if (l == -2401053089476968723L) {
                    return false;
                }
                if (l != value) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigintValuesUsingHashTable that = (BigintValuesUsingHashTable)o;
            return this.size == that.size && this.containsEmptyMarker == that.containsEmptyMarker && Arrays.equals(this.hashTable, that.hashTable) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max, this.size, this.containsEmptyMarker, Arrays.hashCode(this.hashTable), this.nullAllowed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{min='").append(this.min);
            sb.append(", max=").append(this.max);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class BigintRange
    extends AbstractTupleDomainFilter {
        private final long lower;
        private final long upper;

        protected BigintRange(long lower, long upper, boolean nullAllowed) {
            super(true, nullAllowed);
            TupleDomainFilterUtils.checkArgument(lower <= upper, "lower must be less than or equal to upper");
            this.lower = lower;
            this.upper = upper;
        }

        public static BigintRange of(long lower, long upper, boolean nullAllowed) {
            return new BigintRange(lower, upper, nullAllowed);
        }

        @Override
        public boolean testLong(long value) {
            return value >= this.lower && value <= this.upper;
        }

        public long getLower() {
            return this.lower;
        }

        public long getUpper() {
            return this.upper;
        }

        public boolean isSingleValue() {
            return this.upper == this.lower;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigintRange that = (BigintRange)o;
            return this.lower == that.lower && this.upper == that.upper && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.lower, this.upper, this.nullAllowed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{lower='").append(this.lower);
            sb.append(", upper=").append(this.upper);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class BooleanValue
    extends AbstractTupleDomainFilter {
        private final boolean value;

        private BooleanValue(boolean value, boolean nullAllowed) {
            super(true, nullAllowed);
            this.value = value;
        }

        public static BooleanValue of(boolean value, boolean nullAllowed) {
            return new BooleanValue(value, nullAllowed);
        }

        @Override
        public boolean testBoolean(boolean value) {
            return this.value == value;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BooleanValue other = (BooleanValue)obj;
            return this.value == other.value && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{value='").append(this.value);
            sb.append(", nullAllowed=").append(this.nullAllowed);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class IsNotNull
    extends AbstractTupleDomainFilter {
        private IsNotNull() {
            super(true, false);
        }

        @Override
        public boolean testNonNull() {
            return true;
        }

        @Override
        public boolean testLong(long value) {
            return true;
        }

        @Override
        public boolean testDouble(double value) {
            return true;
        }

        @Override
        public boolean testFloat(float value) {
            return true;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            return true;
        }

        @Override
        public boolean testBoolean(boolean value) {
            return true;
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            return true;
        }

        @Override
        public boolean testLength(int length) {
            return true;
        }

        public String toString() {
            return String.format("%s{}", this.getClass().getName());
        }
    }

    public static class IsNull
    extends AbstractTupleDomainFilter {
        private IsNull() {
            super(true, true);
        }

        @Override
        public boolean testNonNull() {
            return false;
        }

        @Override
        public boolean testLong(long value) {
            return false;
        }

        @Override
        public boolean testDouble(double value) {
            return false;
        }

        @Override
        public boolean testFloat(float value) {
            return false;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            return false;
        }

        @Override
        public boolean testBoolean(boolean value) {
            return false;
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            return false;
        }

        @Override
        public boolean testLength(int length) {
            return false;
        }

        public String toString() {
            return String.format("%s{}", this.getClass().getName());
        }
    }

    public static class AlwaysFalse
    extends AbstractTupleDomainFilter {
        private AlwaysFalse() {
            super(true, false);
        }

        @Override
        public boolean testNonNull() {
            return false;
        }

        @Override
        public boolean testLong(long value) {
            return false;
        }

        @Override
        public boolean testDouble(double value) {
            return false;
        }

        @Override
        public boolean testFloat(float value) {
            return false;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            return false;
        }

        @Override
        public boolean testBoolean(boolean value) {
            return false;
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            return false;
        }

        @Override
        public boolean testLength(int length) {
            return false;
        }

        public String toString() {
            return String.format("%s{}", this.getClass().getName());
        }
    }

    public static abstract class AbstractTupleDomainFilter
    implements TupleDomainFilter {
        protected final boolean nullAllowed;
        private final boolean deterministic;

        protected AbstractTupleDomainFilter(boolean deterministic, boolean nullAllowed) {
            this.nullAllowed = nullAllowed;
            this.deterministic = deterministic;
        }

        @Override
        public boolean isDeterministic() {
            return this.deterministic;
        }

        @Override
        public boolean testNull() {
            return this.nullAllowed;
        }

        @Override
        public boolean testNonNull() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testFloat(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testDecimal(long low, long high) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testBoolean(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testLength(int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPrecedingPositionsToFail() {
            return 0;
        }

        @Override
        public int getSucceedingPositionsToFail() {
            return 0;
        }

        @Override
        public boolean isPositionalFilter() {
            return false;
        }
    }
}

