/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.AbstractLongType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeWithName;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static boolean isNumericType(Type type) {
        return TypeUtils.isNonDecimalNumericType(type) || type instanceof DecimalType;
    }

    public static boolean isNonDecimalNumericType(Type type) {
        return TypeUtils.isExactNumericType(type) || TypeUtils.isApproximateNumericType(type);
    }

    public static boolean isExactNumericType(Type type) {
        return type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT);
    }

    public static boolean isApproximateNumericType(Type type) {
        return type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL);
    }

    public static boolean isEnumType(Type type) {
        return type instanceof EnumType || type instanceof TypeWithName && ((TypeWithName)type).getType() instanceof EnumType;
    }

    public static boolean isDistinctType(Type type) {
        return type instanceof DistinctType;
    }

    public static boolean containsDistinctType(List<Type> types) {
        LinkedList<Type> allTypes = new LinkedList<Type>(types);
        while (!allTypes.isEmpty()) {
            Type type = allTypes.removeLast();
            if (TypeUtils.isDistinctType(type)) {
                return true;
            }
            allTypes.addAll(type.getTypeParameters());
        }
        return false;
    }

    public static Object readNativeValue(Type type, Block block, int position) {
        Class<?> javaType = type.getJavaType();
        if (block.isNull(position)) {
            return null;
        }
        if (javaType == Long.TYPE) {
            return type.getLong(block, position);
        }
        if (javaType == Double.TYPE) {
            return type.getDouble(block, position);
        }
        if (javaType == Boolean.TYPE) {
            return type.getBoolean(block, position);
        }
        if (javaType == Slice.class) {
            return type.getSlice(block, position);
        }
        return type.getObject(block, position);
    }

    public static void writeNativeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, (Boolean)value);
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (type.getJavaType() == Long.TYPE) {
            if (value instanceof BigDecimal) {
                type.writeLong(blockBuilder, ((BigDecimal)value).unscaledValue().longValue());
            } else {
                type.writeLong(blockBuilder, ((Number)value).longValue());
            }
        } else if (type.getJavaType() == Slice.class) {
            Slice slice = value instanceof byte[] ? Slices.wrappedBuffer((byte[])((byte[])value)) : (value instanceof String ? Slices.utf8Slice((String)((String)value)) : (value instanceof BigDecimal ? Decimals.encodeScaledValue((BigDecimal)value) : (Slice)value));
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
    }

    public static long hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        return type.hash(block, position);
    }

    public static boolean isFloatingPointNaN(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        if (type.equals(DoubleType.DOUBLE)) {
            return Double.isNaN((Double)value);
        }
        if (type.equals(RealType.REAL)) {
            return Float.isNaN(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        return false;
    }

    static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new NotSupportedException(errorMsg);
        }
    }

    static void validateEnumMap(Map<String, ?> enumMap) {
        if (enumMap.containsKey(null)) {
            throw new IllegalArgumentException("Enum cannot contain null key");
        }
        int nUniqueAndNotNullValues = enumMap.values().stream().filter(Objects::nonNull).collect(Collectors.toSet()).size();
        if (nUniqueAndNotNullValues != enumMap.size()) {
            throw new IllegalArgumentException("Enum cannot contain null or duplicate values");
        }
        int nCaseInsensitiveKeys = enumMap.keySet().stream().map(k -> k.toUpperCase(Locale.ENGLISH)).collect(Collectors.toSet()).size();
        if (nCaseInsensitiveKeys != enumMap.size()) {
            throw new IllegalArgumentException("Enum cannot contain case-insensitive duplicate keys");
        }
    }

    static <V> Map<String, V> normalizeEnumMap(Map<String, V> entries) {
        return entries.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(Locale.ENGLISH), Map.Entry::getValue));
    }

    public static boolean doubleEquals(double a, double b) {
        return a == b || Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    public static long doubleHashCode(double value) {
        value = value == 0.0 ? 0.0 : value;
        return AbstractLongType.hash(Double.doubleToLongBits(value));
    }

    public static int doubleCompare(double a, double b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        long aBits = Double.doubleToLongBits(a);
        long bBits = Double.doubleToLongBits(b);
        return Long.compare(aBits, bBits);
    }

    public static boolean realEquals(float a, float b) {
        return a == b || Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    public static long realHashCode(float value) {
        value = value == 0.0f ? 0.0f : value;
        return AbstractLongType.hash(Float.floatToIntBits(value));
    }

    public static int realCompare(float a, float b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        int aBits = Float.floatToIntBits(a);
        int bBits = Float.floatToIntBits(b);
        return Integer.compare(aBits, bBits);
    }
}

