/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.ErrorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@ThriftStruct
public final class ErrorCode {
    private final int code;
    private final String name;
    private final ErrorType type;
    private final boolean retriable;

    @JsonCreator
    @ThriftConstructor
    public ErrorCode(@JsonProperty(value="code") int code, @JsonProperty(value="name") String name, @JsonProperty(value="type") ErrorType type, @JsonProperty(value="retriable") boolean retriable) {
        if (code < 0) {
            throw new IllegalArgumentException("code is negative");
        }
        this.code = code;
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.retriable = retriable;
    }

    public ErrorCode(int code, String name, ErrorType type) {
        this(code, name, type, false);
    }

    @JsonProperty
    @ThriftField(value=1)
    public int getCode() {
        return this.code;
    }

    @JsonProperty
    @ThriftField(value=2)
    public String getName() {
        return this.name;
    }

    @JsonProperty
    @ThriftField(value=3)
    public ErrorType getType() {
        return this.type;
    }

    @JsonProperty
    @ThriftField(value=4)
    public boolean isRetriable() {
        return this.retriable;
    }

    public String toString() {
        return this.name + ":" + this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorCode that = (ErrorCode)obj;
        return Objects.equals(this.code, that.code);
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }
}

