/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.UncheckedBlock;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FunctionType
implements Type {
    public static final String NAME = "function";
    private final TypeSignature signature;
    private final Type returnType;
    private final List<Type> argumentTypes;

    public FunctionType(List<Type> argumentTypes, Type returnType) {
        this.signature = new TypeSignature(NAME, FunctionType.typeParameters(argumentTypes, returnType));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(argumentTypes, "argumentTypes is null")));
    }

    private static List<TypeSignatureParameter> typeParameters(List<Type> argumentTypes, Type returnType) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        ArrayList<TypeSignatureParameter> parameters = new ArrayList<TypeSignatureParameter>(argumentTypes.size() + 1);
        argumentTypes.stream().map(Type::getTypeSignature).map(TypeSignatureParameter::of).forEach(parameters::add);
        parameters.add(TypeSignatureParameter.of(returnType.getTypeSignature()));
        return Collections.unmodifiableList(parameters);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    public List<Type> getTypeParameters() {
        ArrayList<Type> parameters = new ArrayList<Type>(this.argumentTypes.size() + 1);
        parameters.addAll(this.argumentTypes);
        parameters.add(this.returnType);
        return Collections.unmodifiableList(parameters);
    }

    @Override
    public final TypeSignature getTypeSignature() {
        return this.signature;
    }

    @Override
    public String getDisplayName() {
        List names = this.getTypeParameters().stream().map(Type::getDisplayName).collect(Collectors.toList());
        return "function<" + String.join((CharSequence)",", names) + ">";
    }

    @Override
    public final Class<?> getJavaType() {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type does not have Java type");
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isOrderable() {
        return false;
    }

    @Override
    public long hash(Block block, int position) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not orderable");
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean getBooleanUnchecked(UncheckedBlock block, int internalPosition) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public long getLong(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public long getLongUnchecked(UncheckedBlock block, int internalPosition) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public double getDouble(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public double getDoubleUnchecked(UncheckedBlock block, int internalPosition) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Slice getSlice(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Slice getSliceUnchecked(Block block, int internalPosition) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object getObject(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Block getBlockUnchecked(Block block, int internalPosition) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        throw new UnsupportedOperationException();
    }
}

