/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.util.UUID;
import java.util.stream.LongStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPage {
    @Test
    public void testGetRegion() {
        Page page = new Page(10);
        Page region = page.getRegion(0, 10);
        Assert.assertEquals((int)page.getRegion(5, 5).getPositionCount(), (int)5);
        Assert.assertEquals((int)region.getPositionCount(), (int)10);
        Assert.assertSame((Object)page, (Object)region);
    }

    @Test
    public void testGetEmptyRegion() {
        Page page = new Page(10);
        Assert.assertEquals((int)new Page(0).getRegion(0, 0).getPositionCount(), (int)0);
        Assert.assertEquals((int)page.getRegion(5, 0).getPositionCount(), (int)0);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class}, expectedExceptionsMessageRegExp="Invalid position 1 and length 1 in page with 0 positions")
    public void testGetRegionExceptions() {
        new Page(0).getRegion(1, 1);
    }

    @Test
    public void testGetRegionFromNoColumnPage() {
        Assert.assertEquals((int)new Page(100).getRegion(0, 10).getPositionCount(), (int)10);
    }

    @Test
    public void testSizesForNoColumnPage() {
        Page page = new Page(100);
        Assert.assertEquals((long)page.getSizeInBytes(), (long)0L);
        Assert.assertEquals((long)page.getLogicalSizeInBytes(), (long)0L);
        Assert.assertEquals((long)page.getRetainedSizeInBytes(), (long)Page.INSTANCE_SIZE);
    }

    @Test
    public void testCompactDictionaryBlocks() {
        int positionCount = 100;
        DictionaryId commonSourceId = DictionaryId.randomDictionaryId();
        int commonDictionaryUsedPositions = 20;
        int[] commonDictionaryIds = TestPage.getDictionaryIds(positionCount, commonDictionaryUsedPositions);
        Slice[] dictionaryValues1 = TestPage.createExpectedValues(50);
        Block dictionary1 = TestPage.createSlicesBlock(dictionaryValues1);
        DictionaryBlock commonSourceIdBlock1 = new DictionaryBlock(positionCount, dictionary1, commonDictionaryIds, commonSourceId);
        BlockBuilder dictionary2 = BigintType.BIGINT.createBlockBuilder(null, dictionary1.getPositionCount());
        for (Slice expectedValue : dictionaryValues1) {
            BigintType.BIGINT.writeLong(dictionary2, (long)expectedValue.length());
        }
        DictionaryBlock commonSourceIdBlock2 = new DictionaryBlock(positionCount, dictionary2.build(), commonDictionaryIds, commonSourceId);
        int otherDictionaryUsedPositions = 30;
        int[] otherDictionaryIds = TestPage.getDictionaryIds(positionCount, otherDictionaryUsedPositions);
        Block dictionary3 = TestPage.createSlicesBlock(TestPage.createExpectedValues(70));
        DictionaryBlock randomSourceIdBlock = new DictionaryBlock(dictionary3, otherDictionaryIds);
        Page page = new Page(new Block[]{commonSourceIdBlock1, randomSourceIdBlock, commonSourceIdBlock2});
        page.compact();
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(0)).isCompact());
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(1)).isCompact());
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(2)).isCompact());
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(0)).getDictionary().getPositionCount(), (int)commonDictionaryUsedPositions);
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(1)).getDictionary().getPositionCount(), (int)otherDictionaryUsedPositions);
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(2)).getDictionary().getPositionCount(), (int)commonDictionaryUsedPositions);
        Assert.assertNotEquals((Object)((DictionaryBlock)page.getBlock(0)).getDictionarySourceId(), (Object)((DictionaryBlock)page.getBlock(1)).getDictionarySourceId());
        Assert.assertEquals((Object)((DictionaryBlock)page.getBlock(0)).getDictionarySourceId(), (Object)((DictionaryBlock)page.getBlock(2)).getDictionarySourceId());
    }

    @Test
    public void testGetPositions() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block}).getPositions(new int[]{0, 1, 1, 1, 2, 5, 5}, 1, 5);
        Assert.assertEquals((int)page.getPositionCount(), (int)5);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)page.getBlock(i).getLong(0), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(1), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(2), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(3), (long)2L);
            Assert.assertEquals((long)page.getBlock(i).getLong(4), (long)5L);
        }
    }

    @Test
    public void testDropColumn() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block});
        Assert.assertEquals((int)page.getChannelCount(), (int)3);
        Page newPage = page.dropColumn(1);
        Assert.assertEquals((int)page.getChannelCount(), (int)3, (String)"Page was modified");
        Assert.assertEquals((int)newPage.getChannelCount(), (int)2);
        Assert.assertEquals((long)newPage.getBlock(0).getLong(0), (long)0L);
        Assert.assertEquals((long)newPage.getBlock(1).getLong(1), (long)1L);
    }

    @Test
    public void testReplaceColumn() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block});
        Assert.assertEquals((long)page.getBlock(1).getLong(0), (long)0L);
        BlockBuilder newBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(newBlockBuilder, (long)(-i));
        }
        Block newBlock = newBlockBuilder.build();
        Page newPage = page.replaceColumn(1, newBlock);
        Assert.assertEquals((int)newPage.getChannelCount(), (int)3);
        Assert.assertEquals((long)newPage.getBlock(1).getLong(0), (long)0L);
        Assert.assertEquals((long)newPage.getBlock(1).getLong(1), (long)-1L);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReplaceColumn_channelTooLow() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block});
        Assert.assertEquals((long)page.getBlock(1).getLong(0), (long)0L);
        BlockBuilder newBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(newBlockBuilder, (long)(-i));
        }
        Block newBlock = newBlockBuilder.build();
        page.replaceColumn(-1, newBlock);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReplaceColumn_channelTooHigh() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block});
        Assert.assertEquals((long)page.getBlock(1).getLong(0), (long)0L);
        BlockBuilder newBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(newBlockBuilder, (long)(-i));
        }
        Block newBlock = newBlockBuilder.build();
        page.replaceColumn(page.getChannelCount(), newBlock);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testReplaceColumn_WrongNumberOfRows() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block});
        Assert.assertEquals((long)page.getBlock(1).getLong(0), (long)0L);
        BlockBuilder newBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries - 5; ++i) {
            BigintType.BIGINT.writeLong(newBlockBuilder, (long)(-i));
        }
        Block newBlock = newBlockBuilder.build();
        page.replaceColumn(1, newBlock);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testPrependColumnWrongNumberOfRows() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block});
        BlockBuilder newBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries - 5);
        for (int i = 0; i < entries - 5; ++i) {
            BigintType.BIGINT.writeLong(newBlockBuilder, (long)(-i));
        }
        Block newBlock = newBlockBuilder.build();
        page.prependColumn(newBlock);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAppendColumnsWrongNumberOfRows() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block});
        BlockBuilder newBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries - 5);
        for (int i = 0; i < entries - 5; ++i) {
            BigintType.BIGINT.writeLong(newBlockBuilder, (long)(-i));
        }
        Block newBlock = newBlockBuilder.build();
        page.appendColumn(newBlock);
    }

    @Test
    public void testRetainedSizeIsCorrect() {
        BlockBuilder variableWidthBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 256);
        LongStream.range(0L, 100L).forEach(value -> VarcharType.VARCHAR.writeString(variableWidthBlockBuilder, UUID.randomUUID().toString()));
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)variableWidthBlockBuilder.build();
        Page page = new Page(new Block[]{variableWidthBlock, variableWidthBlock, variableWidthBlock.getRegion(0, 50), variableWidthBlockBuilder.getRegion(51, 25)});
        double expectedMaximumSizeOfPage = (double)variableWidthBlock.getRawSlice(0).getRetainedSize() * 1.2;
        Assert.assertTrue(((double)page.getRetainedSizeInBytes() < expectedMaximumSizeOfPage ? 1 : 0) != 0, (String)"Expected slice & underlying object to be counted once");
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestPage.createExpectedValue(position);
        }
        return expectedValues;
    }

    private static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }

    private static int[] getDictionaryIds(int positionCount, int dictionarySize) {
        Preconditions.checkArgument((positionCount > dictionarySize ? 1 : 0) != 0);
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return ids;
    }

    private static Block createSlicesBlock(Slice[] values) {
        BlockBuilder builder = VarbinaryType.VARBINARY.createBlockBuilder(null, 100);
        for (Slice value : values) {
            Verify.verify((value != null ? 1 : 0) != 0);
            VarbinaryType.VARBINARY.writeSlice(builder, value);
        }
        return builder.build();
    }
}

