/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRuntimeStats {
    private static final String TEST_METRIC_NAME_1 = "test1";
    private static final String TEST_METRIC_NAME_2 = "test2";
    private static final String TEST_METRIC_NAME_3 = "test3";
    private static final String TEST_METRIC_NAME_NANO_1 = "test_nano_1";
    private static final String TEST_METRIC_NAME_NANO_2 = "test_nano_2";
    private static final String TEST_METRIC_NAME_NANO_3 = "test_nano_3";
    private static final String TEST_METRIC_NAME_BYTE = "test_byte";
    private static final long ONE_SECOND_IN_NANOS = 1000000000L;

    private void assertRuntimeMetricEquals(RuntimeMetric m1, RuntimeMetric m2) {
        Assert.assertEquals((String)m1.getName(), (String)m2.getName());
        Assert.assertEquals((Object)m1.getUnit(), (Object)m2.getUnit());
        Assert.assertEquals((long)m1.getSum(), (long)m2.getSum());
        Assert.assertEquals((long)m1.getCount(), (long)m2.getCount());
        Assert.assertEquals((long)m1.getMax(), (long)m2.getMax());
        Assert.assertEquals((long)m1.getMin(), (long)m2.getMin());
    }

    @Test
    public void testAddMetricValue() {
        RuntimeStats stats = new RuntimeStats();
        stats.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L);
        stats.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 3L);
        stats.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 5L);
        stats.addMetricValue(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 7L);
        this.assertRuntimeMetricEquals(stats.getMetric(TEST_METRIC_NAME_1), new RuntimeMetric(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 10L, 3L, 5L, 2L));
        this.assertRuntimeMetricEquals(stats.getMetric(TEST_METRIC_NAME_NANO_1), new RuntimeMetric(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 7L, 1L, 7L, 7L));
        stats.reset();
        Assert.assertEquals((int)stats.getMetrics().size(), (int)0);
    }

    @Test
    public void testMergeMetric() {
        RuntimeStats stats1 = new RuntimeStats();
        stats1.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L);
        stats1.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 3L);
        stats1.addMetricValue(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 3L);
        RuntimeStats stats2 = new RuntimeStats();
        stats2.addMetricValue(TEST_METRIC_NAME_NANO_2, RuntimeUnit.NANO, 5L);
        stats2.mergeMetric(TEST_METRIC_NAME_2, stats1.getMetric(TEST_METRIC_NAME_1));
        stats2.mergeMetric(TEST_METRIC_NAME_NANO_2, stats1.getMetric(TEST_METRIC_NAME_NANO_1));
        Assert.assertEquals((int)stats2.getMetrics().size(), (int)2);
        this.assertRuntimeMetricEquals(stats2.getMetric(TEST_METRIC_NAME_2), new RuntimeMetric(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 5L, 2L, 3L, 2L));
        this.assertRuntimeMetricEquals(stats2.getMetric(TEST_METRIC_NAME_NANO_2), new RuntimeMetric(TEST_METRIC_NAME_NANO_2, RuntimeUnit.NANO, 8L, 2L, 5L, 3L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMergeMetricWithConflictUnits() {
        RuntimeStats stats1 = new RuntimeStats();
        stats1.addMetricValue(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 3L);
        RuntimeStats stats2 = new RuntimeStats();
        stats2.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.BYTE, 3L);
        stats2.mergeMetric(TEST_METRIC_NAME_BYTE, stats1.getMetric(TEST_METRIC_NAME_NANO_1));
    }

    @Test
    public void testMerge() {
        RuntimeStats stats1 = new RuntimeStats();
        stats1.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L);
        stats1.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 3L);
        stats1.addMetricValue(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 1L);
        stats1.addMetricValue(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 2L);
        stats1.addMetricValue(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 2L);
        stats1.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.BYTE, 1L);
        RuntimeStats stats2 = new RuntimeStats();
        stats2.addMetricValue(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 0L);
        stats2.addMetricValue(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 3L);
        stats2.addMetricValue(TEST_METRIC_NAME_3, RuntimeUnit.NONE, 8L);
        stats2.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.BYTE, 3L);
        RuntimeStats mergedStats = RuntimeStats.merge((RuntimeStats)stats1, (RuntimeStats)stats2);
        this.assertRuntimeMetricEquals(mergedStats.getMetric(TEST_METRIC_NAME_1), new RuntimeMetric(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 5L, 2L, 3L, 2L));
        this.assertRuntimeMetricEquals(mergedStats.getMetric(TEST_METRIC_NAME_2), new RuntimeMetric(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 6L, 4L, 3L, 0L));
        this.assertRuntimeMetricEquals(mergedStats.getMetric(TEST_METRIC_NAME_3), new RuntimeMetric(TEST_METRIC_NAME_3, RuntimeUnit.NONE, 8L, 1L, 8L, 8L));
        this.assertRuntimeMetricEquals(mergedStats.getMetric(TEST_METRIC_NAME_NANO_1), new RuntimeMetric(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 2L, 1L, 2L, 2L));
        this.assertRuntimeMetricEquals(mergedStats.getMetric(TEST_METRIC_NAME_BYTE), new RuntimeMetric(TEST_METRIC_NAME_BYTE, RuntimeUnit.BYTE, 4L, 2L, 3L, 1L));
        stats1.mergeWith(stats2);
        mergedStats.getMetrics().values().forEach(metric -> this.assertRuntimeMetricEquals((RuntimeMetric)metric, stats1.getMetric(metric.getName())));
        Assert.assertEquals((int)mergedStats.getMetrics().size(), (int)stats1.getMetrics().size());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMergeWithConflictUnits() {
        RuntimeStats stats1 = new RuntimeStats();
        stats1.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.NANO, 1L);
        RuntimeStats stats2 = new RuntimeStats();
        stats2.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.BYTE, 3L);
        RuntimeStats.merge((RuntimeStats)stats1, (RuntimeStats)stats2);
    }

    @Test
    public void testMergeWithNull() {
        RuntimeStats stats = new RuntimeStats();
        stats.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L);
        stats.mergeWith(null);
        this.assertRuntimeMetricEquals(stats.getMetric(TEST_METRIC_NAME_1), new RuntimeMetric(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L, 1L, 2L, 2L));
    }

    @Test
    public void testUpdate() {
        RuntimeStats stats1 = new RuntimeStats();
        stats1.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L);
        stats1.update(null);
        this.assertRuntimeMetricEquals(stats1.getMetric(TEST_METRIC_NAME_1), new RuntimeMetric(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L, 1L, 2L, 2L));
        RuntimeStats stats2 = new RuntimeStats();
        stats2.addMetricValue(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 2L);
        stats1.update(stats2);
        this.assertRuntimeMetricEquals(stats1.getMetric(TEST_METRIC_NAME_1), new RuntimeMetric(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L, 1L, 2L, 2L));
        this.assertRuntimeMetricEquals(stats1.getMetric(TEST_METRIC_NAME_2), stats1.getMetric(TEST_METRIC_NAME_2));
        stats2.addMetricValue(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 4L);
        stats1.update(stats2);
        this.assertRuntimeMetricEquals(stats1.getMetric(TEST_METRIC_NAME_2), stats1.getMetric(TEST_METRIC_NAME_2));
        stats2.addMetricValue(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 4L);
        stats1.update(stats2);
        this.assertRuntimeMetricEquals(stats1.getMetric(TEST_METRIC_NAME_NANO_1), stats1.getMetric(TEST_METRIC_NAME_NANO_1));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testUpdateWithConflictUnits() {
        RuntimeStats stats1 = new RuntimeStats();
        stats1.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.BYTE, 4L);
        RuntimeStats stats2 = new RuntimeStats();
        stats2.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.NANO, 4L);
        stats1.update(stats2);
    }

    @Test
    public void testJson() {
        RuntimeStats stats = new RuntimeStats();
        stats.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 2L);
        stats.addMetricValue(TEST_METRIC_NAME_1, RuntimeUnit.NONE, 3L);
        stats.addMetricValue(TEST_METRIC_NAME_2, RuntimeUnit.NONE, 8L);
        stats.addMetricValue(TEST_METRIC_NAME_3, RuntimeUnit.NONE, 8L);
        stats.addMetricValue(TEST_METRIC_NAME_NANO_1, RuntimeUnit.NANO, 8L);
        stats.addMetricValue(TEST_METRIC_NAME_BYTE, RuntimeUnit.BYTE, 8L);
        JsonCodec codec = JsonCodec.jsonCodec(RuntimeStats.class);
        String json = codec.toJson((Object)stats);
        RuntimeStats actual = (RuntimeStats)codec.fromJson(json);
        actual.getMetrics().forEach((name, metric) -> this.assertRuntimeMetricEquals((RuntimeMetric)metric, stats.getMetric(name)));
    }

    @Test
    public void testNullJson() {
        JsonCodec codec = JsonCodec.jsonCodec(RuntimeStats.class);
        String nullJson = codec.toJson(null);
        RuntimeStats actual = (RuntimeStats)codec.fromJson(nullJson);
        Assert.assertNull((Object)actual);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testReturnUnmodifiedMetrics() {
        RuntimeStats stats = new RuntimeStats();
        stats.getMetrics().put(TEST_METRIC_NAME_1, new RuntimeMetric(TEST_METRIC_NAME_1, RuntimeUnit.NONE));
    }

    @Test
    public void testRecordWallTime() {
        RuntimeStats stats = new RuntimeStats();
        Assert.assertEquals((Integer)((Integer)stats.recordWallTime(TEST_METRIC_NAME_NANO_3, () -> 1)), (int)1);
        Assertions.assertThat((long)stats.getMetric(TEST_METRIC_NAME_NANO_3).getSum()).isLessThan(1000000000L);
        stats.recordWallTime(TEST_METRIC_NAME_NANO_2, () -> {});
        Assertions.assertThat((long)stats.getMetric(TEST_METRIC_NAME_NANO_2).getSum()).isLessThan(1000000000L);
    }

    @Test
    public void testRecordWallAndCpuTime() {
        RuntimeStats stats = new RuntimeStats();
        Assert.assertEquals((Integer)((Integer)stats.recordWallAndCpuTime(TEST_METRIC_NAME_NANO_1, () -> {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            return 1;
        })), (int)1);
        Assertions.assertThat((long)stats.getMetric(TEST_METRIC_NAME_NANO_1).getSum()).isGreaterThanOrEqualTo(TimeUnit.MILLISECONDS.toNanos(100L));
        Assertions.assertThat((long)stats.getMetric("test_nano_1OnCpu").getSum()).isLessThan(TimeUnit.MILLISECONDS.toNanos(100L));
        stats.recordWallAndCpuTime(TEST_METRIC_NAME_NANO_2, () -> Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertThat((long)stats.getMetric(TEST_METRIC_NAME_NANO_2).getSum()).isGreaterThanOrEqualTo(TimeUnit.MILLISECONDS.toNanos(100L));
        Assertions.assertThat((long)stats.getMetric("test_nano_2OnCpu").getSum()).isLessThan(TimeUnit.MILLISECONDS.toNanos(100L));
    }
}

