/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.presto.common.InvalidFunctionArgumentException;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.SubfieldTokenizer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSubfieldTokenizer {
    @Test
    public void test() {
        ImmutableList elements = ImmutableList.of((Object)new Subfield.NestedField("b"), (Object)new Subfield.LongSubscript(2L), (Object)new Subfield.LongSubscript(-1L), (Object)new Subfield.StringSubscript("z"), (Object)Subfield.allSubscripts(), (Object)new Subfield.StringSubscript("34"), (Object)new Subfield.StringSubscript("b \"test\""), (Object)new Subfield.StringSubscript("\"abc"), (Object)new Subfield.StringSubscript("abc\""), (Object)new Subfield.StringSubscript("ab\"cde"), (Object)new Subfield.StringSubscript("a.b[\"hello\udbff\"]"));
        for (Subfield.PathElement element : elements) {
            TestSubfieldTokenizer.assertPath(new Subfield("a", (List)ImmutableList.of((Object)element)));
        }
        for (Subfield.PathElement element : elements) {
            for (Subfield.PathElement secondElement : elements) {
                TestSubfieldTokenizer.assertPath(new Subfield("a", (List)ImmutableList.of((Object)element, (Object)secondElement)));
            }
        }
        for (Subfield.PathElement element : elements) {
            for (Subfield.PathElement secondElement : elements) {
                for (Subfield.PathElement thirdElement : elements) {
                    TestSubfieldTokenizer.assertPath(new Subfield("a", (List)ImmutableList.of((Object)element, (Object)secondElement, (Object)thirdElement)));
                }
            }
        }
    }

    private static void assertPath(Subfield path) {
        SubfieldTokenizer tokenizer = new SubfieldTokenizer(path.serialize());
        Assert.assertTrue((boolean)tokenizer.hasNext());
        Assert.assertEquals((Object)new Subfield(((Subfield.NestedField)tokenizer.next()).getName(), (List)Streams.stream((Iterator)tokenizer).collect(ImmutableList.toImmutableList())), (Object)path);
    }

    @Test
    public void testColumnNames() {
        TestSubfieldTokenizer.assertPath(new Subfield("#bucket", (List)ImmutableList.of()));
        TestSubfieldTokenizer.assertPath(new Subfield("$bucket", (List)ImmutableList.of()));
        TestSubfieldTokenizer.assertPath(new Subfield("apollo-11", (List)ImmutableList.of()));
        TestSubfieldTokenizer.assertPath(new Subfield("a/b/c:12", (List)ImmutableList.of()));
        TestSubfieldTokenizer.assertPath(new Subfield("@basis", (List)ImmutableList.of()));
        TestSubfieldTokenizer.assertPath(new Subfield("@basis|city_id", (List)ImmutableList.of()));
        TestSubfieldTokenizer.assertPath(new Subfield("a and b", (List)ImmutableList.of()));
    }

    @Test
    public void testInvalidPaths() {
        this.assertInvalidPath("a[b]");
        this.assertInvalidPath("a[2");
        this.assertInvalidPath("a.*");
        this.assertInvalidPath("a[2].[3].");
    }

    private void assertInvalidPath(String path) {
        SubfieldTokenizer tokenizer = new SubfieldTokenizer(path);
        try {
            Streams.stream((Iterator)tokenizer).collect(ImmutableList.toImmutableList());
            Assert.fail((String)"Expected failure");
        }
        catch (InvalidFunctionArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid subfield path: "));
        }
    }
}

