/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.presto.common.Utils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUtils {
    @Test
    public void testCheckArgumentFailWithMessage() {
        try {
            Utils.checkArgument((boolean)false, (String)"test %s", (Object[])new Object[]{"test"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test test");
        }
    }

    @Test
    public void testCheckArgumentPassWithMessage() {
        try {
            Utils.checkArgument((boolean)true, (String)"test %s", (Object[])new Object[]{"test"});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @Test
    public void testMemoizedSupplierThreadSafe() throws Throwable {
        Function<Supplier<Boolean>, Supplier<Boolean>> memoizer = supplier -> Utils.memoizedSupplier((Supplier)supplier);
        this.testSupplierThreadSafe(memoizer);
    }

    private void testSupplierThreadSafe(Function<Supplier<Boolean>, Supplier<Boolean>> memoizer) throws Throwable {
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicReference<Object> thrown = new AtomicReference<Object>(null);
        int numThreads = 3;
        final Thread[] threads = new Thread[3];
        final long timeout = TimeUnit.SECONDS.toNanos(60L);
        Supplier<Boolean> supplier = new Supplier<Boolean>(){

            boolean isWaiting(Thread thread) {
                switch (thread.getState()) {
                    case BLOCKED: 
                    case WAITING: 
                    case TIMED_WAITING: {
                        return true;
                    }
                }
                return false;
            }

            int waitingThreads() {
                int waitingThreads = 0;
                for (Thread thread : threads) {
                    if (!this.isWaiting(thread)) continue;
                    ++waitingThreads;
                }
                return waitingThreads;
            }

            @Override
            public Boolean get() {
                long t0 = System.nanoTime();
                while (this.waitingThreads() != 2) {
                    if (System.nanoTime() - t0 > timeout) {
                        thrown.set(new TimeoutException("timed out waiting for other threads to block synchronizing on supplier"));
                        break;
                    }
                    Thread.yield();
                }
                count.getAndIncrement();
                return Boolean.TRUE;
            }
        };
        final Supplier<Boolean> memoizedSupplier = memoizer.apply(supplier);
        for (int i = 0; i < 3; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    Assert.assertSame((Object)Boolean.TRUE, memoizedSupplier.get());
                }
            };
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        if (thrown.get() != null) {
            throw (Throwable)thrown.get();
        }
        Assert.assertEquals((int)1, (int)count.get());
    }
}

