/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.ArrayBlockBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderUtils;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleArrayBlockWriter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockBuilderUtils {
    private static final MapType TEST_MAP_TYPE = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestBlockBuilderUtils.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestBlockBuilderUtils.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
    private static final Map<Long, String> TEST_MAP_VALUES = TestBlockBuilderUtils.createTestMap();

    private static Map<Long, String> createTestMap() {
        HashMap<Long, String> testMap = new HashMap<Long, String>();
        testMap.put(1L, "ONE");
        testMap.put(2L, "TWO");
        testMap.put(null, "NULL");
        testMap.put(4L, null);
        return testMap;
    }

    @Test
    public void testArrayBlockBuilder() {
        long[] values = new long[]{1L, 2L, 3L, 4L, 5L};
        ArrayBlockBuilder blockBuilder1 = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 1);
        SingleArrayBlockWriter elementBuilder = blockBuilder1.beginBlockEntry();
        for (long value : values) {
            BigintType.BIGINT.writeLong((BlockBuilder)elementBuilder, value);
        }
        Block expectedBlock = blockBuilder1.closeEntry().build();
        ArrayBlockBuilder blockBuilder2 = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 1);
        BlockBuilderUtils.writePositionToBlockBuilder((Block)expectedBlock, (int)0, (BlockBuilder)blockBuilder2);
        Block newBlock = blockBuilder2.build();
        Assert.assertEquals((Object)newBlock, (Object)expectedBlock);
    }

    @Test
    public void testMapBlockBuilder() {
        BlockBuilder blockBuilder1 = TEST_MAP_TYPE.createBlockBuilder(null, 1);
        BlockBuilder mapBlockBuilder = blockBuilder1.beginBlockEntry();
        TestBlockBuilderUtils.writeValuesToMapBuilder(mapBlockBuilder);
        Block expectedBlock = blockBuilder1.closeEntry().build();
        BlockBuilder blockBuilder2 = TEST_MAP_TYPE.createBlockBuilder(null, 1);
        BlockBuilderUtils.writePositionToBlockBuilder((Block)expectedBlock, (int)0, (BlockBuilder)blockBuilder2);
        Block newBlock = blockBuilder2.build();
        Assert.assertEquals((Object)newBlock, (Object)expectedBlock);
    }

    @Test
    public void testRowBlockBuilder() {
        RowType rowType = TestBlockBuilderUtils.rowType(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, TEST_MAP_TYPE});
        BlockBuilder blockBuilder = rowType.createBlockBuilder(null, 1);
        BlockBuilder rowBlockBuilder = blockBuilder.beginBlockEntry();
        VarcharType.VARCHAR.writeString(rowBlockBuilder, "TEST_ROW");
        BigintType.BIGINT.writeLong(rowBlockBuilder, 10L);
        BlockBuilder mapBlockBuilder = rowBlockBuilder.beginBlockEntry();
        TestBlockBuilderUtils.writeValuesToMapBuilder(mapBlockBuilder);
        rowBlockBuilder.closeEntry();
        Block expectedBlock = blockBuilder.closeEntry().build();
        BlockBuilder blockBuilder2 = rowType.createBlockBuilder(null, 1);
        BlockBuilderUtils.writePositionToBlockBuilder((Block)expectedBlock, (int)0, (BlockBuilder)blockBuilder2);
        Block newBlock = blockBuilder2.build();
        Assert.assertEquals((Object)newBlock, (Object)expectedBlock);
    }

    private static void writeValuesToMapBuilder(BlockBuilder mapBlockBuilder) {
        for (Map.Entry<Long, String> entry : TEST_MAP_VALUES.entrySet()) {
            Long key = entry.getKey();
            if (key == null) {
                mapBlockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(mapBlockBuilder, entry.getKey().longValue());
            }
            String value = entry.getValue();
            if (value == null) {
                mapBlockBuilder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeString(mapBlockBuilder, entry.getValue());
        }
    }

    public static RowType rowType(Type ... fieldTypes) {
        ArrayList<RowType.Field> fields = new ArrayList<RowType.Field>();
        for (int i = 0; i < fieldTypes.length; ++i) {
            Type fieldType = fieldTypes[i];
            String fieldName = "field_" + i;
            fields.add(new RowType.Field(Optional.of(fieldName), fieldType));
        }
        return RowType.from(fields);
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }
}

