/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockFlattener;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.CountingArrayAllocator;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.ShortArrayBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestBlockFlattener {
    private ArrayAllocator allocator;
    private BlockFlattener flattener;

    @BeforeClass
    public void setup() {
        this.allocator = new CountingArrayAllocator();
        this.flattener = new BlockFlattener(this.allocator);
    }

    @Test
    public void testLongArrayIdentityDecode() {
        Block block = TestBlockFlattener.createLongArrayBlock(1L, 2L, 3L, 4L);
        try (BlockLease blockLease = this.flattener.flatten(block);){
            Block flattenedBlock = (Block)blockLease.get();
            Assert.assertSame((Object)flattenedBlock, (Object)block);
        }
    }

    @Test
    public void testNestedDictionaryRLELongArray() {
        DictionaryBlock block = TestBlockFlattener.createTestDictionaryBlock((Block)TestBlockFlattener.createTestRleBlock(TestBlockFlattener.createLongArrayBlock(4L), 3));
        this.assertFlattenNumericTypeBlock((Type)BigintType.BIGINT, (Block)block, 1, LongArrayBlock.class);
    }

    @Test
    public void testNestedDictionaryDictionaryLongArray() {
        DictionaryBlock block = TestBlockFlattener.createTestDictionaryBlock((Block)TestBlockFlattener.createTestDictionaryBlock(TestBlockFlattener.createLongArrayBlock(1L, 2L, 3L, 4L, 5L)));
        this.assertFlattenNumericTypeBlock((Type)BigintType.BIGINT, (Block)block, 5, LongArrayBlock.class);
    }

    @Test
    public void testNestedDictionaryRleDictionaryLongArray() {
        DictionaryBlock block = TestBlockFlattener.createTestDictionaryBlock((Block)TestBlockFlattener.createTestRleBlock((Block)TestBlockFlattener.createTestDictionaryBlock(TestBlockFlattener.createLongArrayBlock(1L)), 5));
        this.assertFlattenNumericTypeBlock((Type)BigintType.BIGINT, (Block)block, 1, LongArrayBlock.class);
    }

    @Test
    public void testIntArrayIdentityDecode() {
        Block block = TestBlockFlattener.createIntArrayBlock(1, 2, 3, 4);
        try (BlockLease blockLease = this.flattener.flatten(block);){
            Block flattenedBlock = (Block)blockLease.get();
            Assert.assertSame((Object)flattenedBlock, (Object)block);
        }
    }

    @Test
    public void testNestedDictionaryRLEIntArray() {
        DictionaryBlock block = TestBlockFlattener.createTestDictionaryBlock((Block)TestBlockFlattener.createTestRleBlock(TestBlockFlattener.createIntArrayBlock(4), 3));
        this.assertFlattenNumericTypeBlock((Type)IntegerType.INTEGER, (Block)block, 1, IntArrayBlock.class);
    }

    @Test
    public void testShortArrayIdentityDecode() {
        Block block = TestBlockFlattener.createShortArrayBlock(1, 2, 3, 4);
        try (BlockLease blockLease = this.flattener.flatten(block);){
            Block flattenedBlock = (Block)blockLease.get();
            Assert.assertSame((Object)flattenedBlock, (Object)block);
        }
    }

    @Test
    public void testNestedDictionaryRLEShortArray() {
        DictionaryBlock block = TestBlockFlattener.createTestDictionaryBlock((Block)TestBlockFlattener.createTestRleBlock(TestBlockFlattener.createShortArrayBlock(4), 3));
        this.assertFlattenNumericTypeBlock((Type)SmallintType.SMALLINT, (Block)block, 1, ShortArrayBlock.class);
    }

    @Test
    public void testByteArrayIdentityDecode() {
        Block block = TestBlockFlattener.createByteArrayBlock(1, 2, 3, 4);
        try (BlockLease blockLease = this.flattener.flatten(block);){
            Block flattenedBlock = (Block)blockLease.get();
            Assert.assertSame((Object)flattenedBlock, (Object)block);
        }
    }

    @Test
    public void testNestedDictionaryRLEByteArray() {
        DictionaryBlock block = TestBlockFlattener.createTestDictionaryBlock((Block)TestBlockFlattener.createTestRleBlock(TestBlockFlattener.createByteArrayBlock(4), 3));
        this.assertFlattenNumericTypeBlock((Type)TinyintType.TINYINT, (Block)block, 1, ByteArrayBlock.class);
    }

    @Test
    public void testNestedRLEs() {
        RunLengthEncodedBlock block = TestBlockFlattener.createTestRleBlock((Block)TestBlockFlattener.createTestRleBlock((Block)TestBlockFlattener.createTestRleBlock(TestBlockFlattener.createLongArrayBlock(5L), 1), 1), 4);
        Assert.assertEquals((int)block.getPositionCount(), (int)4);
        try (BlockLease blockLease = this.flattener.flatten((Block)block);){
            Block flattenedBlock = (Block)blockLease.get();
            Assert.assertEquals(flattenedBlock.getClass(), RunLengthEncodedBlock.class);
            Assert.assertEquals((int)flattenedBlock.getPositionCount(), (int)block.getPositionCount());
            Assert.assertEquals(flattenedBlock.getClass(), RunLengthEncodedBlock.class);
            Assert.assertEquals(((RunLengthEncodedBlock)flattenedBlock).getValue().getClass(), LongArrayBlock.class);
            Block innerBlock = ((RunLengthEncodedBlock)flattenedBlock).getValue();
            Assert.assertEquals((int)innerBlock.getPositionCount(), (int)1);
        }
    }

    @Test
    public void testCardinalityIncreasingNestedDictionaryBlock() {
        DictionaryBlock block = new DictionaryBlock((Block)new DictionaryBlock((Block)new DictionaryBlock(TestBlockFlattener.createLongArrayBlock(5L, 6L), new int[]{0, 1}), new int[]{0, 1, 0, 0, 1}), new int[]{0, 1, 0, 0, 1, 1, 0});
        this.assertFlatten((Block)block, arg_0 -> TestBlockFlattener.lambda$testCardinalityIncreasingNestedDictionaryBlock$0((Block)block, arg_0));
    }

    @Test
    public void testCardinalityDecreasingNestedDictionaryBlock() {
        DictionaryBlock block = new DictionaryBlock((Block)new DictionaryBlock((Block)new DictionaryBlock(TestBlockFlattener.createLongArrayBlock(5L, 6L), new int[]{0, 1, 0, 0, 1, 1, 0}), new int[]{0, 1, 0}), new int[]{0, 1});
        this.assertFlatten((Block)block, arg_0 -> TestBlockFlattener.lambda$testCardinalityDecreasingNestedDictionaryBlock$1((Block)block, arg_0));
    }

    @Test
    public void testNestedDictionaryWithRLEWithLeftoverData() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayDeque<int[]> leasedArrays = new ArrayDeque<int[]>();
        for (int i = 0; i < 10; ++i) {
            int[] randomInts = IntStream.range(0, 100).map(j -> random.nextInt()).toArray();
            int[] array = this.allocator.borrowIntArray(100);
            System.arraycopy(randomInts, 0, array, 0, randomInts.length);
            leasedArrays.push(array);
        }
        while (!leasedArrays.isEmpty()) {
            this.allocator.returnArray((int[])leasedArrays.pop());
        }
        DictionaryBlock block = TestBlockFlattener.createTestDictionaryBlock((Block)TestBlockFlattener.createTestRleBlock(TestBlockFlattener.createIntArrayBlock(4), 3));
        this.assertFlatten((Block)block, flattenedBlock -> {
            Assert.assertEquals(flattenedBlock.getClass(), DictionaryBlock.class);
            Assert.assertEquals(((DictionaryBlock)flattenedBlock).getDictionary().getClass(), IntArrayBlock.class);
            Assert.assertEquals((int)flattenedBlock.getPositionCount(), (int)block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                Assert.assertEquals((long)IntegerType.INTEGER.getLong(flattenedBlock, i), (long)IntegerType.INTEGER.getLong((Block)block, i));
            }
        });
    }

    private void assertFlattenNumericTypeBlock(Type type, Block block, int expectedPositionCount, Class expectedClass) {
        this.assertFlatten(block, flattenedBlock -> {
            Assert.assertEquals((int)this.allocator.getBorrowedArrayCount(), (int)1);
            Assert.assertEquals((int)flattenedBlock.getPositionCount(), (int)block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                Assert.assertEquals((long)type.getLong(block, i), (long)type.getLong(flattenedBlock, i));
            }
            Assert.assertEquals(flattenedBlock.getClass(), DictionaryBlock.class);
            DictionaryBlock decodedDictionary = (DictionaryBlock)flattenedBlock;
            Assert.assertEquals(decodedDictionary.getDictionary().getClass(), (Object)expectedClass);
            Assert.assertEquals((int)expectedPositionCount, (int)decodedDictionary.getDictionary().getPositionCount());
        });
    }

    private void assertFlatten(Block block, Consumer<Block> blockConsumer) {
        Assert.assertEquals((int)this.allocator.getBorrowedArrayCount(), (int)0);
        try (BlockLease blockLease = this.flattener.flatten(block);){
            Assert.assertTrue((this.allocator.getBorrowedArrayCount() > 0 ? 1 : 0) != 0);
            Block retrievedBlock = (Block)blockLease.get();
            Assert.assertNotNull((Object)retrievedBlock);
            blockConsumer.accept(retrievedBlock);
            Assert.assertThrows(IllegalStateException.class, () -> blockLease.get());
        }
        Assert.assertEquals((int)this.allocator.getBorrowedArrayCount(), (int)0);
    }

    private static Block createLongArrayBlock(long ... values) {
        return new LongArrayBlock(values.length, Optional.empty(), values);
    }

    private static Block createIntArrayBlock(int ... values) {
        return new IntArrayBlock(values.length, Optional.empty(), values);
    }

    private static Block createShortArrayBlock(int ... values) {
        short[] shorts = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            shorts[i] = (short)values[i];
        }
        return new ShortArrayBlock(shorts.length, Optional.empty(), shorts);
    }

    private static Block createByteArrayBlock(int ... values) {
        byte[] bytes = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            bytes[i] = (byte)values[i];
        }
        return new ByteArrayBlock(bytes.length, Optional.empty(), bytes);
    }

    private static DictionaryBlock createTestDictionaryBlock(Block block) {
        int idsOffset = ThreadLocalRandom.current().nextInt(block.getPositionCount()) + 1;
        int[] dictionaryIndexes = TestBlockFlattener.createTestDictionaryIndexes(block.getPositionCount() + idsOffset);
        return new DictionaryBlock(idsOffset, block.getPositionCount(), block, dictionaryIndexes, false, DictionaryId.randomDictionaryId());
    }

    private static int[] createTestDictionaryIndexes(int valueCount) {
        int[] dictionaryIndexes = new int[valueCount * 2];
        for (int i = 0; i < valueCount; ++i) {
            dictionaryIndexes[i] = valueCount - i - 1;
            dictionaryIndexes[i + valueCount] = i;
        }
        return dictionaryIndexes;
    }

    private static RunLengthEncodedBlock createTestRleBlock(Block block, int position) {
        return new RunLengthEncodedBlock(block, position);
    }

    private static /* synthetic */ void lambda$testCardinalityDecreasingNestedDictionaryBlock$1(Block block, Block flattenedBlock) {
        Assert.assertEquals((int)flattenedBlock.getPositionCount(), (int)block.getPositionCount());
        Assert.assertEquals(((DictionaryBlock)flattenedBlock).getDictionary().getClass(), LongArrayBlock.class);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Assert.assertEquals((long)flattenedBlock.getLong(i), (long)block.getLong(i));
        }
    }

    private static /* synthetic */ void lambda$testCardinalityIncreasingNestedDictionaryBlock$0(Block block, Block flattenedBlock) {
        Assert.assertEquals((int)flattenedBlock.getPositionCount(), (int)block.getPositionCount());
        Assert.assertEquals(((DictionaryBlock)flattenedBlock).getDictionary().getClass(), LongArrayBlock.class);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Assert.assertEquals((long)flattenedBlock.getLong(i), (long)block.getLong(i));
        }
    }
}

