/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMethodHandleUtil {
    @Test
    public void testCompose2() throws Throwable {
        MethodHandle fUS2R = MethodHandleUtil.methodHandle(TestMethodHandleUtil.class, (String)"fUS2R", (Class[])new Class[]{U.class, S1.class, S2.class});
        MethodHandle fT2U = MethodHandleUtil.methodHandle(TestMethodHandleUtil.class, (String)"fT2U", (Class[])new Class[]{T1.class, T2.class});
        MethodHandle composed = MethodHandleUtil.compose((MethodHandle)fUS2R, (MethodHandle)fT2U);
        Assert.assertEquals((Object)composed.invokeExact(new T1(2), new T2(3), new S1(5), new S2(7)), (Object)new R(210));
    }

    @Test
    public void testCompose2withoutS() throws Throwable {
        MethodHandle fU2R = MethodHandleUtil.methodHandle(TestMethodHandleUtil.class, (String)"fU2R", (Class[])new Class[]{U.class});
        MethodHandle fT2U = MethodHandleUtil.methodHandle(TestMethodHandleUtil.class, (String)"fT2U", (Class[])new Class[]{T1.class, T2.class});
        MethodHandle composed = MethodHandleUtil.compose((MethodHandle)fU2R, (MethodHandle)fT2U);
        Assert.assertEquals((Object)composed.invokeExact(new T1(2), new T2(3)), (Object)new R(6));
    }

    @Test
    public void testCompose3() throws Throwable {
        MethodHandle fUV2R = MethodHandleUtil.methodHandle(TestMethodHandleUtil.class, (String)"fUV2R", (Class[])new Class[]{U.class, V.class});
        MethodHandle fS2U = MethodHandleUtil.methodHandle(TestMethodHandleUtil.class, (String)"fS2U", (Class[])new Class[]{S1.class, S2.class});
        MethodHandle fT2V = MethodHandleUtil.methodHandle(TestMethodHandleUtil.class, (String)"fT2V", (Class[])new Class[]{T1.class, T2.class});
        MethodHandle composed = MethodHandleUtil.compose((MethodHandle)fUV2R, (MethodHandle)fS2U, (MethodHandle)fT2V);
        Assert.assertEquals((Object)composed.invokeExact(new S1(2), new S2(3), new T1(5), new T2(7)), (Object)new R(210));
    }

    public static R fU2R(U u) {
        return new R(u.getValue());
    }

    public static R fUS2R(U u, S1 s1, S2 s2) {
        return new R(u.getValue() * s1.getValue() * s2.getValue());
    }

    public static R fUV2R(U u, V v) {
        return new R(u.getValue() * v.getValue());
    }

    public static U fT2U(T1 t1, T2 t2) {
        return new U(t1.getValue() * t2.getValue());
    }

    public static U fS2U(S1 s1, S2 s2) {
        return new U(s1.getValue() * s2.getValue());
    }

    public static V fT2V(T1 t1, T2 t2) {
        return new V(t1.getValue() * t2.getValue());
    }

    public static String squareBracket(String s) {
        return "[" + s + "]";
    }

    public static String squareBracket(String s, double d) {
        return "[" + s + "," + (long)d + "]";
    }

    public static String curlyBracket(String s, char c) {
        return "{" + s + "=" + c + "}";
    }

    public static double sum(long x, int c) {
        return (double)x + (double)c;
    }

    private static class T2
    extends Base {
        public T2(int value) {
            super(value);
        }
    }

    private static class T1
    extends Base {
        public T1(int value) {
            super(value);
        }
    }

    private static class S2
    extends Base {
        public S2(int value) {
            super(value);
        }
    }

    private static class S1
    extends Base {
        public S1(int value) {
            super(value);
        }
    }

    private static class R
    extends Base {
        public R(int value) {
            super(value);
        }
    }

    private static class V
    extends Base {
        public V(int value) {
            super(value);
        }
    }

    private static class U
    extends Base {
        public U(int value) {
            super(value);
        }
    }

    private static class Base {
        private final int value;

        public Base(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Base base = (Base)o;
            return this.value == base.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
        }
    }
}

