/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.predicate;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.HyperLogLogType;
import com.facebook.presto.common.type.TestingIdType;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDomain {
    private final ObjectMapper mapper;

    public TestDomain() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        this.mapper = new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
    }

    @Test
    public void testOrderableNone() {
        Domain domain = Domain.none((Type)BigintType.BIGINT);
        Assert.assertTrue((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testEquatableNone() {
        Domain domain = Domain.none((Type)TestingIdType.ID);
        Assert.assertTrue((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.all((Type)TestingIdType.ID));
    }

    @Test
    public void testUncomparableNone() {
        Domain domain = Domain.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.all((Type)HyperLogLogType.HYPER_LOG_LOG));
    }

    @Test
    public void testOrderableAll() {
        Domain domain = Domain.all((Type)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)BigintType.BIGINT));
    }

    @Test
    public void testEquatableAll() {
        Domain domain = Domain.all((Type)TestingIdType.ID);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)TestingIdType.ID));
    }

    @Test
    public void testUncomparableAll() {
        Domain domain = Domain.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)HyperLogLogType.HYPER_LOG_LOG));
    }

    @Test
    public void testOrderableNullOnly() {
        Domain domain = Domain.onlyNull((Type)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertTrue((boolean)domain.isOnlyNull());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertNull((Object)domain.getNullableSingleValue());
    }

    @Test
    public void testEquatableNullOnly() {
        Domain domain = Domain.onlyNull((Type)TestingIdType.ID);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertTrue((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.notNull((Type)TestingIdType.ID));
        Assert.assertNull((Object)domain.getNullableSingleValue());
    }

    @Test
    public void testUncomparableNullOnly() {
        Domain domain = Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertTrue((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertNull((Object)domain.getNullableSingleValue());
    }

    @Test
    public void testOrderableNotNull() {
        Domain domain = Domain.notNull((Type)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
    }

    @Test
    public void testEquatableNotNull() {
        Domain domain = Domain.notNull((Type)TestingIdType.ID);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.onlyNull((Type)TestingIdType.ID));
    }

    @Test
    public void testUncomparableNotNull() {
        Domain domain = Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG));
    }

    @Test
    public void testOrderableSingleValue() {
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)0L);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertTrue((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)true));
        Assert.assertEquals((Object)domain.getSingleValue(), (Object)0L);
        Assert.assertEquals((Object)domain.getNullableSingleValue(), (Object)0L);
        Assert.assertThrows(IllegalStateException.class, () -> Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false).getSingleValue());
    }

    @Test
    public void testEquatableSingleValue() {
        Domain domain = Domain.singleValue((Type)TestingIdType.ID, (Object)0L);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertTrue((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.create((ValueSet)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement(), (boolean)true));
        Assert.assertEquals((Object)domain.getSingleValue(), (Object)0L);
        Assert.assertEquals((Object)domain.getNullableSingleValue(), (Object)0L);
        Assert.assertThrows(IllegalStateException.class, () -> Domain.create((ValueSet)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}), (boolean)false).getSingleValue());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testUncomparableSingleValue() {
        Domain.singleValue((Type)HyperLogLogType.HYPER_LOG_LOG, (Object)Slices.EMPTY_SLICE);
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).intersect(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).intersect(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).intersect(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).intersect(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).intersect(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).intersect(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
    }

    @Test
    public void testUnion() {
        this.assertUnion(Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.none((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT));
        this.assertUnion(Domain.all((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.notNull((Type)BigintType.BIGINT), Domain.onlyNull((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.notNull((Type)BigintType.BIGINT), Domain.notNull((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.onlyNull((Type)BigintType.BIGINT), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)true));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true));
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)true));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)false));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        Domain domain = Domain.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.none((Type)DoubleType.DOUBLE);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.notNull((Type)BooleanType.BOOLEAN);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.onlyNull((Type)VarcharType.VARCHAR);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)Long.MIN_VALUE);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.singleValue((Type)TestingIdType.ID, (Object)Long.MIN_VALUE);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)3L, (boolean)true)}), (boolean)true);
        Assert.assertEquals((Object)domain, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)domain), Domain.class));
    }

    @Test
    public void testCanonicalize() throws Exception {
        this.assertSameDomain(Domain.onlyNull((Type)BigintType.BIGINT), Domain.onlyNull((Type)BigintType.BIGINT), false);
        this.assertSameDomain(Domain.notNull((Type)BigintType.BIGINT), Domain.notNull((Type)BigintType.BIGINT), false);
        this.assertDifferentDomain(Domain.onlyNull((Type)BigintType.BIGINT), Domain.notNull((Type)BigintType.BIGINT), false);
        this.assertDifferentDomain(Domain.onlyNull((Type)BigintType.BIGINT), Domain.onlyNull((Type)VarcharType.VARCHAR), false);
        this.assertDifferentDomain(Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)1L)), Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)2L)), false);
        this.assertSameDomain(Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)1L)), Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)2L)), true);
        this.assertDifferentDomain(Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)1L)), Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)1L, (Object)2L)), true);
    }

    private void assertSameDomain(Domain domain1, Domain domain2, boolean removeConstants) throws Exception {
        Assert.assertEquals((String)this.mapper.writeValueAsString((Object)domain1.canonicalize(removeConstants)), (String)this.mapper.writeValueAsString((Object)domain2.canonicalize(removeConstants)));
    }

    private void assertDifferentDomain(Domain domain1, Domain domain2, boolean removeConstants) throws Exception {
        Assert.assertNotEquals((Object)this.mapper.writeValueAsString((Object)domain1.canonicalize(removeConstants)), (Object)this.mapper.writeValueAsString((Object)domain2.canonicalize(removeConstants)));
    }

    private void assertUnion(Domain first, Domain second, Domain expected) {
        Assert.assertEquals((Object)first.union(second), (Object)expected);
        Assert.assertEquals((Object)Domain.union((List)ImmutableList.of((Object)first, (Object)second)), (Object)expected);
    }
}

