/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.predicate;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import io.airlift.slice.Slices;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMarker {
    private final ObjectMapper mapper;

    public TestMarker() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        this.mapper = new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
    }

    @Test
    public void testTypes() {
        Assert.assertEquals((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.upperUnbounded((Type)BigintType.BIGINT).getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testUnbounded() {
        Assert.assertTrue((boolean)Marker.lowerUnbounded((Type)BigintType.BIGINT).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.lowerUnbounded((Type)BigintType.BIGINT).isUpperUnbounded());
        Assert.assertTrue((boolean)Marker.upperUnbounded((Type)BigintType.BIGINT).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.upperUnbounded((Type)BigintType.BIGINT).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.above((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.above((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
    }

    @Test
    public void testComparisons() {
        ImmutableList markers = ImmutableList.of((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT), (Object)Marker.above((Type)BigintType.BIGINT, (Object)0L), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.below((Type)BigintType.BIGINT, (Object)2L), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)markers));
        for (int i = 0; i < markers.size(); ++i) {
            for (int j = 0; j < markers.size(); ++j) {
                Assert.assertEquals((int)((Marker)markers.get(i)).compareTo((Marker)markers.get(j)), (int)Integer.compare(i, j));
            }
        }
    }

    @Test
    public void testAdjacency() {
        ImmutableMap markers = ImmutableMap.builder().put((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT), (Object)-1000).put((Object)Marker.above((Type)BigintType.BIGINT, (Object)0L), (Object)-100).put((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L), (Object)-1).put((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L), (Object)0).put((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L), (Object)1).put((Object)Marker.below((Type)BigintType.BIGINT, (Object)2L), (Object)100).put((Object)Marker.upperUnbounded((Type)BigintType.BIGINT), (Object)1000).build();
        for (Map.Entry entry1 : markers.entrySet()) {
            for (Map.Entry entry2 : markers.entrySet()) {
                boolean adjacent = ((Marker)entry1.getKey()).isAdjacent((Marker)entry2.getKey());
                boolean distanceIsOne = Math.abs((Integer)entry1.getValue() - (Integer)entry2.getValue()) == 1;
                Assert.assertEquals((boolean)adjacent, (boolean)distanceIsOne);
            }
        }
        Assert.assertEquals((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent(), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent(), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertThrows(IllegalStateException.class, () -> Marker.below((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent());
        Assert.assertThrows(IllegalStateException.class, () -> Marker.above((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent());
        Assert.assertThrows(IllegalStateException.class, () -> Marker.lowerUnbounded((Type)BigintType.BIGINT).lesserAdjacent());
        Assert.assertThrows(IllegalStateException.class, () -> Marker.lowerUnbounded((Type)BigintType.BIGINT).greaterAdjacent());
        Assert.assertThrows(IllegalStateException.class, () -> Marker.upperUnbounded((Type)BigintType.BIGINT).lesserAdjacent());
        Assert.assertThrows(IllegalStateException.class, () -> Marker.upperUnbounded((Type)BigintType.BIGINT).greaterAdjacent());
    }

    @Test
    public void testJsonSerialization() throws Exception {
        Marker marker = Marker.above((Type)BigintType.BIGINT, (Object)0L);
        Assert.assertEquals((Object)marker, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)marker, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.below((Type)DoubleType.DOUBLE, (Object)0.123);
        Assert.assertEquals((Object)marker, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Type)BooleanType.BOOLEAN, (Object)true);
        Assert.assertEquals((Object)marker, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.upperUnbounded((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)marker, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.lowerUnbounded((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)marker, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)marker), Marker.class));
    }

    @Test
    public void testCanonicalize() throws Exception {
        this.assertSameMarker(Marker.above((Type)BigintType.BIGINT, (Object)0L), Marker.above((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertSameMarker(Marker.above((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")), Marker.above((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")), false);
        this.assertSameMarker(Marker.upperUnbounded((Type)BigintType.BIGINT), Marker.upperUnbounded((Type)BigintType.BIGINT), false);
        this.assertDifferentMarker(Marker.above((Type)BigintType.BIGINT, (Object)0L), Marker.above((Type)BigintType.BIGINT, (Object)5L), false);
        this.assertDifferentMarker(Marker.above((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")), Marker.above((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abcd")), false);
        this.assertDifferentMarker(Marker.upperUnbounded((Type)BigintType.BIGINT), Marker.upperUnbounded((Type)VarcharType.VARCHAR), false);
        this.assertDifferentMarker(Marker.above((Type)BigintType.BIGINT, (Object)0L), Marker.below((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertDifferentMarker(Marker.below((Type)BigintType.BIGINT, (Object)0L), Marker.exactly((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertDifferentMarker(Marker.upperUnbounded((Type)BigintType.BIGINT), Marker.lowerUnbounded((Type)BigintType.BIGINT), false);
        this.assertSameMarker(Marker.above((Type)BigintType.BIGINT, (Object)0L), Marker.above((Type)BigintType.BIGINT, (Object)5L), true);
        this.assertSameMarker(Marker.below((Type)BigintType.BIGINT, (Object)0L), Marker.below((Type)BigintType.BIGINT, (Object)5L), true);
        this.assertSameMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L), Marker.exactly((Type)BigintType.BIGINT, (Object)5L), true);
        this.assertSameMarker(Marker.above((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")), Marker.above((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abcd")), true);
        this.assertDifferentMarker(Marker.above((Type)BigintType.BIGINT, (Object)0L), Marker.below((Type)BigintType.BIGINT, (Object)0L), true);
        this.assertDifferentMarker(Marker.below((Type)BigintType.BIGINT, (Object)0L), Marker.exactly((Type)BigintType.BIGINT, (Object)0L), true);
        this.assertDifferentMarker(Marker.upperUnbounded((Type)BigintType.BIGINT), Marker.lowerUnbounded((Type)BigintType.BIGINT), true);
    }

    @Test
    public void testGetValue() {
        Assert.assertTrue((boolean)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).getObjectValue().isPresent());
        Assert.assertTrue((boolean)Marker.above((Type)BigintType.BIGINT, (Object)1L).getObjectValue().isPresent());
        Assert.assertTrue((boolean)Marker.below((Type)BigintType.BIGINT, (Object)1L).getObjectValue().isPresent());
        Assert.assertFalse((boolean)Marker.upperUnbounded((Type)BigintType.BIGINT).getObjectValue().isPresent());
        Assert.assertFalse((boolean)Marker.lowerUnbounded((Type)BigintType.BIGINT).getObjectValue().isPresent());
    }

    private void assertSameMarker(Marker marker1, Marker marker2, boolean removeConstants) throws Exception {
        Assert.assertEquals((String)this.mapper.writeValueAsString((Object)marker1.canonicalize(removeConstants)), (String)this.mapper.writeValueAsString((Object)marker2.canonicalize(removeConstants)));
    }

    private void assertDifferentMarker(Marker marker1, Marker marker2, boolean removeConstants) throws Exception {
        Assert.assertNotEquals((Object)this.mapper.writeValueAsString((Object)marker1.canonicalize(removeConstants)), (Object)this.mapper.writeValueAsString((Object)marker2.canonicalize(removeConstants)));
    }
}

