/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.DecimalParseResult;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDecimals {
    @Test
    public void testParse() {
        this.assertParseResult("0", 0L, 1, 0);
        this.assertParseResult("0.", 0L, 1, 0);
        this.assertParseResult(".0", 0L, 1, 1);
        this.assertParseResult("+0", 0L, 1, 0);
        this.assertParseResult("-0", 0L, 1, 0);
        this.assertParseResult("000", 0L, 1, 0);
        this.assertParseResult("+000", 0L, 1, 0);
        this.assertParseResult("-000", 0L, 1, 0);
        this.assertParseResult("0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("+0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("-0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("1.1", 11L, 2, 1);
        this.assertParseResult("1.", 1L, 1, 0);
        this.assertParseResult("+1.1", 11L, 2, 1);
        this.assertParseResult("+1.", 1L, 1, 0);
        this.assertParseResult("-1.1", -11L, 2, 1);
        this.assertParseResult("-1.", -1L, 1, 0);
        this.assertParseResult("0001.1", 11L, 2, 1);
        this.assertParseResult("+0001.1", 11L, 2, 1);
        this.assertParseResult("-0001.1", -11L, 2, 1);
        this.assertParseResult("0.1", 1L, 1, 1);
        this.assertParseResult(".1", 1L, 1, 1);
        this.assertParseResult("+0.1", 1L, 1, 1);
        this.assertParseResult("+.1", 1L, 1, 1);
        this.assertParseResult("-0.1", -1L, 1, 1);
        this.assertParseResult("-.1", -1L, 1, 1);
        this.assertParseResult(".1", 1L, 1, 1);
        this.assertParseResult("+.1", 1L, 1, 1);
        this.assertParseResult("-.1", -1L, 1, 1);
        this.assertParseResult("000.1", 1L, 1, 1);
        this.assertParseResult("+000.1", 1L, 1, 1);
        this.assertParseResult("-000.1", -1L, 1, 1);
        this.assertParseResult("12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-12345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-00012345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-0.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-000.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("12345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+12345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-12345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("00012345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+00012345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-00012345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("0.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult(".12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("0000.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0000.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0000.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 38);
    }

    @Test
    public void testParseIncludeLeadingZerosInPrecision() {
        this.assertParseResultIncludeLeadingZerosInPrecision("0", 0L, 1, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+0", 0L, 1, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-0", 0L, 1, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("00000000000000000", 0L, 17, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+00000000000000000", 0L, 17, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-00000000000000000", 0L, 17, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("1.1", 11L, 2, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("+1.1", 11L, 2, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("-1.1", -11L, 2, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("0001.1", 11L, 5, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("+0001.1", 11L, 5, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("-0001.1", -11L, 5, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("000", 0L, 3, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000", 0L, 3, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000", 0L, 3, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("000.1", 1L, 4, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000.1", 1L, 4, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000.1", -1L, 4, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("000000000000000000", 0L, 18, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000000000000000000", 0L, 18, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000000000000000000", 0L, 18, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("000000000000000000.123", TestDecimals.encodeUnscaledValue("123"), 21, 3);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000000000000000000.123", TestDecimals.encodeUnscaledValue("123"), 21, 3);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000000000000000000.123", TestDecimals.encodeUnscaledValue("-123"), 21, 3);
    }

    @Test
    public void testRejectNoDigits() {
        this.assertParseFailure(".");
        this.assertParseFailure("+.");
        this.assertParseFailure("-.");
    }

    @Test
    public void testEncodeShortScaledValue() {
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2.00"), (int)2), (long)200L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2.13"), (int)2), (long)213L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("172.60"), (int)2), (long)17260L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2"), (int)2), (long)200L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("172.6"), (int)2), (long)17260L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2.00"), (int)2), (long)-200L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2.13"), (int)2), (long)-213L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2"), (int)2), (long)-200L);
    }

    @Test
    public void testEncodeScaledValue() {
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2.00"), (int)2), (Object)TestDecimals.sliceFromBytes(200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2.13"), (int)2), (Object)TestDecimals.sliceFromBytes(213, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("172.60"), (int)2), (Object)TestDecimals.sliceFromBytes(108, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2"), (int)2), (Object)TestDecimals.sliceFromBytes(200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("172.6"), (int)2), (Object)TestDecimals.sliceFromBytes(108, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        int minus = 128;
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2.00"), (int)2), (Object)TestDecimals.sliceFromBytes(200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, minus));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2.13"), (int)2), (Object)TestDecimals.sliceFromBytes(213, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, minus));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2"), (int)2), (Object)TestDecimals.sliceFromBytes(200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, minus));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-172.60"), (int)2), (Object)TestDecimals.sliceFromBytes(108, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, minus));
    }

    private static Slice sliceFromBytes(int ... bytes) {
        byte[] buffer = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buffer[i] = TestDecimals.toByteExact(bytes[i]);
        }
        return Slices.wrappedBuffer((byte[])buffer);
    }

    private static byte toByteExact(int value) {
        Preconditions.checkArgument((0 <= value && value <= 255 ? 1 : 0) != 0);
        return (byte)value;
    }

    private void assertParseResult(String value, Object expectedObject, int expectedPrecision, int expectedScale) {
        Assert.assertEquals((Object)Decimals.parse((String)value), (Object)new DecimalParseResult(expectedObject, DecimalType.createDecimalType((int)expectedPrecision, (int)expectedScale)));
    }

    private void assertParseResultIncludeLeadingZerosInPrecision(String value, Object expectedObject, int expectedPrecision, int expectedScale) {
        Assert.assertEquals((Object)Decimals.parseIncludeLeadingZerosInPrecision((String)value), (Object)new DecimalParseResult(expectedObject, DecimalType.createDecimalType((int)expectedPrecision, (int)expectedScale)));
    }

    private void assertParseFailure(String text) {
        try {
            Decimals.parse((String)text);
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = String.format("Invalid decimal value '%s'", text);
            if (!Objects.equals(e.getMessage(), expectedMessage)) {
                Assert.fail((String)String.format("Unexpected exception, exception with message '%s' was expected", expectedMessage), (Throwable)e);
            }
            return;
        }
        Assert.fail((String)"Parse failure was expected");
    }

    private static Slice encodeUnscaledValue(String unscaledValue) {
        return Decimals.encodeUnscaledValue((BigInteger)new BigInteger(unscaledValue));
    }
}

