/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.DistinctTypeInfo;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeSignatureUtils;
import com.facebook.presto.common.type.VarcharEnumType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeSignatureUtils {
    @Test
    public void testResolveIntermediateTypeNonGenericBigintType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"bigint");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"bigint");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericDifferentArgTypes() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"bigint");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"bigint");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"double")), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"double")));
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericBigintType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"T");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"bigint");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)ImmutableList.of((Object)actualIntermediateType), (List)ImmutableList.of((Object)expectedIntermediateType));
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericBigintArgType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"test(T)");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"test(bigint)");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericMultipleArgs() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"test(array(T),boolean,double,integer,E,array(T))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"test(array(bigint),boolean,double,integer,varchar(100), array(bigint))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericRowType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"row(bigint)");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"row(bigint)");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericRowType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"row(T)");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"row(bigint)");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericRowArgTypeSingleParam() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"test(row(T))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"test(row(bigint))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericRowArgTypeMultipleParams() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"test(row(array(T),boolean,double,integer,E,array(T)))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"test(row(array(bigint),boolean,double,integer,varchar(100), array(bigint)))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericRowTypeMultipleParams() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"row(array(T),boolean,double,integer,E,array(T),array(integer))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"row(array(bigint),boolean,double,integer,varchar(100),array(bigint),array(integer))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericDecimalType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"decimal(15, 2)");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"test(decimal(15, 2))");
        List expectedIntermediateTypeParameters = expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures();
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)ImmutableList.of((Object)actualIntermediateType), (List)expectedIntermediateTypeParameters);
        Assert.assertFalse((boolean)expectedIntermediateTypeParameters.isEmpty());
        Assert.assertEquals((Object)resolvedIntermediateType, expectedIntermediateTypeParameters.get(0));
    }

    @Test
    public void testResolveIntermediateTypeNonGenericDecimalArgType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"test(decimal(15, 2))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"test(decimal(15, 2))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericMapArgType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"map(T, decimal(15, 2))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"map(integer, decimal(15, 2))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericMapArgTypeMapParam() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"map(map(array(K), V), decimal(15, 2))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"map(map(array(double), decimal(15, 2)), decimal(15, 2))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericRowTypeMapParam() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"row(map(map(array(K), V), decimal(15, 2)))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"row(map(map(array(double), varchar(50)), decimal(15, 2)))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericRowTypeMapParam() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"row(map(map(array(double), varchar(50)), decimal(15, 2)))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"row(map(map(array(double), varchar(50)), decimal(15, 2)))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericFunctionType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"S");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"array(bigint)");
        List actualIntermediateTypeParams = TypeSignature.parseTypeSignature((String)"test(T, S, function(S, T, S), function(S, S, S))").getTypeOrNamedTypeParametersAsTypeSignatures();
        List expectedIntermediateTypeParams = TypeSignature.parseTypeSignature((String)"test(integer, array(bigint), function(array(bigint), integer, array(bigint)), function(array(bigint), array(bigint), array(bigint)))").getTypeOrNamedTypeParametersAsTypeSignatures();
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateTypeParams, (List)expectedIntermediateTypeParams);
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Parameters size: 7 and argumentTypes size: 6 do not match !")
    public void testFailingResolveIntermediateTypeExtraParams() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"row(array(T),boolean,double,integer,E,array(T),array(integer))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"row(array(bigint),boolean,double,integer,varchar(100),array(bigint))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Parameters size: 6 and argumentTypes size: 7 do not match !")
    public void testFailingResolveIntermediateTypeExtraArgs() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"row(array(T),boolean,double,integer,E,array(T))");
        TypeSignature expectedIntermediateType = TypeSignature.parseTypeSignature((String)"row(array(bigint),boolean,double,integer,varchar(100),array(bigint), array(integer))");
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericEnumParametricType() {
        TypeSignature actualIntermediateType = TypeSignature.parseTypeSignature((String)"test(T)");
        TypeSignature test = new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.my_enum_2", (Map)ImmutableMap.of((Object)"k", (Object)1L))).getTypeSignature())});
        TypeSignature expectedIntermediateType = new TypeSignature("test", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)test)});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericEnumParametricType() {
        TypeSignature actualIntermediateType = new TypeSignature("test", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.my_enum_2", (Map)ImmutableMap.of((Object)"k", (Object)1L))).getTypeSignature())}))});
        TypeSignature expectedIntermediateType = new TypeSignature("test", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.my_enum_2", (Map)ImmutableMap.of((Object)"k", (Object)1L))).getTypeSignature())}))});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericRowEnumParametricType() {
        TypeSignature actualIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"double"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.my_enum_2", (Map)ImmutableMap.of((Object)"k", (Object)1L))).getTypeSignature())})))});
        TypeSignature expectedIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"double"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.my_enum_2", (Map)ImmutableMap.of((Object)"k", (Object)1L))).getTypeSignature())})))});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericRowEnumParametricType() {
        TypeSignature actualIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"K"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"T"))})))});
        TypeSignature expectedIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"array(double)"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.my_enum", (Map)ImmutableMap.of((Object)"k", (Object)"v)))"))).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.my_enum_2", (Map)ImmutableMap.of((Object)"k", (Object)1L))).getTypeSignature())})))});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericDistinctParametricType() {
        TypeSignature actualIntermediateType = new TypeSignature("test", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"bigint")), TypeSignatureParameter.of((TypeSignature)TestTypeSignatureUtils.createTypeSignatureWithDistinctParameterKind("test.dt.int00", Optional.empty(), "integer"))});
        TypeSignature expectedIntermediateType = new TypeSignature("test", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"bigint")), TypeSignatureParameter.of((TypeSignature)TestTypeSignatureUtils.createTypeSignatureWithDistinctParameterKind("test.dt.int00", Optional.empty(), "integer"))});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericDistinctParametricType() {
        TypeSignature actualIntermediateType = new TypeSignature("test", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"K")), TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"V"))});
        TypeSignature expectedIntermediateType = new TypeSignature("test", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"array(double)")), TypeSignatureParameter.of((TypeSignature)TestTypeSignatureUtils.createTypeSignatureWithDistinctParameterKind("test.dt.int00", Optional.empty(), "bigint"))});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeNonGenericRowDistinctParametricType() {
        TypeSignature actualIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"K"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TestTypeSignatureUtils.createTypeSignatureWithDistinctParameterKind("test.dt.int00", Optional.empty(), "integer")))});
        TypeSignature expectedIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"array(double)"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TestTypeSignatureUtils.createTypeSignatureWithDistinctParameterKind("test.dt.int00", Optional.empty(), "integer")))});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    @Test
    public void testResolveIntermediateTypeGenericRowDistinctParametricType() {
        TypeSignature actualIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"K"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"V")))});
        TypeSignature expectedIntermediateType = new TypeSignature("row", new TypeSignatureParameter[]{TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature((String)"array(double)"))), TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TestTypeSignatureUtils.createTypeSignatureWithDistinctParameterKind("test.dt.int00", Optional.empty(), "integer")))});
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)actualIntermediateType, (List)actualIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures(), (List)expectedIntermediateType.getTypeOrNamedTypeParametersAsTypeSignatures());
        Assert.assertEquals((Object)resolvedIntermediateType, (Object)expectedIntermediateType);
    }

    private static TypeSignature createTypeSignatureWithDistinctParameterKind(String name, Optional<String> parent, String baseType) {
        return new TypeSignature(new DistinctTypeInfo(QualifiedObjectName.valueOf((String)name), TypeSignature.parseTypeSignature((String)baseType), parent.map(QualifiedObjectName::valueOf), true));
    }
}

