/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.DistinctTypeInfo;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeUtils {
    @Test
    public void testContainsDistinctType() {
        QualifiedObjectName distinctTypeName = QualifiedObjectName.valueOf((String)"test.dt.int00");
        DistinctTypeInfo distinctTypeInfo = new DistinctTypeInfo(distinctTypeName, IntegerType.INTEGER.getTypeSignature(), Optional.empty(), false);
        DistinctType distinctType = new DistinctType(distinctTypeInfo, (Type)IntegerType.INTEGER, null);
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR)));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)distinctType)));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR)))));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)distinctType)))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)distinctType))));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR))))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)distinctType)))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)distinctType))))));
    }

    @Test
    public void testDoubleHashCode() {
        Assert.assertEquals((long)TypeUtils.doubleHashCode((double)0.0), (long)TypeUtils.doubleHashCode((double)Double.parseDouble("-0")));
        Assert.assertEquals((long)TypeUtils.doubleHashCode((double)Double.NaN), (long)TypeUtils.doubleHashCode((double)Double.longBitsToDouble(9221140251894092340L)));
    }

    @Test
    public void testDoubleEquals() {
        Assert.assertTrue((boolean)TypeUtils.doubleEquals((double)0.0, (double)Double.parseDouble("-0")));
        Assert.assertTrue((boolean)TypeUtils.doubleEquals((double)Double.NaN, (double)Double.longBitsToDouble(9221140251894092340L)));
    }

    @Test
    public void testDoubleCompare() {
        Assert.assertEquals((int)TypeUtils.doubleCompare((double)0.0, (double)Double.parseDouble("-0")), (int)0);
        Assert.assertEquals((int)TypeUtils.doubleCompare((double)Double.NaN, (double)Double.NaN), (int)0);
        Assert.assertEquals((int)TypeUtils.doubleCompare((double)Double.NaN, (double)Double.longBitsToDouble(9221140251894092340L)), (int)0);
    }

    @Test
    public void testRealHashCode() {
        Assert.assertEquals((long)TypeUtils.realHashCode((float)0.0f), (long)TypeUtils.realHashCode((float)Float.parseFloat("-0")));
        Assert.assertEquals((long)TypeUtils.realHashCode((float)Float.NaN), (long)TypeUtils.realHashCode((float)Float.intBitsToFloat(2143294004)));
    }

    @Test
    public void testRealEquals() {
        Assert.assertTrue((boolean)TypeUtils.realEquals((float)0.0f, (float)Float.parseFloat("-0")));
        Assert.assertTrue((boolean)TypeUtils.realEquals((float)Float.NaN, (float)Float.NaN));
        Assert.assertTrue((boolean)TypeUtils.realEquals((float)Float.NaN, (float)Float.intBitsToFloat(2143294004)));
    }

    @Test
    public void testRealCompare() {
        Assert.assertEquals((int)TypeUtils.realCompare((float)0.0f, (float)Float.parseFloat("-0")), (int)0);
        Assert.assertEquals((int)TypeUtils.realCompare((float)Float.NaN, (float)Float.NaN), (int)0);
        Assert.assertEquals((int)TypeUtils.realCompare((float)Float.NaN, (float)Float.intBitsToFloat(2143294004)), (int)0);
    }
}

