/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.presto.common.InvalidFunctionArgumentException;
import com.facebook.presto.common.Subfield;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

class SubfieldTokenizer
implements Iterator<Subfield.PathElement> {
    private static final char QUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private static final char DOT = '.';
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final char UNICODE_CARET = '\u2038';
    private static final char WILDCARD = '*';
    private static final char DOLLAR = '$';
    private final String path;
    private State state = State.NOT_READY;
    private int index;
    private boolean firstSegment = true;
    private Subfield.PathElement next;

    SubfieldTokenizer(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
        if (path.isEmpty()) {
            throw this.invalidSubfieldPath();
        }
    }

    @Override
    public final boolean hasNext() {
        if (this.state == State.FAILED) {
            throw new IllegalStateException();
        }
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final Subfield.PathElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        Subfield.PathElement result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private Subfield.PathElement computeNext() {
        if (!this.hasNextCharacter()) {
            this.state = State.DONE;
            return null;
        }
        if (this.tryMatch('.')) {
            Subfield.PathElement token = this.tryMatch('$') ? this.matchDollarPathElement() : this.matchPathSegment();
            this.firstSegment = false;
            return token;
        }
        if (this.tryMatch('[')) {
            Subfield.PathElement token = this.tryMatch('\"') ? this.matchQuotedSubscript() : (this.tryMatch('*') ? this.matchWildcardSubscript() : this.matchUnquotedSubscript());
            this.match(']');
            this.firstSegment = false;
            return token;
        }
        if (this.firstSegment) {
            Subfield.PathElement token = this.matchPathSegment();
            this.firstSegment = false;
            return token;
        }
        throw this.invalidSubfieldPath();
    }

    private Subfield.PathElement matchPathSegment() {
        int start = this.index;
        while (this.hasNextCharacter() && SubfieldTokenizer.isUnquotedPathCharacter(this.peekCharacter())) {
            this.nextCharacter();
        }
        int end = this.index;
        String token = this.path.substring(start, end);
        if (token.isEmpty()) {
            throw this.invalidSubfieldPath();
        }
        return new Subfield.NestedField(token);
    }

    private Subfield.PathElement matchWildcardSubscript() {
        return Subfield.allSubscripts();
    }

    private Subfield.PathElement matchDollarPathElement() {
        return Subfield.noSubfield();
    }

    private static boolean isUnquotedPathCharacter(char c) {
        return c == ':' || c == '$' || c == '-' || c == '/' || c == '@' || c == '|' || c == '#' || c == ' ' || SubfieldTokenizer.isUnquotedSubscriptCharacter(c);
    }

    private Subfield.PathElement matchUnquotedSubscript() {
        int start = this.index;
        while (this.hasNextCharacter() && SubfieldTokenizer.isUnquotedSubscriptCharacter(this.peekCharacter())) {
            this.nextCharacter();
        }
        int end = this.index;
        String token = this.path.substring(start, end);
        if (token.isEmpty()) {
            throw this.invalidSubfieldPath();
        }
        try {
            return new Subfield.LongSubscript(Long.valueOf(token));
        }
        catch (NumberFormatException e) {
            throw this.invalidSubfieldPath(e);
        }
    }

    private static boolean isUnquotedSubscriptCharacter(char c) {
        return c == '-' || c == '_' || Character.isLetterOrDigit(c);
    }

    private Subfield.PathElement matchQuotedSubscript() {
        StringBuilder token = new StringBuilder();
        boolean escaped = false;
        while (this.hasNextCharacter() && (escaped || this.peekCharacter() != '\"')) {
            if (escaped) {
                switch (this.peekCharacter()) {
                    case '\"': 
                    case '\\': {
                        token.append(this.peekCharacter());
                        break;
                    }
                    default: {
                        throw this.invalidSubfieldPath();
                    }
                }
                escaped = false;
            } else if (this.peekCharacter() == '\\') {
                escaped = true;
            } else {
                token.append(this.peekCharacter());
            }
            this.nextCharacter();
        }
        if (escaped) {
            throw this.invalidSubfieldPath();
        }
        this.match('\"');
        String tokenString = token.toString();
        if (tokenString.equals(String.valueOf('*'))) {
            return Subfield.allSubscripts();
        }
        return new Subfield.StringSubscript(tokenString);
    }

    private boolean hasNextCharacter() {
        return this.index < this.path.length();
    }

    private void match(char expected) {
        if (!this.tryMatch(expected)) {
            throw this.invalidSubfieldPath();
        }
    }

    private boolean tryMatch(char expected) {
        if (!this.hasNextCharacter() || this.peekCharacter() != expected) {
            return false;
        }
        ++this.index;
        return true;
    }

    private void nextCharacter() {
        ++this.index;
    }

    private char peekCharacter() {
        return this.path.charAt(this.index);
    }

    private InvalidFunctionArgumentException invalidSubfieldPath() {
        return new InvalidFunctionArgumentException(String.format("Invalid subfield path: '%s'", this));
    }

    private InvalidFunctionArgumentException invalidSubfieldPath(Exception ex) {
        return new InvalidFunctionArgumentException(String.format("Invalid subfield path: '%s'", this), ex);
    }

    public String toString() {
        return this.path.substring(0, this.index) + '\u2038' + this.path.substring(this.index);
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

