/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.TimeZoneKey;
import java.util.Objects;

public final class DateTimeEncoding {
    private static final int TIME_ZONE_MASK = 4095;
    private static final int MILLIS_SHIFT = 12;
    private static final long MAX_MILLIS = 0x7FFFFFFFFFFFFL;
    private static final long MIN_MILLIS = -2251799813685248L;

    private DateTimeEncoding() {
    }

    private static long pack(long millisUtc, short timeZoneKey) {
        if (millisUtc > 0x7FFFFFFFFFFFFL || millisUtc < -2251799813685248L) {
            throw new ArithmeticException(String.format("TimestampWithTimeZone overflow: %s ms", millisUtc));
        }
        return millisUtc << 12 | (long)(timeZoneKey & 0xFFF);
    }

    public static long packDateTimeWithZone(long millisUtc, String zoneId) {
        return DateTimeEncoding.packDateTimeWithZone(millisUtc, TimeZoneKey.getTimeZoneKey(zoneId));
    }

    public static long packDateTimeWithZone(long millisUtc, int offsetMinutes) {
        return DateTimeEncoding.packDateTimeWithZone(millisUtc, TimeZoneKey.getTimeZoneKeyForOffset(offsetMinutes));
    }

    public static long packDateTimeWithZone(long millisUtc, TimeZoneKey timeZoneKey) {
        Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        return DateTimeEncoding.pack(millisUtc, timeZoneKey.getKey());
    }

    public static long unpackMillisUtc(long dateTimeWithTimeZone) {
        return dateTimeWithTimeZone >> 12;
    }

    public static TimeZoneKey unpackZoneKey(long dateTimeWithTimeZone) {
        return TimeZoneKey.getTimeZoneKey((short)(dateTimeWithTimeZone & 0xFFFL));
    }

    public static long updateMillisUtc(long newMillsUtc, long dateTimeWithTimeZone) {
        return DateTimeEncoding.pack(newMillsUtc, (short)(dateTimeWithTimeZone & 0xFFFL));
    }
}

