/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.transaction;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.UUID;

@ThriftStruct
public final class TransactionId {
    private final UUID uuid;

    public TransactionId(UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid, "uuid is null");
    }

    @ThriftConstructor
    public TransactionId(String uuid) {
        this(UUID.fromString(uuid));
    }

    public static TransactionId create() {
        return new TransactionId(UUID.randomUUID());
    }

    @JsonCreator
    public static TransactionId valueOf(String value) {
        return new TransactionId(UUID.fromString(value));
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionId other = (TransactionId)obj;
        return Objects.equals(this.uuid, other.uuid);
    }

    @JsonValue
    @ThriftField(value=1, name="uuid")
    public String toString() {
        return this.uuid.toString();
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

