/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.ParameterKind;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class TypeSignatureUtils {
    private TypeSignatureUtils() {
    }

    public static TypeSignature resolveIntermediateType(TypeSignature actualTypeSignature, List<TypeSignature> actualTypeSignatureParameters, List<TypeSignature> expectedTypeSignatureParameters) {
        Map<TypeSignature, TypeSignature> typeSignatureMap = TypeSignatureUtils.getTypeSignatureMap(actualTypeSignatureParameters, expectedTypeSignatureParameters);
        return TypeSignatureUtils.resolveTypeSignatures(actualTypeSignature, typeSignatureMap).getTypeSignature();
    }

    private static Map<TypeSignature, TypeSignature> getTypeSignatureMap(List<TypeSignature> parameters, List<TypeSignature> argumentTypes) {
        HashMap<TypeSignature, TypeSignature> typeSignatureMap = new HashMap<TypeSignature, TypeSignature>();
        if (argumentTypes.size() != parameters.size()) {
            throw new IllegalStateException("Parameters size: " + parameters.size() + " and argumentTypes size: " + argumentTypes.size() + " do not match !");
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            TypeSignature parameter = parameters.get(i);
            TypeSignature argumentType = argumentTypes.get(i);
            if (parameter.getParameters().isEmpty() || !TypeSignatureUtils.areParametersTypeSignatureOrNamedTypedSignature(parameter.getParameters())) {
                typeSignatureMap.put(parameter, argumentType);
                continue;
            }
            typeSignatureMap.putAll(TypeSignatureUtils.getTypeSignatureMap(parameter.getTypeOrNamedTypeParametersAsTypeSignatures(), argumentType.getTypeOrNamedTypeParametersAsTypeSignatures()));
        }
        return typeSignatureMap;
    }

    private static NamedTypeSignature resolveTypeSignatures(TypeSignature typeSignature, Map<TypeSignature, TypeSignature> typeSignatureMap) {
        if (typeSignatureMap.containsKey(typeSignature)) {
            TypeSignature resolvedTypeSignature = typeSignatureMap.get(typeSignature);
            return new NamedTypeSignature(Optional.empty(), resolvedTypeSignature);
        }
        ArrayList<NamedTypeSignature> namedTypeSignatures = new ArrayList<NamedTypeSignature>();
        ArrayList<TypeSignature> typeSignatures = new ArrayList<TypeSignature>();
        for (TypeSignature typeParameterSignature : typeSignature.getTypeOrNamedTypeParametersAsTypeSignatures()) {
            boolean isRowTypeSignatureBase = typeSignature.getBase().equals("row");
            if (typeSignatureMap.containsKey(typeParameterSignature)) {
                TypeSignature resolvedTypeParameterSignature = typeSignatureMap.get(typeParameterSignature);
                if (isRowTypeSignatureBase) {
                    namedTypeSignatures.add(new NamedTypeSignature(Optional.empty(), resolvedTypeParameterSignature));
                    continue;
                }
                typeSignatures.add(resolvedTypeParameterSignature);
                continue;
            }
            NamedTypeSignature namedTypeSignature = TypeSignatureUtils.resolveTypeSignatures(typeParameterSignature, typeSignatureMap);
            if (isRowTypeSignatureBase) {
                namedTypeSignatures.add(namedTypeSignature);
                continue;
            }
            typeSignatures.add(namedTypeSignature.getTypeSignature());
        }
        List parameters = !typeSignatures.isEmpty() ? typeSignatures.stream().map(TypeSignatureParameter::of).collect(Collectors.toList()) : namedTypeSignatures.stream().map(TypeSignatureParameter::of).collect(Collectors.toList());
        return new NamedTypeSignature(Optional.empty(), new TypeSignature(typeSignature.getBase(), Collections.unmodifiableList(parameters)));
    }

    private static boolean areParametersTypeSignatureOrNamedTypedSignature(List<TypeSignatureParameter> parameters) {
        return !parameters.isEmpty() && parameters.stream().map(TypeSignatureParameter::getKind).allMatch(parameterKind -> parameterKind.equals((Object)ParameterKind.NAMED_TYPE) || parameterKind.equals((Object)ParameterKind.TYPE));
    }
}

