/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.batchreader.BytesUtils;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;

public final class BinaryBatchDictionary
extends Dictionary {
    private final byte[] pageBuffer;
    private final int dictionarySize;
    private final int[] offsets;

    public BinaryBatchDictionary(DictionaryPage dictionaryPage) {
        super(dictionaryPage.getEncoding());
        int offset;
        int length;
        Objects.requireNonNull(dictionaryPage, "dictionaryPage is null");
        Preconditions.checkArgument((dictionaryPage.getDictionarySize() >= 0 ? 1 : 0) != 0, (Object)"Dictionary size should be greater than or equal to zero");
        this.dictionarySize = dictionaryPage.getDictionarySize();
        this.pageBuffer = Objects.requireNonNull(dictionaryPage.getSlice(), "dictionary slice is null").getBytes();
        IntArrayList offsetList = new IntArrayList();
        for (offset = 0; offset < this.pageBuffer.length; offset += 4 + length) {
            length = BytesUtils.getInt(this.pageBuffer, offset);
            offsetList.add(offset);
        }
        offsetList.add(offset);
        this.offsets = offsetList.toIntArray();
        Preconditions.checkArgument((this.offsets.length - 1 == this.dictionarySize ? 1 : 0) != 0, (Object)"Dictionary size and number of entries don't match");
    }

    public int getLength(int dictionaryId) {
        Preconditions.checkArgument((dictionaryId >= 0 && dictionaryId < this.dictionarySize ? 1 : 0) != 0, (String)"invalid dictionary id: %s", (int)dictionaryId);
        return this.offsets[dictionaryId + 1] - (this.offsets[dictionaryId] + 4);
    }

    public int copyTo(byte[] byteBuffer, int offset, int dictionaryId) {
        int length = this.offsets[dictionaryId + 1] - (this.offsets[dictionaryId] + 4);
        System.arraycopy(this.pageBuffer, this.offsets[dictionaryId] + 4, byteBuffer, offset, length);
        return length;
    }
}

