/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.parquet.writer.ColumnChunk;
import com.facebook.presto.parquet.writer.ColumnWriter;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterables;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class MapColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapColumnWriter.class).instanceSize();
    private final ColumnWriter keyWriter;
    private final ColumnWriter valueWriter;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public MapColumnWriter(ColumnWriter keyWriter, ColumnWriter valueWriter, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.keyWriter = Objects.requireNonNull(keyWriter, "keyWriter is null");
        this.valueWriter = Objects.requireNonNull(valueWriter, "valueWriter is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)columnChunk.getBlock());
        ImmutableList defLevelIterables = ImmutableList.builder().addAll(columnChunk.getDefinitionLevelIterables()).add((Object)DefinitionLevelIterables.of(columnarMap, this.maxDefinitionLevel)).build();
        ImmutableList repLevelIterables = ImmutableList.builder().addAll(columnChunk.getRepetitionLevelIterables()).add((Object)RepetitionLevelIterables.of(columnarMap, this.maxRepetitionLevel)).build();
        this.keyWriter.writeBlock(new ColumnChunk(columnarMap.getKeysBlock(), (List<DefinitionLevelIterable>)defLevelIterables, (List<RepetitionLevelIterable>)repLevelIterables));
        this.valueWriter.writeBlock(new ColumnChunk(columnarMap.getValuesBlock(), (List<DefinitionLevelIterable>)defLevelIterables, (List<RepetitionLevelIterable>)repLevelIterables));
    }

    @Override
    public void close() {
        this.keyWriter.close();
        this.valueWriter.close();
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        return ImmutableList.builder().addAll(this.keyWriter.getBuffer()).addAll(this.valueWriter.getBuffer()).build();
    }

    @Override
    public long getBufferedBytes() {
        return this.keyWriter.getBufferedBytes() + this.valueWriter.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.keyWriter.getRetainedBytes() + this.valueWriter.getRetainedBytes();
    }

    @Override
    public void reset() {
        this.keyWriter.reset();
        this.valueWriter.reset();
    }
}

