/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.parquet.Preconditions;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetSchemaConverter {
    private Map<List<String>, com.facebook.presto.common.type.Type> primitiveTypes = new HashMap<List<String>, com.facebook.presto.common.type.Type>();
    private final MessageType messageType;

    public ParquetSchemaConverter(List<com.facebook.presto.common.type.Type> types, List<String> columnNames) {
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((types.size() == columnNames.size() ? 1 : 0) != 0, (String)"types size not equals to columnNames size");
        this.messageType = this.convert(types, columnNames);
    }

    private MessageType convert(List<com.facebook.presto.common.type.Type> types, List<String> columnNames) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        for (int i = 0; i < types.size(); ++i) {
            builder.addField(this.convert(types.get(i), columnNames.get(i), (List<String>)ImmutableList.of(), Type.Repetition.OPTIONAL));
        }
        return builder.named("presto_schema");
    }

    private Type convert(com.facebook.presto.common.type.Type type, String name, List<String> parent, Type.Repetition repetition) {
        if ("row".equals(type.getTypeSignature().getBase())) {
            return this.getRowType((RowType)type, name, parent, repetition);
        }
        if ("map".equals(type.getTypeSignature().getBase())) {
            return this.getMapType((MapType)type, name, parent, repetition);
        }
        if ("array".equals(type.getTypeSignature().getBase())) {
            return this.getArrayType((ArrayType)type, name, parent, repetition);
        }
        return this.getPrimitiveType(type, name, parent, repetition);
    }

    private Type getPrimitiveType(com.facebook.presto.common.type.Type type, String name, List<String> parent, Type.Repetition repetition) {
        ImmutableList fullName = ImmutableList.builder().addAll(parent).add((Object)name).build();
        this.primitiveTypes.put((List<String>)fullName, type);
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
        }
        if (IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.getPrecision() <= 9) {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(decimalType.getPrecision())).scale(decimalType.getScale())).named(name);
            }
            if (decimalType.isShort()) {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(decimalType.getPrecision())).scale(decimalType.getScale())).named(name);
            }
            return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(16)).as(OriginalType.DECIMAL)).precision(decimalType.getPrecision())).scale(decimalType.getScale())).named(name);
        }
        if (DateType.DATE.equals((Object)type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(name);
        }
        if (BigintType.BIGINT.equals((Object)type) || TimestampType.TIMESTAMP.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
        }
        if (RealType.REAL.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
        }
        if (type instanceof VarcharType || type instanceof CharType || type instanceof VarbinaryType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported primitive type: %s", type));
    }

    private Type getArrayType(ArrayType type, String name, List<String> parent, Type.Repetition repetition) {
        com.facebook.presto.common.type.Type elementType = type.getElementType();
        return (Type)Types.list((Type.Repetition)repetition).element(this.convert(elementType, "array", (List<String>)ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"list").build(), Type.Repetition.OPTIONAL)).named(name);
    }

    private Type getMapType(MapType type, String name, List<String> parent, Type.Repetition repetition) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"key_value").build();
        com.facebook.presto.common.type.Type keyType = type.getKeyType();
        com.facebook.presto.common.type.Type valueType = type.getValueType();
        return (Type)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(this.convert(keyType, "key", (List<String>)parent, Type.Repetition.REQUIRED))).value(this.convert(valueType, "value", (List<String>)parent, Type.Repetition.OPTIONAL))).named(name);
    }

    private Type getRowType(RowType type, String name, List<String> parent, Type.Repetition repetition) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).build();
        Types.GroupBuilder builder = Types.buildGroup((Type.Repetition)repetition);
        for (RowType.Field field : type.getFields()) {
            com.google.common.base.Preconditions.checkArgument((boolean)field.getName().isPresent(), (Object)"field in struct type doesn't have name");
            builder.addField(this.convert(field.getType(), (String)field.getName().get(), (List<String>)parent, Type.Repetition.OPTIONAL));
        }
        return (Type)builder.named(name);
    }

    public Map<List<String>, com.facebook.presto.common.type.Type> getPrimitiveTypes() {
        return this.primitiveTypes;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }
}

