/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer.valuewriter;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class BooleanValueWriter
extends PrimitiveValueWriter {
    private final ValuesWriter valuesWriter;

    public BooleanValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            boolean value = BooleanType.BOOLEAN.getBoolean(block, i);
            this.valuesWriter.writeBoolean(value);
            this.getStatistics().updateStats(value);
        }
    }
}

