/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.CopyOnFirstWriteConfiguration;
import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class HiveHdfsConfiguration
implements HdfsConfiguration {
    private static final Configuration INITIAL_CONFIGURATION = ConfigurationUtils.getInitialConfiguration();
    private final ThreadLocal<Configuration> hadoopConfiguration = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            Configuration configuration = new Configuration(false);
            ConfigurationUtils.copy(INITIAL_CONFIGURATION, configuration);
            HiveHdfsConfiguration.this.initializer.updateConfiguration(configuration);
            return configuration;
        }
    };
    private final HdfsConfigurationInitializer initializer;
    private final Set<DynamicConfigurationProvider> dynamicProviders;
    private final boolean isConfigReusable;
    private final boolean isCopyOnFirstWriteConfigurationEnabled;
    private Configuration uriAgnosticConfiguration;

    @Inject
    public HiveHdfsConfiguration(HdfsConfigurationInitializer initializer, Set<DynamicConfigurationProvider> dynamicProviders, HiveClientConfig hiveClientConfig) {
        this.initializer = Objects.requireNonNull(initializer, "initializer is null");
        this.dynamicProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(dynamicProviders, "dynamicProviders is null"));
        boolean isUriIndependentConfig = true;
        for (DynamicConfigurationProvider provider : dynamicProviders) {
            isUriIndependentConfig = isUriIndependentConfig && provider.isUriIndependentConfigurationProvider();
        }
        this.isConfigReusable = isUriIndependentConfig;
        this.isCopyOnFirstWriteConfigurationEnabled = hiveClientConfig.isCopyOnFirstWriteConfigurationEnabled();
    }

    public Configuration getConfiguration(HdfsContext context, URI uri) {
        if (this.dynamicProviders.isEmpty()) {
            return this.hadoopConfiguration.get();
        }
        if (this.isCopyOnFirstWriteConfigurationEnabled && this.isConfigReusable && this.uriAgnosticConfiguration != null) {
            return new CopyOnFirstWriteConfiguration(this.uriAgnosticConfiguration);
        }
        Configuration config = new Configuration(this.hadoopConfiguration.get());
        for (DynamicConfigurationProvider provider : this.dynamicProviders) {
            provider.updateConfiguration(config, context, uri);
        }
        if (this.isCopyOnFirstWriteConfigurationEnabled && this.isConfigReusable && this.uriAgnosticConfiguration == null) {
            this.uriAgnosticConfiguration = config;
            return new CopyOnFirstWriteConfiguration(this.uriAgnosticConfiguration);
        }
        return config;
    }
}

