/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class S3SelectPushdown {
    private static final Logger LOG = Logger.get(S3SelectPushdown.class);
    private static final Set<String> SUPPORTED_S3_PREFIXES = ImmutableSet.of((Object)"s3://", (Object)"s3a://", (Object)"s3n://");
    private static final Set<String> SUPPORTED_SERDES = ImmutableSet.of((Object)LazySimpleSerDe.class.getName());
    private static final Set<String> SUPPORTED_INPUT_FORMATS = ImmutableSet.of((Object)TextInputFormat.class.getName());
    private static final Set<String> SUPPORTED_COLUMN_TYPES = ImmutableSet.of((Object)"boolean", (Object)"int", (Object)"tinyint", (Object)"smallint", (Object)"bigint", (Object)"string", (Object[])new String[]{"decimal", "date"});

    private S3SelectPushdown() {
    }

    private static boolean isSerdeSupported(Properties schema) {
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        return SUPPORTED_SERDES.contains(serdeName);
    }

    private static boolean isInputFormatSupported(Properties schema) {
        String inputFormat = HiveUtil.getInputFormatName(schema);
        return SUPPORTED_INPUT_FORMATS.contains(inputFormat);
    }

    public static boolean isCompressionCodecSupported(InputFormat inputFormat, Path path) {
        if (inputFormat instanceof TextInputFormat) {
            return HiveUtil.getCompressionCodec((TextInputFormat)inputFormat, path).map(codec -> codec instanceof GzipCodec || codec instanceof BZip2Codec).orElse(true);
        }
        return false;
    }

    private static boolean areColumnTypesSupported(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return false;
        }
        for (Column column : columns) {
            String type = column.getType().getHiveTypeName().toString();
            if (column.getType().getTypeInfo() instanceof DecimalTypeInfo) {
                type = "decimal";
            }
            if (SUPPORTED_COLUMN_TYPES.contains(type)) continue;
            return false;
        }
        return true;
    }

    private static boolean isS3Storage(String path) {
        return SUPPORTED_S3_PREFIXES.stream().anyMatch(path::startsWith);
    }

    static boolean shouldEnablePushdownForTable(ConnectorSession session, Table table, String path, Optional<Partition> optionalPartition) {
        if (!HiveSessionProperties.isS3SelectPushdownEnabled(session)) {
            return false;
        }
        if (path == null) {
            return false;
        }
        Properties schema = optionalPartition.map(partition -> MetastoreUtil.getHiveSchema((Partition)partition, (Table)table)).orElseGet(() -> MetastoreUtil.getHiveSchema((Table)table));
        return S3SelectPushdown.shouldEnablePushdownForTable(table, path, schema);
    }

    private static boolean shouldEnablePushdownForTable(Table table, String path, Properties schema) {
        return S3SelectPushdown.isS3Storage(path) && S3SelectPushdown.isSerdeSupported(schema) && S3SelectPushdown.isInputFormatSupported(schema) && S3SelectPushdown.areColumnTypesSupported(table.getDataColumns());
    }
}

