/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.gcs;

import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.facebook.presto.hive.HdfsContext;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class GcsConfigurationProvider
implements DynamicConfigurationProvider {
    private static final String GCS_OAUTH_KEY = "hive.gcs.oauth";

    public void updateConfiguration(Configuration configuration, HdfsContext context, URI uri) {
        if (!uri.getScheme().equals("gs")) {
            return;
        }
        String accessToken = (String)context.getIdentity().getExtraCredentials().get(GCS_OAUTH_KEY);
        if (accessToken != null) {
            configuration.set("presto.gcs.oauth-access-token", accessToken);
        }
    }
}

