/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security.ranger;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.security.ranger.ForRangerInfo;
import com.facebook.presto.hive.security.ranger.RangerAuthorizer;
import com.facebook.presto.hive.security.ranger.RangerBasedAccessControlConfig;
import com.facebook.presto.hive.security.ranger.Users;
import com.facebook.presto.hive.security.ranger.VXUser;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerBasedAccessControl
implements ConnectorAccessControl {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonCodec<Users> USER_INFO_CODEC = JsonCodec.jsonCodec(Users.class);
    private static final JsonCodec<List<String>> ROLES_INFO_CODEC = JsonCodec.listJsonCodec(String.class);
    private final RangerAuthorizer rangerAuthorizer;
    private final Supplier<Map<String, Set<String>>> userRolesMapping;
    private final Supplier<Map<String, Set<String>>> userGroupsMapping;
    private final Supplier<ServicePolicies> servicePolicies;
    private final HttpClient httpClient;

    @Inject
    public RangerBasedAccessControl(RangerBasedAccessControlConfig config, @ForRangerInfo HttpClient httpClient) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(config.getRangerHttpEndPoint(), "Ranger service http end point is null");
        Objects.requireNonNull(config.getRangerHiveServiceName(), "Ranger hive service name is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        try {
            this.servicePolicies = Suppliers.memoizeWithExpiration(() -> this.getHiveServicePolicies(config), (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            this.userGroupsMapping = Suppliers.memoizeWithExpiration(() -> this.getUserGroupsMappings(config), (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            this.userRolesMapping = Suppliers.memoizeWithExpiration(() -> this.getRolesForUserList(config), (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            this.rangerAuthorizer = new RangerAuthorizer(this.servicePolicies, config);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to query ranger service ", e);
        }
    }

    private ServicePolicies getHiveServicePolicies(RangerBasedAccessControlConfig config) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create(config.getRangerHttpEndPoint())).appendPath("/service/plugins/policies/download/" + config.getRangerHiveServiceName()).build();
        Request request = RangerBasedAccessControl.setContentTypeHeaders(Request.Builder.prepareGet()).setUri(uri).build();
        try {
            return (ServicePolicies)OBJECT_MAPPER.readValue(((StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler())).getBody(), ServicePolicies.class);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_RANGER_SERVER_ERROR, String.format("Unable to fetch policies from %s hive service end point", config.getRangerHiveServiceName()));
        }
    }

    private Users getUsers(RangerBasedAccessControlConfig config) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create(config.getRangerHttpEndPoint())).appendPath("/service/xusers/users").build();
        Request request = RangerBasedAccessControl.setContentTypeHeaders(Request.Builder.prepareGet()).setUri(uri).build();
        return (Users)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(USER_INFO_CODEC));
    }

    private static Request.Builder setContentTypeHeaders(Request.Builder requestBuilder) {
        return requestBuilder.setHeader("Accept", "application/json");
    }

    private Map<String, Set<String>> getRolesForUserList(RangerBasedAccessControlConfig config) {
        Users users = this.getUsers(config);
        ImmutableMap.Builder userRolesMapping = ImmutableMap.builder();
        for (VXUser vxUser : users.getvXUsers()) {
            userRolesMapping.put((Object)vxUser.getName(), this.getRolesForUser(vxUser.getName(), config));
        }
        return userRolesMapping.build();
    }

    private Set<String> getRolesForUser(String userName, RangerBasedAccessControlConfig config) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create(config.getRangerHttpEndPoint())).appendPath("/service/roles/roles/user/" + userName).build();
        Request request = RangerBasedAccessControl.setContentTypeHeaders(Request.Builder.prepareGet()).setUri(uri).build();
        return ImmutableSet.copyOf((Collection)((Collection)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(ROLES_INFO_CODEC))));
    }

    private Map<String, Set<String>> getUserGroupsMappings(RangerBasedAccessControlConfig config) {
        Users users = this.getUsers(config);
        ImmutableMap.Builder userGroupsMapping = ImmutableMap.builder();
        for (VXUser vxUser : users.getvXUsers()) {
            if (Objects.isNull(vxUser.getGroupNameList()) || vxUser.getGroupNameList().isEmpty()) continue;
            userGroupsMapping.put((Object)vxUser.getName(), (Object)ImmutableSet.copyOf(vxUser.getGroupNameList()));
        }
        return userGroupsMapping.build();
    }

    private Set<String> getGroupsForUser(String username) {
        try {
            return this.userGroupsMapping.get().get(username);
        }
        catch (Exception ex) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_RANGER_SERVER_ERROR, "Unable to fetch user groups information from ranger", (Throwable)ex);
        }
    }

    private Set<String> getRolesForUser(String username) {
        try {
            return this.userRolesMapping.get().get(username);
        }
        catch (Exception ex) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_RANGER_SERVER_ERROR, "Unable to fetch user roles information from ranger", (Throwable)ex);
        }
    }

    private boolean checkAccess(ConnectorIdentity identity, SchemaTableName tableName, String column, HiveAccessType accessType) {
        return this.rangerAuthorizer.authorizeHiveResource(tableName.getSchemaName(), tableName.getTableName(), column, accessType.toString(), identity.getUser(), this.getGroupsForUser(identity.getUser()), this.getRolesForUser(identity.getUser()));
    }

    public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        if (!this.rangerAuthorizer.authorizeHiveResource(schemaName, null, null, HiveAccessType.CREATE.toString(), identity.getUser(), this.getGroupsForUser(identity.getUser()), this.getRolesForUser(identity.getUser()))) {
            AccessDeniedException.denyCreateSchema((String)schemaName, (String)String.format("Access denied - User [ %s ] does not have [CREATE] privilege on [ %s ] ", identity.getUser(), schemaName));
        }
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        if (!this.rangerAuthorizer.authorizeHiveResource(schemaName, null, null, HiveAccessType.DROP.toString(), identity.getUser(), this.getGroupsForUser(identity.getUser()), this.getRolesForUser(identity.getUser()))) {
            AccessDeniedException.denyDropSchema((String)schemaName, (String)String.format("Access denied - User [ %s ] does not have [DROP] privilege on [ %s ] ", identity.getUser(), schemaName));
        }
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context) {
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> schemaNames) {
        HashSet<String> allowedSchemas = new HashSet<String>();
        Set<String> groups = this.getGroupsForUser(identity.getUser());
        Set<String> roles = this.getRolesForUser(identity.getUser());
        for (String schema : schemaNames) {
            if (!this.rangerAuthorizer.authorizeHiveResource(schema, null, null, "_any", identity.getUser(), groups, roles)) continue;
            allowedSchemas.add(schema);
        }
        return allowedSchemas;
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.CREATE)) {
            AccessDeniedException.denyCreateTable((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [CREATE] privilege on [ %s ] ", identity.getUser(), tableName.getSchemaName()));
        }
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<SchemaTableName> tableNames) {
        HashSet<SchemaTableName> allowedTables = new HashSet<SchemaTableName>();
        Set<String> groups = this.getGroupsForUser(identity.getUser());
        Set<String> roles = this.getRolesForUser(identity.getUser());
        for (SchemaTableName table : tableNames) {
            if (!this.rangerAuthorizer.authorizeHiveResource(table.getSchemaName(), table.getTableName(), null, "_any", identity.getUser(), groups, roles)) continue;
            allowedTables.add(table);
        }
        return allowedTables;
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.ALTER)) {
            AccessDeniedException.denyAddColumn((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [ALTER] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.ALTER)) {
            AccessDeniedException.denyDropColumn((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [ALTER] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.ALTER)) {
            AccessDeniedException.denyRenameColumn((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [ALTER] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<Subfield> columnOrSubfieldNames) {
        HashSet<String> deniedColumns = new HashSet<String>();
        for (String column2 : (ImmutableSet)columnOrSubfieldNames.stream().map(column -> column.getRootName()).collect(ImmutableSet.toImmutableSet())) {
            if (this.checkAccess(identity, tableName, column2, HiveAccessType.SELECT)) continue;
            deniedColumns.add(column2);
        }
        if (deniedColumns.size() > 0) {
            AccessDeniedException.denySelectColumns((String)tableName.getTableName(), (Collection)((Collection)columnOrSubfieldNames.stream().map(column -> column.getRootName()).collect(ImmutableSet.toImmutableSet())), (String)String.format("Access denied - User [ %s ] does not have [SELECT] privilege on all mentioned columns of [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.DROP)) {
            AccessDeniedException.denyDropTable((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [DROP] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.ALTER)) {
            AccessDeniedException.denyRenameTable((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [ALTER] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.UPDATE)) {
            AccessDeniedException.denyInsertTable((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [UPDATE] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.UPDATE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [UPDATE] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
    }

    public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        if (!this.checkAccess(identity, viewName, null, HiveAccessType.CREATE)) {
            AccessDeniedException.denyCreateView((String)viewName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [CREATE] privilege on [ %s/%s ] ", identity.getUser(), viewName.getSchemaName(), viewName.getTableName()));
        }
    }

    public void checkCanDropView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        if (!this.checkAccess(identity, viewName, null, HiveAccessType.DROP)) {
            AccessDeniedException.denyDropView((String)viewName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [DROP] privilege on [ %s/%s ] ", identity.getUser(), viewName.getSchemaName(), viewName.getTableName()));
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkAccess(identity, tableName, null, HiveAccessType.CREATE)) {
            AccessDeniedException.denyCreateView((String)tableName.getTableName(), (String)String.format("Access denied - User [ %s ] does not have [CREATE] privilege on [ %s/%s ] ", identity.getUser(), tableName.getSchemaName(), tableName.getTableName()));
        }
        HashSet<String> deniedColumns = new HashSet<String>();
        for (String column : columnNames) {
            if (this.checkAccess(identity, tableName, column, HiveAccessType.SELECT)) continue;
            deniedColumns.add(column);
        }
        if (deniedColumns.size() > 0) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.getTableName(), (ConnectorIdentity)identity);
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String propertyName) {
    }

    static enum HiveAccessType {
        NONE,
        CREATE,
        ALTER,
        DROP,
        INDEX,
        LOCK,
        SELECT,
        UPDATE,
        USE,
        ALL,
        ADMIN;

    }
}

