/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.DefaultPageMetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.QuotaPageMetaStore;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheScope;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.PageNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;

public interface PageMetaStore {
    public static PageMetaStore create(AlluxioConfiguration conf) throws IOException {
        List<PageStoreDir> dirs = PageStoreDir.createPageStoreDirs(conf);
        if (conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_QUOTA_ENABLED)) {
            return new QuotaPageMetaStore(conf, dirs);
        }
        return new DefaultPageMetaStore(dirs);
    }

    public ReadWriteLock getLock();

    public boolean hasPage(PageId var1);

    public void addPage(PageId var1, PageInfo var2);

    public Iterator<PageId> getPagesIterator();

    public List<PageStoreDir> getStoreDirs();

    public PageInfo getPageInfo(PageId var1) throws PageNotFoundException;

    public PageInfo removePage(PageId var1) throws PageNotFoundException;

    public long bytes();

    public long numPages();

    public void reset();

    default public PageInfo evict(PageStoreDir pageStoreDir) {
        return this.evict(CacheScope.GLOBAL, pageStoreDir);
    }

    public PageInfo evict(CacheScope var1, PageStoreDir var2);
}

