/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.LocalPageStoreOptions;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.file.cache.store.QuotaManagedPageStoreDir;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPageStoreDir
extends QuotaManagedPageStoreDir {
    private static final Logger LOG = LoggerFactory.getLogger(LocalPageStoreDir.class);
    private final LocalPageStoreOptions mPageStoreOptions;
    private final int mFileBuckets;
    private final Pattern mPagePattern;
    private PageStore mPageStore;

    public LocalPageStoreDir(LocalPageStoreOptions pageStoreOptions, PageStore pageStore, CacheEvictor evictor) {
        super(pageStoreOptions.getRootDir(), (long)((double)pageStoreOptions.getCacheSize() / (1.0 + pageStoreOptions.getOverheadRatio())), evictor);
        this.mPageStoreOptions = pageStoreOptions;
        this.mPageStore = pageStore;
        this.mFileBuckets = pageStoreOptions.getFileBuckets();
        this.mPagePattern = Pattern.compile(String.format("%s/%d/(\\d+)/([^/]+)/(\\d+)", Pattern.quote(pageStoreOptions.getRootDir().toString()), pageStoreOptions.getPageSize()));
    }

    @Override
    public PageStore getPageStore() {
        return this.mPageStore;
    }

    @Override
    public void reset() throws IOException {
        this.close();
        PageStoreDir.clear(this.getRootPath());
        this.mPageStore = PageStore.create(this.mPageStoreOptions);
    }

    @Override
    public void scanPages(Consumer<Optional<PageInfo>> pageInfoConsumer) throws IOException {
        Files.walk(this.getRootPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::getPageInfo).forEach(pageInfoConsumer);
    }

    private Optional<PageInfo> getPageInfo(Path path) {
        Optional<PageId> pageId = this.getPageId(path);
        if (pageId.isPresent()) {
            long pageSize;
            try {
                pageSize = Files.size(path);
            }
            catch (IOException e) {
                LOG.error("Failed to get file size for " + path, (Throwable)e);
                return Optional.empty();
            }
            return Optional.of(new PageInfo(pageId.get(), pageSize, this));
        }
        return Optional.empty();
    }

    private Optional<PageId> getPageId(Path path) {
        Matcher matcher = this.mPagePattern.matcher(path.toString());
        if (!matcher.matches()) {
            LOG.error("Unrecognized page file " + path);
            return Optional.empty();
        }
        try {
            String fileBucket = Preconditions.checkNotNull(matcher.group(1));
            String fileId = Preconditions.checkNotNull(matcher.group(2));
            if (!fileBucket.equals(PageStoreDir.getFileBucket(this.mFileBuckets, fileId))) {
                LOG.error("Bucket number mismatch " + path);
                return Optional.empty();
            }
            String fileName = Preconditions.checkNotNull(matcher.group(3));
            long pageIndex = Long.parseLong(fileName);
            return Optional.of(new PageId(fileId, pageIndex));
        }
        catch (NumberFormatException e) {
            LOG.error("Illegal numbers in path " + path);
            return Optional.empty();
        }
    }
}

