/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.store.LocalPageStoreOptions;
import alluxio.client.file.cache.store.MemoryPageStoreOptions;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.client.file.cache.store.RocksPageStoreOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.util.FormatUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public abstract class PageStoreOptions {
    protected Path mRootDir;
    protected long mPageSize;
    protected long mCacheSize;
    protected String mAlluxioVersion;
    protected long mTimeoutDuration;
    protected int mTimeoutThreads;
    protected double mOverheadRatio;

    public static List<PageStoreOptions> create(AlluxioConfiguration conf) {
        List<String> dirs = conf.getList(PropertyKey.USER_CLIENT_CACHE_DIRS);
        List<String> cacheSizes = conf.getList(PropertyKey.USER_CLIENT_CACHE_SIZE);
        Preconditions.checkArgument(!dirs.isEmpty(), "Cache dirs is empty");
        Preconditions.checkArgument(!cacheSizes.isEmpty(), "Cache cacheSizes is empty");
        Preconditions.checkArgument(dirs.size() == cacheSizes.size(), "The number of dirs does not match the number of cacheSizes");
        ArrayList<PageStoreOptions> optionsList = new ArrayList<PageStoreOptions>(dirs.size());
        for (int i = 0; i < dirs.size(); ++i) {
            PageStoreOptions options = PageStoreOptions.createPageStoreOptions(conf);
            options.setRootDir(Paths.get(dirs.get(i), options.getType().name())).setCacheSize(FormatUtils.parseSpaceSize(cacheSizes.get(i)));
            optionsList.add(options);
        }
        return optionsList;
    }

    private static PageStoreOptions createPageStoreOptions(AlluxioConfiguration conf) {
        PageStoreOptions options;
        PageStoreType storeType = conf.getEnum(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, PageStoreType.class);
        switch (storeType) {
            case LOCAL: {
                options = new LocalPageStoreOptions().setFileBuckets(conf.getInt(PropertyKey.USER_CLIENT_CACHE_LOCAL_STORE_FILE_BUCKETS));
                break;
            }
            case ROCKS: {
                options = new RocksPageStoreOptions();
                break;
            }
            case MEM: {
                options = new MemoryPageStoreOptions();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized store type %s", storeType.name()));
            }
        }
        options.setPageSize(conf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE)).setAlluxioVersion(conf.getString(PropertyKey.VERSION)).setTimeoutDuration(conf.getMs(PropertyKey.USER_CLIENT_CACHE_TIMEOUT_DURATION)).setTimeoutThreads(conf.getInt(PropertyKey.USER_CLIENT_CACHE_TIMEOUT_THREADS));
        if (conf.isSet(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD)) {
            options.setOverheadRatio(conf.getDouble(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD));
        }
        return options;
    }

    public abstract PageStoreType getType();

    public <T> T toOptions() {
        return (T)this;
    }

    public PageStoreOptions setRootDir(Path rootDir) {
        this.mRootDir = rootDir;
        return this;
    }

    public Path getRootDir() {
        return this.mRootDir;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public PageStoreOptions setPageSize(long pageSize) {
        this.mPageSize = pageSize;
        return this;
    }

    public long getCacheSize() {
        return this.mCacheSize;
    }

    public PageStoreOptions setCacheSize(long cacheSize) {
        this.mCacheSize = cacheSize;
        return this;
    }

    public String getAlluxioVersion() {
        return this.mAlluxioVersion;
    }

    public PageStoreOptions setAlluxioVersion(String alluxioVersion) {
        this.mAlluxioVersion = alluxioVersion;
        return this;
    }

    public long getTimeoutDuration() {
        return this.mTimeoutDuration;
    }

    public PageStoreOptions setTimeoutDuration(long timeout) {
        this.mTimeoutDuration = timeout;
        return this;
    }

    public int getTimeoutThreads() {
        return this.mTimeoutThreads;
    }

    public PageStoreOptions setTimeoutThreads(int threads) {
        this.mTimeoutThreads = threads;
        return this;
    }

    public double getOverheadRatio() {
        return this.mOverheadRatio;
    }

    public PageStoreOptions setOverheadRatio(double overheadRatio) {
        this.mOverheadRatio = overheadRatio;
        return this;
    }
}

