/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.resource.LockResource;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class QuotaManagedPageStoreDir
implements PageStoreDir {
    private final ReentrantReadWriteLock mFileIdSetLock = new ReentrantReadWriteLock();
    @GuardedBy(value="mFileIdSetLock")
    private final Set<String> mFileIdSet = new HashSet<String>();
    private final ReentrantReadWriteLock mTempFileIdSetLock = new ReentrantReadWriteLock();
    @GuardedBy(value="mTempFileIdSetLock")
    private final Set<String> mTempFileIdSet = new HashSet<String>();
    private final Path mRootPath;
    private final long mCapacityBytes;
    private final AtomicLong mBytesUsed = new AtomicLong(0L);
    private final CacheEvictor mEvictor;

    QuotaManagedPageStoreDir(Path rootPath, long capacityBytes, CacheEvictor evictor) {
        this.mRootPath = rootPath;
        this.mCapacityBytes = capacityBytes;
        this.mEvictor = evictor;
    }

    @Override
    public Path getRootPath() {
        return this.mRootPath;
    }

    @Override
    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    @Override
    public long getCachedBytes() {
        return this.mBytesUsed.get();
    }

    @Override
    public boolean putPage(PageInfo pageInfo) {
        this.mEvictor.updateOnPut(pageInfo.getPageId());
        try (LockResource lock = new LockResource(this.mFileIdSetLock.writeLock());){
            this.mFileIdSet.add(pageInfo.getPageId().getFileId());
        }
        this.mBytesUsed.addAndGet(pageInfo.getPageSize());
        return true;
    }

    @Override
    public long deletePage(PageInfo pageInfo) {
        this.mEvictor.updateOnDelete(pageInfo.getPageId());
        return this.mBytesUsed.addAndGet(-pageInfo.getPageSize());
    }

    @Override
    public boolean putTempFile(String fileId) {
        try (LockResource lock = new LockResource(this.mTempFileIdSetLock.writeLock());){
            boolean bl = this.mTempFileIdSet.add(fileId);
            return bl;
        }
    }

    @Override
    public boolean reserve(int bytes) {
        long previousBytesUsed;
        do {
            if ((previousBytesUsed = this.mBytesUsed.get()) + (long)bytes <= this.mCapacityBytes) continue;
            return false;
        } while (!this.mBytesUsed.compareAndSet(previousBytesUsed, previousBytesUsed + (long)bytes));
        return true;
    }

    @Override
    public long release(int bytes) {
        return this.mBytesUsed.addAndGet(-bytes);
    }

    @Override
    public boolean hasFile(String fileId) {
        try (LockResource lock = new LockResource(this.mFileIdSetLock.readLock());){
            boolean bl = this.mFileIdSet.contains(fileId);
            return bl;
        }
    }

    @Override
    public CacheEvictor getEvictor() {
        return this.mEvictor;
    }

    @Override
    public void close() {
        try {
            this.getPageStore().close();
            this.mBytesUsed.set(0L);
        }
        catch (Exception e) {
            throw new RuntimeException("Close page store failed for dir " + this.getRootPath().toString(), e);
        }
    }
}

