/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.grpc.GetServiceVersionPRequest;
import alluxio.grpc.GetServiceVersionPResponse;
import alluxio.grpc.ServiceType;
import alluxio.grpc.ServiceVersionClientServiceGrpc;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public final class ServiceVersionClientServiceHandler
extends ServiceVersionClientServiceGrpc.ServiceVersionClientServiceImplBase {
    private final Set<ServiceType> mServices;

    public ServiceVersionClientServiceHandler(Set<ServiceType> services) {
        this.mServices = ImmutableSet.copyOf((Collection)Objects.requireNonNull(services, "services is null"));
    }

    @Override
    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"})
    public void getServiceVersion(GetServiceVersionPRequest request, StreamObserver<GetServiceVersionPResponse> responseObserver) {
        long serviceVersion;
        ServiceType serviceType = request.getServiceType();
        if (serviceType != ServiceType.UNKNOWN_SERVICE && !this.mServices.contains(serviceType)) {
            responseObserver.onError(Status.NOT_FOUND.withDescription(String.format("Service %s is not found.", serviceType.name())).asException());
            return;
        }
        switch (serviceType) {
            case FILE_SYSTEM_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case FILE_SYSTEM_MASTER_WORKER_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case FILE_SYSTEM_MASTER_JOB_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case BLOCK_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case BLOCK_MASTER_WORKER_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case BLOCK_WORKER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case META_MASTER_CONFIG_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case META_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case META_MASTER_MASTER_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case METRICS_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case JOB_MASTER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case JOB_MASTER_WORKER_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case JOURNAL_MASTER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case TABLE_MASTER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case RAFT_JOURNAL_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            default: {
                serviceVersion = -1L;
            }
        }
        responseObserver.onNext(GetServiceVersionPResponse.newBuilder().setVersion(serviceVersion).build());
        responseObserver.onCompleted();
    }
}

