/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HdfsFileInputStream
extends InputStream
implements Seekable,
PositionedReadable,
ByteBufferReadable {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsFileInputStream.class);
    private final FileSystem.Statistics mStatistics;
    private final FileInStream mInputStream;
    private boolean mClosed = false;

    public HdfsFileInputStream(FileSystem fs, AlluxioURI uri, FileSystem.Statistics stats) throws IOException {
        LOG.debug("HdfsFileInputStream({}, {})", (Object)uri, (Object)stats);
        this.mStatistics = stats;
        try {
            this.mInputStream = fs.openFile(uri);
        }
        catch (FileDoesNotExistException e) {
            throw new FileNotFoundException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(uri));
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    public HdfsFileInputStream(FileInStream inputStream, FileSystem.Statistics stats) {
        this.mInputStream = inputStream;
        this.mStatistics = stats;
    }

    @Override
    public int available() throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot query available bytes from a closed stream.");
        }
        return (int)this.mInputStream.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mInputStream.close();
        this.mClosed = true;
    }

    public long getPos() throws IOException {
        return this.mInputStream.getPos();
    }

    @Override
    public int read() throws IOException {
        if (this.mClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int data = this.mInputStream.read();
        if (data != -1 && this.mStatistics != null) {
            this.mStatistics.incrementBytesRead(1L);
        }
        return data;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.mClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int bytesRead = this.mInputStream.read(buffer, offset, length);
        if (bytesRead != -1 && this.mStatistics != null) {
            this.mStatistics.incrementBytesRead((long)bytesRead);
        }
        return bytesRead;
    }

    public int read(ByteBuffer buf) throws IOException {
        if (this.mClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int bytesRead = this.mInputStream.read(buf);
        if (bytesRead != -1 && this.mStatistics != null) {
            this.mStatistics.incrementBytesRead((long)bytesRead);
        }
        return bytesRead;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (this.mClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int bytesRead = this.mInputStream.positionedRead(position, buffer, offset, length);
        if (bytesRead != -1 && this.mStatistics != null) {
            this.mStatistics.incrementBytesRead((long)bytesRead);
        }
        return bytesRead;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.read(position + (long)totalBytesRead, buffer, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new EOFException();
        }
    }

    public void seek(long pos) throws IOException {
        try {
            this.mInputStream.seek(pos);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new IOException("This method is not supported.");
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot skip bytes in a closed stream.");
        }
        return this.mInputStream.skip(n);
    }
}

