/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.options;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.ModeUtils;

@NotThreadSafe
public final class CreateOptions {
    private boolean mCreateParent = false;
    private boolean mEnsureAtomic = false;
    private String mOwner = null;
    private String mGroup = null;
    private Mode mMode;
    private AccessControlList mAcl = null;

    public static CreateOptions defaults(AlluxioConfiguration conf) {
        return new CreateOptions(conf.getString(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK));
    }

    private CreateOptions(String authUmask) {
        this.mMode = ModeUtils.applyFileUMask(Mode.defaults(), authUmask);
    }

    public AccessControlList getAcl() {
        return this.mAcl;
    }

    public boolean getCreateParent() {
        return this.mCreateParent;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public Mode getMode() {
        return this.mMode;
    }

    public boolean isEnsureAtomic() {
        return this.mEnsureAtomic;
    }

    public CreateOptions setAcl(AccessControlList acl) {
        this.mAcl = acl;
        return this;
    }

    public CreateOptions setCreateParent(boolean createParent) {
        this.mCreateParent = createParent;
        return this;
    }

    public CreateOptions setEnsureAtomic(boolean atomic) {
        this.mEnsureAtomic = atomic;
        return this;
    }

    public CreateOptions setOwner(String owner) {
        this.mOwner = owner;
        return this;
    }

    public CreateOptions setGroup(String group) {
        this.mGroup = group;
        return this;
    }

    public CreateOptions setMode(Mode mode) {
        this.mMode = mode;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOptions)) {
            return false;
        }
        CreateOptions that = (CreateOptions)o;
        return Objects.equal(this.mAcl, that.mAcl) && this.mCreateParent == that.mCreateParent && this.mEnsureAtomic == that.mEnsureAtomic && Objects.equal(this.mOwner, that.mOwner) && Objects.equal(this.mGroup, that.mGroup) && Objects.equal(this.mMode, that.mMode);
    }

    public int hashCode() {
        return Objects.hashCode(this.mAcl, this.mCreateParent, this.mEnsureAtomic, this.mOwner, this.mGroup, this.mMode);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("acl", this.mAcl).add("createParent", this.mCreateParent).add("ensureAtomic", this.mEnsureAtomic).add("owner", this.mOwner).add("group", this.mGroup).add("mode", this.mMode).toString();
    }
}

