/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.DeltaLog;
import io.delta.standalone.OptimisticTransaction;
import io.delta.standalone.VersionLog;
import io.delta.standalone.actions.Action;
import io.delta.standalone.actions.CommitInfo;
import io.delta.standalone.internal.CheckpointInstance;
import io.delta.standalone.internal.CheckpointMetaData;
import io.delta.standalone.internal.Checkpoints;
import io.delta.standalone.internal.DeltaConfigs$;
import io.delta.standalone.internal.DeltaHistoryManager;
import io.delta.standalone.internal.DeltaLogImpl$;
import io.delta.standalone.internal.LogSegment;
import io.delta.standalone.internal.MetadataCleanup;
import io.delta.standalone.internal.OptimisticTransactionImpl;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.SnapshotManagement;
import io.delta.standalone.internal.actions.Action$;
import io.delta.standalone.internal.actions.Metadata;
import io.delta.standalone.internal.actions.Metadata$;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.exception.DeltaErrors;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.sources.StandaloneHadoopConf$;
import io.delta.standalone.internal.storage.LogStoreProvider;
import io.delta.standalone.internal.util.Clock;
import io.delta.standalone.internal.util.ConversionUtils$;
import io.delta.standalone.internal.util.FileNames$;
import io.delta.standalone.internal.util.Implicits$;
import io.delta.standalone.storage.LogStore;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d!\u0002\u0015*\u0001%\n\u0004\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011\r\u0004!\u0011!Q\u0001\n]C\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tY\u0002\u0011\t\u0011)A\u0005M\"AQ\u000e\u0001BC\u0002\u0013\u0005Q\r\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003g\u0011!y\u0007A!b\u0001\n\u0003\u0001\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u000ba\u0004A\u0011B=\t\u0013}\u0004\u0001R1A\u0005\u0002\u0005\u0005\u0001\"C5\u0001\u0011\u000b\u0007I\u0011AA\u0007\u0011\u001d\t)\u0002\u0001C\t\u0003/Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00026\u0001!\t!a\n\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002V!Q\u0011\u0011\u000e\u0001\t\u0006\u0004%\t\"a\u001b\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\ty\n\u0001C!\u0003CCq!!0\u0001\t\u0003\ny\fC\u0004\u0002H\u0002!\t%!3\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bbBA~\u0001\u0011\u0005\u0011Q \u0005\b\u0005\u0013\u0001A\u0011\u0001B\u0006\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003g<\u0001B!\u0005*\u0011\u0003Y#1\u0003\u0004\bQ%B\ta\u000bB\u000b\u0011\u0019A\b\u0005\"\u0001\u0003\u001e!9!q\u0004\u0011\u0005\u0002\t\u0005\u0002b\u0002B\u0010A\u0011\u0005!q\u0005\u0005\b\u0005?\u0001C\u0011\u0001B\u0017\u0011\u001d\u0011y\u0002\tC\u0001\u0005kAqA!\u0010!\t\u0013\u0011y\u0004C\u0005\u0003J\u0001\n\n\u0011\"\u0003\u0003L\taA)\u001a7uC2{w-S7qY*\u0011!fK\u0001\tS:$XM\u001d8bY*\u0011A&L\u0001\u000bgR\fg\u000eZ1m_:,'B\u0001\u00180\u0003\u0015!W\r\u001c;b\u0015\u0005\u0001\u0014AA5p'!\u0001!G\u000f C\u000b.s\u0005CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005mbT\"A\u0016\n\u0005uZ#\u0001\u0003#fYR\fGj\\4\u0011\u0005}\u0002U\"A\u0015\n\u0005\u0005K#aC\"iK\u000e\\\u0007o\\5oiN\u0004\"aP\"\n\u0005\u0011K#aD'fi\u0006$\u0017\r^1DY\u0016\fg.\u001e9\u0011\u0005\u0019KU\"A$\u000b\u0005!K\u0013aB:u_J\fw-Z\u0005\u0003\u0015\u001e\u0013\u0001\u0003T8h'R|'/\u001a)s_ZLG-\u001a:\u0011\u0005}b\u0015BA'*\u0005I\u0019f.\u00199tQ>$X*\u00198bO\u0016lWM\u001c;\u0011\u0005=\u0013V\"\u0001)\u000b\u0005EK\u0013a\u00027pO\u001eLgnZ\u0005\u0003'B\u0013q\u0001T8hO&tw-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u001c\u0001!F\u0001X!\tA\u0016-D\u0001Z\u0015\tQ6,\u0001\u0003d_:4'B\u0001/^\u0003\u0019A\u0017\rZ8pa*\u0011alX\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\f1a\u001c:h\u0013\t\u0011\u0017LA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\fQ\u0006$wn\u001c9D_:4\u0007%A\u0004m_\u001e\u0004\u0016\r\u001e5\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!![.\u0002\u0005\u0019\u001c\u0018BA6i\u0005\u0011\u0001\u0016\r\u001e5\u0002\u00111|w\rU1uQ\u0002\n\u0001\u0002Z1uCB\u000bG\u000f[\u0001\nI\u0006$\u0018\rU1uQ\u0002\nQa\u00197pG.,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i&\nA!\u001e;jY&\u0011ao\u001d\u0002\u0006\u00072|7m[\u0001\u0007G2|7m\u001b\u0011\u0002\rqJg.\u001b;?)\u0015Q8\u0010`?\u007f!\ty\u0004\u0001C\u0003U\u0013\u0001\u0007q\u000bC\u0003e\u0013\u0001\u0007a\rC\u0003n\u0013\u0001\u0007a\rC\u0003p\u0013\u0001\u0007\u0011/A\u0003ti>\u0014X-\u0006\u0002\u0002\u0004A!\u0011QAA\u0005\u001b\t\t9A\u0003\u0002IW%!\u00111BA\u0004\u0005!aunZ*u_J,WCAA\b!\r9\u0017\u0011C\u0005\u0004\u0003'A'A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006AQ.\u001a;bI\u0006$\u0018-\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 %\nq!Y2uS>t7/\u0003\u0003\u0002$\u0005u!\u0001C'fi\u0006$\u0017\r^1\u00021Q|WNY:u_:,'+\u001a;f]RLwN\\'jY2L7/\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiC\u0003\u0002\u00020\u0005)1oY1mC&!\u00111GA\u0017\u0005\u0011auN\\4\u000235LgNR5mKJ+G/\u001a8uS>tG+[7fgR\fW\u000e]\u0001\bi\u0006\u0014G.Z%e+\t\tY\u0004\u0005\u0003\u0002>\u0005-c\u0002BA \u0003\u000f\u0002B!!\u0011\u0002.5\u0011\u00111\t\u0006\u0004\u0003\u000b*\u0016A\u0002\u001fs_>$h(\u0003\u0003\u0002J\u00055\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002N\u0005=#AB*ue&twM\u0003\u0003\u0002J\u00055\u0012\u0001\u00043fYR\fGj\\4M_\u000e\\WCAA+!\u0011\t9&a\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\nQ\u0001\\8dWNTA!a\u0018\u0002b\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Q4\u0014\u0002BA3\u00033\u0012QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00043fYR\fGj\\4M_\u000e\\\u0007%A\u0004iSN$xN]=\u0016\u0005\u00055\u0004cA \u0002p%\u0019\u0011\u0011O\u0015\u0003'\u0011+G\u000e^1ISN$xN]=NC:\fw-\u001a:\u0002%\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\\u000b\u0003\u0003o\u0002B!a\u000b\u0002z%!\u00111PA\u0017\u0005\rIe\u000e^\u0001\ti&lWM_8oKV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000b))\u0004\u0002\u0002b%!\u0011qQA1\u0005!!\u0016.\\3[_:,\u0017aB4fiB\u000bG\u000f\u001b\u000b\u0002M\u0006yq-\u001a;D_6l\u0017\u000e^%oM>\fE\u000f\u0006\u0003\u0002\u0012\u0006m\u0005\u0003BAJ\u0003/k!!!&\u000b\u0007\u0005}1&\u0003\u0003\u0002\u001a\u0006U%AC\"p[6LG/\u00138g_\"9\u0011Q\u0014\fA\u0002\u0005%\u0012a\u0002<feNLwN\\\u0001\u000bO\u0016$8\t[1oO\u0016\u001cHCBAR\u0003_\u000b\u0019\f\u0005\u0004\u0002\u0004\u0006\u0015\u0016\u0011V\u0005\u0005\u0003O\u000b\tG\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\rY\u00141V\u0005\u0004\u0003[[#A\u0003,feNLwN\u001c'pO\"9\u0011\u0011W\fA\u0002\u0005%\u0012\u0001D:uCJ$h+\u001a:tS>t\u0007bBA[/\u0001\u0007\u0011qW\u0001\u000fM\u0006LGn\u00148ECR\fGj\\:t!\u0011\tY#!/\n\t\u0005m\u0016Q\u0006\u0002\b\u0005>|G.Z1o\u0003A\u0019H/\u0019:u)J\fgn]1di&|g\u000e\u0006\u0002\u0002BB\u00191(a1\n\u0007\u0005\u00157FA\u000bPaRLW.[:uS\u000e$&/\u00198tC\u000e$\u0018n\u001c8\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0003\u0003o\u000b\u0011\u0003\\8dW&sG/\u001a:skB$\u0018N\u00197z+\u0011\ty-!6\u0015\t\u0005E\u0017q\u001d\t\u0005\u0003'\f)\u000e\u0004\u0001\u0005\u000f\u0005]'D1\u0001\u0002Z\n\tA+\u0005\u0003\u0002\\\u0006\u0005\b\u0003BA\u0016\u0003;LA!a8\u0002.\t9aj\u001c;iS:<\u0007\u0003BA\u0016\u0003GLA!!:\u0002.\t\u0019\u0011I\\=\t\u0011\u0005%(\u0004\"a\u0001\u0003W\fAAY8esB1\u00111FAw\u0003#LA!a<\u0002.\tAAHY=oC6,g(A\ff]N,(/\u001a'pO\u0012K'/Z2u_JLX\t_5tiR\u0011\u0011Q\u001f\t\u0005\u0003W\t90\u0003\u0003\u0002z\u00065\"\u0001B+oSR\f!#Y:tKJ$\bK]8u_\u000e|GNU3bIR!\u0011Q_A\u0000\u0011\u001d\u0011\t\u0001\ba\u0001\u0005\u0007\t\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0005\u00037\u0011)!\u0003\u0003\u0003\b\u0005u!\u0001\u0003)s_R|7m\u001c7\u0002'\u0005\u001c8/\u001a:u!J|Go\\2pY^\u0013\u0018\u000e^3\u0015\t\u0005U(Q\u0002\u0005\b\u0005\u0003i\u0002\u0019\u0001B\u0002\u0003=\t7o]3siJ+Wn\u001c<bE2,\u0017\u0001\u0004#fYR\fGj\\4J[Bd\u0007CA !'\r\u0001#q\u0003\t\u0005\u0003W\u0011I\"\u0003\u0003\u0003\u001c\u00055\"AB!osJ+g\r\u0006\u0002\u0003\u0014\u0005Aam\u001c:UC\ndW\rF\u0003{\u0005G\u0011)\u0003C\u0003UE\u0001\u0007q\u000b\u0003\u0004nE\u0001\u0007\u00111\b\u000b\u0006u\n%\"1\u0006\u0005\u0006)\u000e\u0002\ra\u0016\u0005\u0006[\u000e\u0002\rA\u001a\u000b\bu\n=\"\u0011\u0007B\u001a\u0011\u0015!F\u00051\u0001X\u0011\u0019iG\u00051\u0001\u0002<!)q\u000e\na\u0001cR9!Pa\u000e\u0003:\tm\u0002\"\u0002+&\u0001\u00049\u0006\"B7&\u0001\u00041\u0007\"B8&\u0001\u0004\t\u0018!B1qa2LHc\u0002>\u0003B\t\r#q\t\u0005\u0006)\u001a\u0002\ra\u0016\u0005\u0007\u0005\u000b2\u0003\u0019\u00014\u0002\u000fI\fw\u000fU1uQ\"9qN\nI\u0001\u0002\u0004\t\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t5#fA9\u0003P-\u0012!\u0011\u000b\t\u0005\u0005'\u0012i&\u0004\u0002\u0003V)!!q\u000bB-\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003\\\u00055\u0012AC1o]>$\u0018\r^5p]&!!q\fB+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DeltaLogImpl
implements DeltaLog,
Checkpoints,
MetadataCleanup,
LogStoreProvider,
SnapshotManagement,
Logging {
    private LogStore store;
    private FileSystem fs;
    private DeltaHistoryManager history;
    private final Configuration hadoopConf;
    private final Path logPath;
    private final Path dataPath;
    private final Clock clock;
    private final ReentrantLock deltaLogLock;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;
    private volatile SnapshotImpl currentSnapshot;
    private final String defaultLogStoreClassName;
    private final Path LAST_CHECKPOINT;
    private volatile byte bitmap$0;

    public static DeltaLogImpl forTable(Configuration configuration, Path path, Clock clock) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, path, clock);
    }

    public static DeltaLogImpl forTable(Configuration configuration, String string, Clock clock) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, string, clock);
    }

    public static DeltaLogImpl forTable(Configuration configuration, Path path) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, path);
    }

    public static DeltaLogImpl forTable(Configuration configuration, String string) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, string);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public SnapshotImpl snapshot() {
        return SnapshotManagement.snapshot$(this);
    }

    @Override
    public SnapshotImpl update() {
        return SnapshotManagement.update$(this);
    }

    @Override
    public SnapshotImpl getSnapshotForVersionAsOf(long version) {
        return SnapshotManagement.getSnapshotForVersionAsOf$(this, version);
    }

    @Override
    public SnapshotImpl getSnapshotForTimestampAsOf(long timestamp) {
        return SnapshotManagement.getSnapshotForTimestampAsOf$(this, timestamp);
    }

    @Override
    public LogSegment getLogSegmentForVersion(Option<Object> startCheckpoint, Option<Object> versionToLoad) {
        return SnapshotManagement.getLogSegmentForVersion$(this, startCheckpoint, versionToLoad);
    }

    @Override
    public Option<Object> getLogSegmentForVersion$default$2() {
        return SnapshotManagement.getLogSegmentForVersion$default$2$(this);
    }

    @Override
    public LogStore createLogStore(Configuration hadoopConf) {
        return LogStoreProvider.createLogStore$(this, hadoopConf);
    }

    @Override
    public boolean enableExpiredLogCleanup() {
        return MetadataCleanup.enableExpiredLogCleanup$(this);
    }

    @Override
    public long deltaRetentionMillis() {
        return MetadataCleanup.deltaRetentionMillis$(this);
    }

    @Override
    public void doLogCleanup() {
        MetadataCleanup.doLogCleanup$(this);
    }

    @Override
    public void cleanUpExpiredLogs() {
        MetadataCleanup.cleanUpExpiredLogs$(this);
    }

    @Override
    public Option<CheckpointMetaData> lastCheckpoint() {
        return Checkpoints.lastCheckpoint$(this);
    }

    @Override
    public void checkpoint() {
        Checkpoints.checkpoint$(this);
    }

    @Override
    public void checkpoint(SnapshotImpl snapshotToCheckpoint) {
        Checkpoints.checkpoint$(this, snapshotToCheckpoint);
    }

    @Override
    public Option<CheckpointInstance> findLastCompleteCheckpoint(CheckpointInstance cv) {
        return Checkpoints.findLastCompleteCheckpoint$(this, cv);
    }

    @Override
    public Option<CheckpointInstance> getLatestCompleteCheckpointFromList(CheckpointInstance[] instances, CheckpointInstance notLaterThan) {
        return Checkpoints.getLatestCompleteCheckpointFromList$(this, instances, notLaterThan);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    @Override
    public SnapshotImpl currentSnapshot() {
        return this.currentSnapshot;
    }

    @Override
    public void currentSnapshot_$eq(SnapshotImpl x$1) {
        this.currentSnapshot = x$1;
    }

    @Override
    public String defaultLogStoreClassName() {
        return this.defaultLogStoreClassName;
    }

    @Override
    public void io$delta$standalone$internal$storage$LogStoreProvider$_setter_$defaultLogStoreClassName_$eq(String x$1) {
        this.defaultLogStoreClassName = x$1;
    }

    @Override
    public Path LAST_CHECKPOINT() {
        return this.LAST_CHECKPOINT;
    }

    @Override
    public void io$delta$standalone$internal$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(Path x$1) {
        this.LAST_CHECKPOINT = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public Path logPath() {
        return this.logPath;
    }

    public Path dataPath() {
        return this.dataPath;
    }

    public Clock clock() {
        return this.clock;
    }

    private LogStore store$lzycompute() {
        DeltaLogImpl deltaLogImpl = this;
        synchronized (deltaLogImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.store = this.createLogStore(this.hadoopConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.store;
    }

    public LogStore store() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.store$lzycompute() : this.store;
    }

    private FileSystem fs$lzycompute() {
        DeltaLogImpl deltaLogImpl = this;
        synchronized (deltaLogImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.fs = this.logPath().getFileSystem(this.hadoopConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.fs;
    }

    public FileSystem fs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.fs$lzycompute() : this.fs;
    }

    public Metadata metadata() {
        return this.snapshot() == null ? new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8()) : this.snapshot().metadataScala();
    }

    public long tombstoneRetentionMillis() {
        return DeltaConfigs$.MODULE$.getMilliSeconds(DeltaConfigs$.MODULE$.TOMBSTONE_RETENTION().fromMetadata(this.metadata()));
    }

    public long minFileRetentionTimestamp() {
        return this.clock().getTimeMillis() - this.tombstoneRetentionMillis();
    }

    public String tableId() {
        return this.metadata().id();
    }

    private ReentrantLock deltaLogLock() {
        return this.deltaLogLock;
    }

    private DeltaHistoryManager history$lzycompute() {
        DeltaLogImpl deltaLogImpl = this;
        synchronized (deltaLogImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.history = new DeltaHistoryManager(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.history;
    }

    public DeltaHistoryManager history() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.history$lzycompute() : this.history;
    }

    public int checkpointInterval() {
        return BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.CHECKPOINT_INTERVAL().fromMetadata(this.metadata()));
    }

    public TimeZone timezone() {
        return this.hadoopConf().get(StandaloneHadoopConf$.MODULE$.PARQUET_DATA_TIME_ZONE_ID()) == null ? TimeZone.getDefault() : TimeZone.getTimeZone(this.hadoopConf().get(StandaloneHadoopConf$.MODULE$.PARQUET_DATA_TIME_ZONE_ID()));
    }

    @Override
    public Path getPath() {
        return this.dataPath();
    }

    @Override
    public CommitInfo getCommitInfoAt(long version) {
        this.history().checkVersionExists(version);
        return ConversionUtils$.MODULE$.convertCommitInfo(this.history().getCommitInfo(version));
    }

    @Override
    public java.util.Iterator<VersionLog> getChanges(long startVersion, boolean failOnDataLoss) {
        if (startVersion < 0L) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Invalid startVersion: ").append(startVersion).toString());
        }
        Iterator deltaPaths = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.store().listFrom(FileNames$.MODULE$.deltaFile(this.logPath(), startVersion), this.hadoopConf())).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileNames$.MODULE$.isDeltaFile(f.getPath())));
        LongRef lastSeenVersion = LongRef.create((long)(startVersion - 1L));
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(deltaPaths.map((Function1 & Serializable & scala.Serializable)status -> {
            Path p = status.getPath();
            long version = FileNames$.MODULE$.deltaVersion(p);
            if (failOnDataLoss && version > lastSeenVersion$1.elem + 1L) {
                throw DeltaErrors$.MODULE$.failOnDataLossException(lastSeenVersion$1.elem + 1L, version);
            }
            lastSeenVersion$1.elem = version;
            return new VersionLog(version, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Implicits$.MODULE$.CloseableIteratorOps(this.store().read(p, this.hadoopConf()), ClassTag$.MODULE$.apply(String.class)).toArray())).map((Function1 & Serializable & scala.Serializable)x -> ConversionUtils$.MODULE$.convertAction(Action$.MODULE$.fromJson((String)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Action.class))))).toList()).asJava());
        })).asJava();
    }

    @Override
    public OptimisticTransaction startTransaction() {
        this.update();
        return new OptimisticTransactionImpl(this, this.snapshot());
    }

    @Override
    public boolean tableExists() {
        return this.snapshot().version() >= 0L;
    }

    public <T> T lockInterruptibly(Function0<T> body) {
        Object object;
        this.deltaLogLock().lockInterruptibly();
        try {
            object = body.apply();
        }
        finally {
            this.deltaLogLock().unlock();
        }
        return (T)object;
    }

    public void ensureLogDirectoryExist() {
        if (!this.fs().exists(this.logPath()) && !this.fs().mkdirs(this.logPath())) {
            throw new IOException(new StringBuilder(14).append("Cannot create ").append(this.logPath()).toString());
        }
    }

    public void assertProtocolRead(Protocol protocol) {
        if (protocol != null && Action$.MODULE$.readerVersion() < protocol.minReaderVersion()) {
            throw new DeltaErrors.InvalidProtocolVersionException(Action$.MODULE$.protocolVersion(), protocol);
        }
    }

    public void assertProtocolWrite(Protocol protocol) {
        if (protocol != null && Action$.MODULE$.writerVersion() < protocol.minWriterVersion()) {
            throw new DeltaErrors.InvalidProtocolVersionException(Action$.MODULE$.protocolVersion(), protocol);
        }
    }

    public void assertRemovable() {
        if (BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.IS_APPEND_ONLY().fromMetadata(this.metadata()))) {
            throw DeltaErrors$.MODULE$.modifyAppendOnlyTableException();
        }
    }

    public DeltaLogImpl(Configuration hadoopConf, Path logPath, Path dataPath, Clock clock) {
        this.hadoopConf = hadoopConf;
        this.logPath = logPath;
        this.dataPath = dataPath;
        this.clock = clock;
        Checkpoints.$init$(this);
        MetadataCleanup.$init$(this);
        LogStoreProvider.$init$(this);
        SnapshotManagement.$init$(this);
        Logging.$init$(this);
        this.deltaLogLock = new ReentrantLock();
    }
}

