/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import io.delta.standalone.internal.util.ParquetSchemaConverter$;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import io.delta.standalone.types.TimestampType;
import io.delta.standalone.util.ParquetSchemaConverter;
import java.io.Serializable;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4Q\u0001C\u0005\u0001\u001bMA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\t?\u0001\u0011\t\u0011)A\u0005A!)1\u0007\u0001C\u0001i!)\u0011\b\u0001C\u0001u!)a\n\u0001C\u0005\u001f\")a\n\u0001C\u00051\")1\r\u0001C\u0005I\ni2\u000b]1sWR{\u0007+\u0019:rk\u0016$8k\u00195f[\u0006\u001cuN\u001c<feR,'O\u0003\u0002\u000b\u0017\u0005!Q\u000f^5m\u0015\taQ\"\u0001\u0005j]R,'O\\1m\u0015\tqq\"\u0001\u0006ti\u0006tG-\u00197p]\u0016T!\u0001E\t\u0002\u000b\u0011,G\u000e^1\u000b\u0003I\t!![8\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR\u001c\u0001\u0001\u0005\u0002\u0016;%\u0011aD\u0006\u0002\b\u0005>|G.Z1o\u0003MyW\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9f!\t\t\u0003G\u0004\u0002#[9\u00111\u0005\f\b\u0003I-r!!\n\u0016\u000f\u0005\u0019JS\"A\u0014\u000b\u0005!Z\u0012A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t\u0001\u0012#\u0003\u0002\u000f\u001f%\u0011!\"D\u0005\u0003]=\na\u0003U1scV,GoU2iK6\f7i\u001c8wKJ$XM\u001d\u0006\u0003\u00155I!!\r\u001a\u00035A\u000b'/];fi>+H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3\u000b\u00059z\u0013A\u0002\u001fj]&$h\bF\u00026oa\u0002\"A\u000e\u0001\u000e\u0003%AQAG\u0002A\u0002qAQaH\u0002A\u0002\u0001\nqaY8om\u0016\u0014H\u000f\u0006\u0002<\u000fB\u0011A(R\u0007\u0002{)\u0011ahP\u0001\u0007g\u000eDW-\\1\u000b\u0005\u0001\u000b\u0015a\u00029beF,X\r\u001e\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G{\tYQ*Z:tC\u001e,G+\u001f9f\u0011\u0015qD\u00011\u0001I!\tIE*D\u0001K\u0015\tYU\"A\u0003usB,7/\u0003\u0002N\u0015\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019\r|gN^3si\u001aKW\r\u001c3\u0015\u0005A\u001b\u0006C\u0001\u001fR\u0013\t\u0011VH\u0001\u0003UsB,\u0007\"\u0002+\u0006\u0001\u0004)\u0016!\u00024jK2$\u0007CA%W\u0013\t9&JA\u0006TiJ,8\r\u001e$jK2$Gc\u0001)Z5\")AK\u0002a\u0001+\")1L\u0002a\u00019\u0006Q!/\u001a9fi&$\u0018n\u001c8\u0011\u0005u\u0003gB\u0001\u001f_\u0013\tyV(\u0001\u0003UsB,\u0017BA1c\u0005)\u0011V\r]3uSRLwN\u001c\u0006\u0003?v\n1dY8naV$X-T5o\u0005f$Xm\u001d$peB\u0013XmY5tS>tGCA3i!\t)b-\u0003\u0002h-\t\u0019\u0011J\u001c;\t\u000b%<\u0001\u0019A3\u0002\u0013A\u0014XmY5tS>t\u0007")
public class SparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final ParquetSchemaConverter.ParquetOutputTimestampType outputTimestampType;

    public MessageType convert(StructType schema) {
        return (MessageType)Types.buildMessage().addFields((Type[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.getFields())).map((Function1 & Serializable & scala.Serializable)field -> this.convertField((StructField)field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Type.class)))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    private Type convertField(StructField field) {
        return this.convertField(field, field.isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type convertField(StructField field2, Type.Repetition repetition) {
        ParquetSchemaConverter$.MODULE$.checkFieldName(field2.getName());
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        DataType dataType = field2.getDataType();
        if (dataType instanceof BooleanType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.getName());
        }
        if (dataType instanceof ByteType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8).named(field2.getName());
        }
        if (dataType instanceof ShortType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16).named(field2.getName());
        }
        if (dataType instanceof IntegerType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.getName());
        }
        if (dataType instanceof LongType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.getName());
        }
        if (dataType instanceof FloatType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.getName());
        }
        if (dataType instanceof DoubleType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.getName());
        }
        if (dataType instanceof StringType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8).named(field2.getName());
        }
        if (dataType instanceof DateType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE).named(field2.getName());
        }
        if (dataType instanceof TimestampType) {
            Type type;
            ParquetSchemaConverter.ParquetOutputTimestampType parquetOutputTimestampType = this.outputTimestampType;
            if (((Object)((Object)ParquetSchemaConverter.ParquetOutputTimestampType.INT96)).equals((Object)parquetOutputTimestampType)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.getName());
                return type;
            } else if (((Object)((Object)ParquetSchemaConverter.ParquetOutputTimestampType.TIMESTAMP_MICROS)).equals((Object)parquetOutputTimestampType)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MICROS).named(field2.getName());
                return type;
            } else {
                if (!((Object)((Object)ParquetSchemaConverter.ParquetOutputTimestampType.TIMESTAMP_MILLIS)).equals((Object)parquetOutputTimestampType)) throw new MatchError((Object)parquetOutputTimestampType);
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MILLIS).named(field2.getName());
            }
            return type;
        }
        if (dataType instanceof BinaryType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.getName());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            if (this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(decimalType.getPrecision()).scale(decimalType.getScale()).length(this.computeMinBytesForPrecision(decimalType.getPrecision())).named(field2.getName());
            }
        }
        if (bl && decimalType.getPrecision() <= 9 && !this.writeLegacyParquetFormat) {
            return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(decimalType.getPrecision()).scale(decimalType.getScale()).named(field2.getName());
        }
        if (bl && decimalType.getPrecision() <= 18 && !this.writeLegacyParquetFormat) {
            return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(decimalType.getPrecision()).scale(decimalType.getScale()).named(field2.getName());
        }
        if (bl && !this.writeLegacyParquetFormat) {
            return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(decimalType.getPrecision()).scale(decimalType.getScale()).length(this.computeMinBytesForPrecision(decimalType.getPrecision())).named(field2.getName());
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            if (arrayType.containsNull() && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", arrayType.getElementType(), arrayType.containsNull()))).named("bag")).named(field2.getName());
            }
        }
        if (bl2 && !arrayType.containsNull() && this.writeLegacyParquetFormat) {
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField(this.convertField(new StructField("array", arrayType.getElementType(), arrayType.containsNull()), Type.Repetition.REPEATED)).named(field2.getName());
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.getName(), (String)"key_value", (Type)this.convertField(new StructField("key", mapType.getKeyType(), false)), (Type)this.convertField(new StructField("value", mapType.getValueType(), mapType.valueContainsNull())));
            }
        }
        if (bl2 && !this.writeLegacyParquetFormat) {
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", arrayType.getElementType(), arrayType.containsNull()))).named("list")).named(field2.getName());
        }
        if (bl3 && !this.writeLegacyParquetFormat) {
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.MAP)).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", mapType.getKeyType(), false))).addField(this.convertField(new StructField("value", mapType.getValueType(), mapType.valueContainsNull()))).named("key_value")).named(field2.getName());
        }
        if (!(dataType instanceof StructType)) throw new UnsupportedOperationException(new StringBuilder(22).append("Unsupported data type ").append(field2.getDataType().getTypeName()).toString());
        StructType structType = (StructType)dataType;
        return (Type)((Types.Builder)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.getFields())).foldLeft((Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable & scala.Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field)))).named(field2.getName());
    }

    /*
     * WARNING - void declaration
     */
    private int computeMinBytesForPrecision(int precision) {
        void var2_2;
        int numBytes = 1;
        while (package$.MODULE$.pow(2.0, (double)(8 * numBytes - 1)) < package$.MODULE$.pow(10.0, (double)precision)) {
            ++numBytes;
        }
        return (int)var2_2;
    }

    public SparkToParquetSchemaConverter(boolean writeLegacyParquetFormat, ParquetSchemaConverter.ParquetOutputTimestampType outputTimestampType) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
    }
}

