/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.com.codahale.metrics.jvm;

import com.facebook.presto.hive.$internal.com.codahale.metrics.Gauge;
import com.facebook.presto.hive.$internal.com.codahale.metrics.Metric;
import com.facebook.presto.hive.$internal.com.codahale.metrics.MetricRegistry;
import com.facebook.presto.hive.$internal.com.codahale.metrics.MetricSet;
import com.facebook.presto.hive.$internal.com.codahale.metrics.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ThreadStatesGaugeSet
implements MetricSet {
    private static final int STACK_TRACE_DEPTH = 0;
    private final ThreadMXBean threads;
    private final ThreadDeadlockDetector deadlockDetector;

    public ThreadStatesGaugeSet() {
        this(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector());
    }

    public ThreadStatesGaugeSet(ThreadMXBean threads, ThreadDeadlockDetector deadlockDetector) {
        this.threads = threads;
        this.deadlockDetector = deadlockDetector;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Object>> gauges = new HashMap<String, Gauge<Object>>();
        for (final Thread.State state : Thread.State.values()) {
            gauges.put(MetricRegistry.name(state.toString().toLowerCase(), "count"), new Gauge<Object>(){

                @Override
                public Object getValue() {
                    return ThreadStatesGaugeSet.this.getThreadCount(state);
                }
            });
        }
        gauges.put("count", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return ThreadStatesGaugeSet.this.threads.getThreadCount();
            }
        });
        gauges.put("daemon.count", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return ThreadStatesGaugeSet.this.threads.getDaemonThreadCount();
            }
        });
        gauges.put("deadlock.count", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return ThreadStatesGaugeSet.this.deadlockDetector.getDeadlockedThreads().size();
            }
        });
        gauges.put("deadlocks", new Gauge<Set<String>>(){

            @Override
            public Set<String> getValue() {
                return ThreadStatesGaugeSet.this.deadlockDetector.getDeadlockedThreads();
            }
        });
        return Collections.unmodifiableMap(gauges);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.getThreadInfo();
        int count = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }

    ThreadInfo[] getThreadInfo() {
        return this.threads.getThreadInfo(this.threads.getAllThreadIds(), 0);
    }
}

