/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.facebook.presto.hive.$internal.com.codahale.metrics.MetricRegistry;
import com.github.joshelser.dropwizard.metrics.hadoop.HadoopMetrics2Reporter;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleReporter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

public class Metrics2Reporter
implements CodahaleReporter {
    private final MetricRegistry metricRegistry;
    private final HiveConf conf;
    private final HadoopMetrics2Reporter reporter;

    public Metrics2Reporter(MetricRegistry registry, HiveConf conf) {
        this.metricRegistry = registry;
        this.conf = conf;
        String applicationName = conf.get(HiveConf.ConfVars.HIVE_METRICS_HADOOP2_COMPONENT_NAME.varname);
        this.reporter = HadoopMetrics2Reporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(DefaultMetricsSystem.initialize((String)applicationName), applicationName, applicationName, "General");
    }

    @Override
    public void start() {
        long reportingInterval = HiveConf.toTime(this.conf.get(HiveConf.ConfVars.HIVE_METRICS_HADOOP2_INTERVAL.varname), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.reporter.start(reportingInterval, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        this.reporter.close();
    }
}

