/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.com.codahale.metrics.MetricFilter;
import com.facebook.presto.hive.$internal.com.codahale.metrics.MetricRegistry;
import com.facebook.presto.hive.$internal.com.codahale.metrics.ScheduledReporter;
import com.facebook.presto.hive.$internal.com.codahale.metrics.json.MetricsModule;
import com.facebook.presto.hive.$internal.com.fasterxml.jackson.core.JsonProcessingException;
import com.facebook.presto.hive.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import com.facebook.presto.hive.$internal.com.fasterxml.jackson.databind.ObjectWriter;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public class JsonReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonReporter.class);
    private static final FileAttribute<Set<PosixFilePermission>> FILE_ATTRS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
    private static final FileAttribute<Set<PosixFilePermission>> DIR_ATTRS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));
    private final MetricRegistry registry;
    private ObjectWriter jsonWriter;
    private final Path path;
    private final Path metricsDir;

    private JsonReporter(MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Configuration conf) {
        super(registry, name, filter, rateUnit, durationUnit);
        String pathString = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION);
        this.path = Paths.get(pathString, new String[0]).toAbsolutePath();
        LOG.info("Reporting metrics to {}", (Object)this.path);
        this.metricsDir = this.path.getParent();
        this.registry = registry;
    }

    @Override
    public void start(long period, TimeUnit unit) {
        if (!this.metricsDir.toFile().exists()) {
            LOG.warn("Metrics directory {} does not exist, creating one", (Object)this.metricsDir);
            try {
                Files.createDirectories(this.metricsDir, DIR_ATTRS);
            }
            catch (IOException e) {
                LOG.warn("Failed to initialize JSON reporter: failed to create directory {}: {}", (Object)this.metricsDir, (Object)e.getMessage());
                return;
            }
        }
        this.jsonWriter = new ObjectMapper().registerModule(new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false)).writerWithDefaultPrettyPrinter();
        super.start(period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(SortedMap<String, .Gauge> sortedMap, SortedMap<String, .Counter> sortedMap1, SortedMap<String, .Histogram> sortedMap2, SortedMap<String, .Meter> sortedMap3, SortedMap<String, .Timer> sortedMap4) {
        String json;
        try {
            json = this.jsonWriter.writeValueAsString(this.registry);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to convert json to string ", e);
            return;
        }
        Path tmpFile = null;
        try {
            tmpFile = Files.createTempFile(this.metricsDir, "hmsmetrics", "json", FILE_ATTRS);
        }
        catch (IOException e) {
            LOG.error("failed to create temp file for JSON metrics", e);
            return;
        }
        catch (SecurityException e) {
            LOG.error("failed to create temp file for JSON metrics: no permissions", e);
            return;
        }
        catch (UnsupportedOperationException e) {
            LOG.error("failed to create temp file for JSON metrics: operartion not supported", e);
            return;
        }
        try {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile.toFile()));){
                bw.write(json);
            }
            catch (IOException e) {
                LOG.error("Unable to write to temp file {}" + tmpFile, e);
                if (tmpFile.toFile().exists()) {
                    try {
                        Files.delete(tmpFile);
                    }
                    catch (Exception e2) {
                        LOG.error("failed to delete temporary metrics file " + tmpFile, e2);
                    }
                }
                return;
            }
            try {
                Files.move(tmpFile, this.path, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Exception e) {
                LOG.error("Unable to rename temp file {} to {}", (Object)tmpFile, (Object)this.path);
                LOG.error("Exception during rename", e);
            }
        }
        finally {
            if (tmpFile.toFile().exists()) {
                try {
                    Files.delete(tmpFile);
                }
                catch (Exception e) {
                    LOG.error("failed to delete temporary metrics file " + tmpFile, e);
                }
            }
        }
    }

    public static Builder forRegistry(MetricRegistry registry, Configuration conf) {
        return new Builder(registry, conf);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private final Configuration conf;
        private TimeUnit rate = TimeUnit.SECONDS;
        private TimeUnit duration = TimeUnit.MILLISECONDS;
        private MetricFilter filter = MetricFilter.ALL;

        private Builder(MetricRegistry registry, Configuration conf) {
            this.registry = registry;
            this.conf = conf;
        }

        public Builder convertRatesTo(TimeUnit rate) {
            this.rate = rate;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit duration) {
            this.duration = duration;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public JsonReporter build() {
            return new JsonReporter(this.registry, "json-reporter", this.filter, this.rate, this.duration, this.conf);
        }
    }
}

