/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.SelfDescribingInputFormatInterface;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;

public class VectorizedOrcInputFormat
extends FileInputFormat<NullWritable, VectorizedRowBatch>
implements InputFormatChecker,
VectorizedInputFormatInterface,
SelfDescribingInputFormatInterface {
    public VectorizedOrcInputFormat() {
        this.setMinSplitSize(16384L);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        FileSplit fSplit = (FileSplit)inputSplit;
        reporter.setStatus(fSplit.toString());
        Path path = fSplit.getPath();
        OrcFile.ReaderOptions opts = OrcFile.readerOptions((Configuration)conf);
        if (fSplit instanceof OrcSplit) {
            OrcSplit orcSplit = (OrcSplit)fSplit;
            if (orcSplit.hasFooter()) {
                opts.orcTail(orcSplit.getOrcTail());
            }
            opts.maxLength(orcSplit.getFileLength());
        }
        Reader reader = OrcFile.createReader(path, opts);
        return new VectorizedOrcRecordReader(reader, (Configuration)conf, fSplit);
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            try {
                OrcFile.createReader(file.getPath(), OrcFile.readerOptions(conf).filesystem(fs));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    static class VectorizedOrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private float progress = 0.0f;
        private VectorizedRowBatchCtx rbCtx;
        private final Object[] partitionValues;
        private boolean addPartitionCols = true;

        VectorizedOrcRecordReader(Reader file, Configuration conf, FileSplit fileSplit) throws IOException {
            boolean isAcidRead = AcidUtils.isFullAcidScan(conf);
            if (isAcidRead) {
                OrcInputFormat.raiseAcidTablesMustBeReadWithAcidReaderException(conf);
            }
            this.rbCtx = Utilities.getVectorizedRowBatchCtx(conf);
            int dataColumns = this.rbCtx.getDataColumnCount();
            TypeDescription schema = OrcInputFormat.getDesiredRowTypeDescr(conf, false, dataColumns);
            if (schema == null && (schema = file.getSchema()).getCategory() == TypeDescription.Category.STRUCT && schema.getChildren().size() > dataColumns) {
                schema = schema.clone();
                List<TypeDescription> children = schema.getChildren();
                for (int c = children.size() - 1; c >= dataColumns; --c) {
                    children.remove(c);
                }
            }
            List<OrcProto.Type> types = OrcUtils.getOrcTypes(schema);
            Reader.Options options = new Reader.Options().schema(schema);
            this.offset = fileSplit.getStart();
            this.length = fileSplit.getLength();
            options.range(this.offset, this.length);
            options.include(OrcInputFormat.genIncludedColumns(schema, conf));
            OrcInputFormat.setSearchArgument(options, types, conf, true);
            this.reader = file.rowsOptions(options);
            int partitionColumnCount = this.rbCtx.getPartitionColumnCount();
            if (partitionColumnCount > 0) {
                this.partitionValues = new Object[partitionColumnCount];
                VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, conf, fileSplit, this.partitionValues);
            } else {
                this.partitionValues = null;
            }
        }

        public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
            try {
                if (this.addPartitionCols) {
                    if (this.partitionValues != null) {
                        this.rbCtx.addPartitionColsToBatch(value, this.partitionValues);
                    }
                    this.addPartitionCols = false;
                }
                if (!this.reader.nextBatch(value)) {
                    return false;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.progress = this.reader.getProgress();
            return true;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public VectorizedRowBatch createValue() {
            return this.rbCtx.createVectorizedRowBatch();
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }
    }
}

