/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableList;
import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlanStatus;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.ColumnStatsUpdateTask;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.parse.AnalyzeCommandUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationParseUtils;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactory;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactoryImpl;
import org.apache.hadoop.hive.ql.plan.AbortTxnsDesc;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterMaterializedViewDesc;
import org.apache.hadoop.hive.ql.plan.AlterResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableAlterPartDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableExchangePartition;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.AlterWMTriggerDesc;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.CacheMetadataDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateOrAlterWMMappingDesc;
import org.apache.hadoop.hive.ql.plan.CreateOrAlterWMPoolDesc;
import org.apache.hadoop.hive.ql.plan.CreateOrDropTriggerToPoolMappingDesc;
import org.apache.hadoop.hive.ql.plan.CreateResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.CreateWMTriggerDesc;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.DropWMMappingDesc;
import org.apache.hadoop.hive.ql.plan.DropWMPoolDesc;
import org.apache.hadoop.hive.ql.plan.DropWMTriggerDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.KillQueryDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.plan.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowConfDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTblPropertiesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTxnsDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.util.StringUtils;

public class DDLSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(DDLSemanticAnalyzer.class);
    private static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    private final Set<String> reservedPartitionValues = new HashSet<String>();
    private final HiveAuthorizationTaskFactory hiveAuthorizationTaskFactory;
    private WriteEntity alterTableOutput;
    private DDLDesc.DDLDescWithWriteId ddlDescWithWriteId;

    public static String getTypeName(ASTNode node) throws SemanticException {
        String typeName;
        int token = node.getType();
        if (token == 801) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        switch (token) {
            case 774: {
                CharTypeInfo charTypeInfo = ParseUtils.getCharTypeInfo(node);
                typeName = charTypeInfo.getQualifiedName();
                break;
            }
            case 1100: {
                VarcharTypeInfo varcharTypeInfo = ParseUtils.getVarcharTypeInfo(node);
                typeName = varcharTypeInfo.getQualifiedName();
                break;
            }
            case 1073: {
                HiveConf conf;
                try {
                    conf = Hive.get().getConf();
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                TimestampLocalTZTypeInfo timestampLocalTZTypeInfo = TypeInfoFactory.getTimestampTZTypeInfo(conf.getLocalTimeZone());
                typeName = timestampLocalTZTypeInfo.getQualifiedName();
                break;
            }
            case 805: {
                DecimalTypeInfo decTypeInfo = ParseUtils.getDecimalTypeTypeInfo(node);
                typeName = decTypeInfo.getQualifiedName();
                break;
            }
            default: {
                typeName = TokenToTypeName.get(token);
            }
        }
        return typeName;
    }

    public DDLSemanticAnalyzer(QueryState queryState) throws SemanticException {
        this(queryState, DDLSemanticAnalyzer.createHiveDB(queryState.getConf()));
    }

    public DDLSemanticAnalyzer(QueryState queryState, Hive db) throws SemanticException {
        super(queryState, db);
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
        this.hiveAuthorizationTaskFactory = this.createAuthorizationTaskFactory(this.conf, db);
    }

    @Override
    public void analyzeInternal(ASTNode input) throws SemanticException {
        ASTNode ast = input;
        switch (ast.getType()) {
            case 721: {
                ast = (ASTNode)input.getChild(1);
                String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)input.getChild(0));
                String catName = MetaStoreUtils.getDefaultCatalog(this.conf);
                String tableName = DDLSemanticAnalyzer.getDotName(qualified);
                HashMap<String, String> partSpec = null;
                ASTNode partSpecNode = (ASTNode)input.getChild(2);
                if (partSpecNode != null) {
                    partSpec = ast.getType() == 742 ? DDLSemanticAnalyzer.getPartSpec(partSpecNode) : DDLSemanticAnalyzer.getValidatedPartSpec(this.getTable(tableName), partSpecNode, this.conf, false);
                }
                if (ast.getType() == 740) {
                    this.analyzeAlterTableRename(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 748) {
                    this.analyzeAlterTableTouch(qualified, ast);
                    break;
                }
                if (ast.getType() == 725) {
                    this.analyzeAlterTableArchive(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 749) {
                    this.analyzeAlterTableArchive(qualified, ast, true);
                    break;
                }
                if (ast.getType() == 722) {
                    this.analyzeAlterTableModifyCols(qualified, ast, partSpec, AlterTableDesc.AlterTableTypes.ADDCOLS);
                    break;
                }
                if (ast.getType() == 743) {
                    this.analyzeAlterTableModifyCols(qualified, ast, partSpec, AlterTableDesc.AlterTableTypes.REPLACECOLS);
                    break;
                }
                if (ast.getType() == 741) {
                    this.analyzeAlterTableRenameCol(catName, qualified, ast, partSpec);
                    break;
                }
                if (ast.getType() == 724) {
                    this.analyzeAlterTableAddParts(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 731) {
                    this.analyzeAlterTableDropParts(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 738) {
                    this.analyzeAlterTablePartColType(qualified, ast);
                    break;
                }
                if (ast.getType() == 739) {
                    this.analyzeAlterTableProps(qualified, null, ast, false, false);
                    break;
                }
                if (ast.getType() == 732) {
                    this.analyzeAlterTableProps(qualified, null, ast, false, true);
                    break;
                }
                if (ast.getType() == 752) {
                    this.analyzeAlterTableProps(qualified, partSpec, ast, false, false);
                    break;
                }
                if (ast.getType() == 746) {
                    this.analyzeAltertableSkewedby(qualified, ast);
                    break;
                }
                if (ast.getType() == 733) {
                    this.analyzeExchangePartition(qualified, ast);
                    break;
                }
                if (ast.getToken().getType() == 734) {
                    this.analyzeAlterTableFileFormat(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 735) {
                    this.analyzeAlterTableLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 736) {
                    this.analyzeAlterTablePartMergeFiles(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 745) {
                    this.analyzeAlterTableSerde(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 744) {
                    this.analyzeAlterTableSerdeProps(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 742) {
                    this.analyzeAlterTableRenamePart(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 747) {
                    this.analyzeAlterTableSkewedLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 726) {
                    this.analyzeAlterTableBucketNum(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 728) {
                    this.analyzeAlterTableClusterSort(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 729) {
                    this.analyzeAlterTableCompact(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 750) {
                    this.analyzeAlterTableUpdateStats(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 730) {
                    this.analyzeAlterTableDropConstraint(ast, tableName);
                    break;
                }
                if (ast.getToken().getType() == 723) {
                    this.analyzeAlterTableAddConstraint(ast, tableName);
                    break;
                }
                if (ast.getToken().getType() == 751) {
                    this.analyzeAlterTableUpdateColumns(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() != 737) break;
                this.analyzeAlterTableOwner(ast, tableName);
                break;
            }
            case 823: {
                this.analyzeDropTable(ast, null);
                break;
            }
            case 1081: {
                this.analyzeTruncateTable(ast);
                break;
            }
            case 812: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeDescribeTable(ast);
                break;
            }
            case 998: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowDatabases(ast);
                break;
            }
            case 1004: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTables(ast);
                break;
            }
            case 996: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowColumns(ast);
                break;
            }
            case 1015: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTableStatus(ast);
                break;
            }
            case 1016: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTableProperties(ast);
                break;
            }
            case 1000: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowFunctions(ast);
                break;
            }
            case 1001: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowLocks(ast);
                break;
            }
            case 999: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowDbLocks(ast);
                break;
            }
            case 1006: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowCompactions(ast);
                break;
            }
            case 1017: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTxns(ast);
                break;
            }
            case 711: {
                this.analyzeAbortTxns(ast);
                break;
            }
            case 881: {
                this.analyzeKillQuery(ast);
                break;
            }
            case 997: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowConf(ast);
                break;
            }
            case 1005: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowViews(ast);
                break;
            }
            case 1002: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowMaterializedViews(ast);
                break;
            }
            case 811: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeDescFunction(ast);
                break;
            }
            case 810: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeDescDatabase(ast);
                break;
            }
            case 898: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeMetastoreCheck(ast);
                break;
            }
            case 824: {
                this.analyzeDropTable(ast, TableType.VIRTUAL_VIEW);
                break;
            }
            case 826: {
                this.analyzeDropTable(ast, TableType.MATERIALIZED_VIEW);
                break;
            }
            case 753: {
                String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
                ast = (ASTNode)ast.getChild(1);
                if (ast.getType() == 757) {
                    this.analyzeAlterTableProps(qualified, null, ast, true, false);
                    break;
                }
                if (ast.getType() == 756) {
                    this.analyzeAlterTableProps(qualified, null, ast, true, true);
                    break;
                }
                if (ast.getType() == 754) {
                    this.analyzeAlterTableAddParts(qualified, ast, true);
                    break;
                }
                if (ast.getType() == 755) {
                    this.analyzeAlterTableDropParts(qualified, ast, true);
                    break;
                }
                if (ast.getType() != 758) break;
                this.analyzeAlterTableRename(qualified, ast, true);
                break;
            }
            case 760: {
                ast = (ASTNode)input.getChild(1);
                String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)input.getChild(0));
                String tableName = DDLSemanticAnalyzer.getDotName(qualified);
                if (ast.getType() != 762) break;
                this.analyzeAlterMaterializedViewRewrite(tableName, ast);
                break;
            }
            case 1003: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowPartitions(ast);
                break;
            }
            case 1007: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowCreateDatabase(ast);
                break;
            }
            case 1008: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowCreateTable(ast);
                break;
            }
            case 893: {
                this.analyzeLockTable(ast);
                break;
            }
            case 1091: {
                this.analyzeUnlockTable(ast);
                break;
            }
            case 892: {
                this.analyzeLockDatabase(ast);
                break;
            }
            case 1090: {
                this.analyzeUnlockDatabase(ast);
                break;
            }
            case 782: {
                this.analyzeCreateDatabase(ast);
                break;
            }
            case 819: {
                this.analyzeDropDatabase(ast);
                break;
            }
            case 1035: {
                this.analyzeSwitchDatabase(ast);
                break;
            }
            case 720: {
                this.analyzeAlterDatabaseProperties(ast);
                break;
            }
            case 719: {
                this.analyzeAlterDatabaseOwner(ast);
                break;
            }
            case 718: {
                this.analyzeAlterDatabaseLocation(ast);
                break;
            }
            case 785: {
                this.analyzeCreateRole(ast);
                break;
            }
            case 822: {
                this.analyzeDropRole(ast);
                break;
            }
            case 1011: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowRoleGrant(ast);
                break;
            }
            case 1012: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowRolePrincipals(ast);
                break;
            }
            case 1010: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowRoles(ast);
                break;
            }
            case 850: {
                this.analyzeGrantRevokeRole(true, ast);
                break;
            }
            case 977: {
                this.analyzeGrantRevokeRole(false, ast);
                break;
            }
            case 848: {
                this.analyzeGrant(ast);
                break;
            }
            case 1009: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowGrant(ast);
                break;
            }
            case 976: {
                this.analyzeRevoke(ast);
                break;
            }
            case 1014: {
                this.analyzeSetShowRole(ast);
                break;
            }
            case 772: {
                this.analyzeCacheMetadata(ast);
                break;
            }
            case 791: {
                this.analyzeCreateResourcePlan(ast);
                break;
            }
            case 1013: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowResourcePlan(ast);
                break;
            }
            case 764: {
                this.analyzeAlterResourcePlan(ast);
                break;
            }
            case 828: {
                this.analyzeDropResourcePlan(ast);
                break;
            }
            case 792: {
                this.analyzeCreateTrigger(ast);
                break;
            }
            case 765: {
                this.analyzeAlterTrigger(ast);
                break;
            }
            case 829: {
                this.analyzeDropTrigger(ast);
                break;
            }
            case 790: {
                this.analyzeCreatePool(ast);
                break;
            }
            case 763: {
                this.analyzeAlterPool(ast);
                break;
            }
            case 827: {
                this.analyzeDropPool(ast);
                break;
            }
            case 788: {
                this.analyzeCreateOrAlterMapping(ast, false);
                break;
            }
            case 759: {
                this.analyzeCreateOrAlterMapping(ast, true);
                break;
            }
            case 825: {
                this.analyzeDropMapping(ast);
                break;
            }
            default: {
                throw new SemanticException("Unsupported command: " + ast);
            }
        }
        if (this.fetchTask != null && !this.rootTasks.isEmpty()) {
            ((Task)this.rootTasks.get(this.rootTasks.size() - 1)).setFetchSource(true);
        }
    }

    private void analyzeCacheMetadata(ASTNode ast) throws SemanticException {
        CacheMetadataDesc desc;
        Table tbl = AnalyzeCommandUtils.getTable(ast, this);
        Map<String, String> partSpec = null;
        if (AnalyzeCommandUtils.isPartitionLevelStats(ast)) {
            partSpec = AnalyzeCommandUtils.getPartKeyValuePairsFromAST(tbl, ast, this.conf);
            Partition part = this.getPartition(tbl, partSpec, true);
            desc = new CacheMetadataDesc(tbl.getDbName(), tbl.getTableName(), part.getName());
            this.inputs.add(new ReadEntity(part));
        } else {
            desc = new CacheMetadataDesc(tbl.getDbName(), tbl.getTableName(), tbl.isPartitioned());
            this.inputs.add(new ReadEntity(tbl));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeAlterTableUpdateStats(ASTNode ast, String tblName, Map<String, String> partSpec) throws SemanticException {
        String colName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        Table tbl = this.getTable(tblName);
        String partName = null;
        if (partSpec != null) {
            try {
                partName = Warehouse.makePartName(partSpec, false);
            }
            catch (MetaException e) {
                throw new SemanticException("partition " + partSpec.toString() + " not found");
            }
        }
        String colType = null;
        List<FieldSchema> cols = tbl.getCols();
        for (FieldSchema col : cols) {
            if (!colName.equalsIgnoreCase(col.getName())) continue;
            colType = col.getType();
            break;
        }
        if (colType == null) {
            throw new SemanticException("column type not found");
        }
        ColumnStatsUpdateWork columnStatsUpdateWork = new ColumnStatsUpdateWork(partName, mapProp, tbl.getDbName(), tbl.getTableName(), colName, colType);
        ColumnStatsUpdateTask cStatsUpdateTask = (ColumnStatsUpdateTask)TaskFactory.get(columnStatsUpdateWork);
        this.rootTasks.add(cStatsUpdateTask);
    }

    private void analyzeSetShowRole(ASTNode ast) throws SemanticException {
        switch (ast.getChildCount()) {
            case 0: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.rootTasks.add(this.hiveAuthorizationTaskFactory.createShowCurrentRoleTask(this.getInputs(), this.getOutputs(), this.ctx.getResFile()));
                this.setFetchTask(this.createFetchTask(RoleDDLDesc.getRoleNameSchema()));
                break;
            }
            case 1: {
                this.rootTasks.add(this.hiveAuthorizationTaskFactory.createSetRoleTask(BaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()), this.getInputs(), this.getOutputs()));
                break;
            }
            default: {
                throw new SemanticException("Internal error. ASTNode expected to have 0 or 1 child. " + ast.dump());
            }
        }
    }

    private void analyzeGrantRevokeRole(boolean grant, ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = grant ? this.hiveAuthorizationTaskFactory.createGrantRoleTask(ast, this.getInputs(), this.getOutputs()) : this.hiveAuthorizationTaskFactory.createRevokeRoleTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeShowGrant(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createShowGrantTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
            this.setFetchTask(this.createFetchTask(ShowGrantDesc.getSchema()));
        }
    }

    private void analyzeGrant(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createGrantTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeRevoke(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createRevokeTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeCreateRole(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createCreateRoleTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeDropRole(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createDropRoleTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeShowRoleGrant(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createShowRoleGrantTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
            this.setFetchTask(this.createFetchTask(RoleDDLDesc.getRoleShowGrantSchema()));
        }
    }

    private void analyzeShowRolePrincipals(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> roleDDLTask = this.hiveAuthorizationTaskFactory.createShowRolePrincipalsTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (roleDDLTask != null) {
            this.rootTasks.add(roleDDLTask);
            this.setFetchTask(this.createFetchTask(RoleDDLDesc.getShowRolePrincipalsSchema()));
        }
    }

    private void analyzeShowRoles(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> roleDDLTask = this.hiveAuthorizationTaskFactory.createShowRolesTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (roleDDLTask != null) {
            this.rootTasks.add(roleDDLTask);
            this.setFetchTask(this.createFetchTask(RoleDDLDesc.getRoleNameSchema()));
        }
    }

    private void analyzeAlterDatabaseProperties(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> dbProps = null;
        block3: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 798: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block3;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, dbProps, null);
        this.addAlterDbDesc(alterDesc);
    }

    private void addAlterDbDesc(AlterDatabaseDesc alterDesc) throws SemanticException {
        Database database = this.getDatabase(alterDesc.getDatabaseName());
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterDesc)));
    }

    private void analyzeAlterDatabaseOwner(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        PrincipalDesc principalDesc = AuthorizationParseUtils.getPrincipalDesc((ASTNode)ast.getChild(1));
        String nullCmdMsg = "can't be null in alter database set owner command";
        if (principalDesc.getName() == null) {
            throw new SemanticException("Owner name " + nullCmdMsg);
        }
        if (principalDesc.getType() == null) {
            throw new SemanticException("Owner type " + nullCmdMsg);
        }
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, principalDesc, null);
        this.addAlterDbDesc(alterDesc);
    }

    private void analyzeAlterDatabaseLocation(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String newLocation = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        this.addLocationToOutputs(newLocation);
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, newLocation);
        this.addAlterDbDesc(alterDesc);
    }

    private void analyzeExchangePartition(String[] qualified, ASTNode ast) throws SemanticException {
        Table destTable = this.getTable(qualified);
        Table sourceTable = this.getTable(DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1)));
        HashMap<String, String> partSpecs = DDLSemanticAnalyzer.getValidatedPartSpec(sourceTable, (ASTNode)ast.getChild(0), this.conf, false);
        this.validatePartitionValues(partSpecs);
        boolean sameColumns = MetaStoreUtils.compareFieldColumns(destTable.getAllCols(), sourceTable.getAllCols());
        boolean samePartitions = MetaStoreUtils.compareFieldColumns(destTable.getPartitionKeys(), sourceTable.getPartitionKeys());
        if (!sameColumns || !samePartitions) {
            throw new SemanticException(ErrorMsg.TABLES_INCOMPATIBLE_SCHEMAS.getMsg());
        }
        if (AcidUtils.isTransactionalTable(sourceTable) || AcidUtils.isTransactionalTable(destTable)) {
            throw new SemanticException(ErrorMsg.EXCHANGE_PARTITION_NOT_ALLOWED_WITH_TRANSACTIONAL_TABLES.getMsg());
        }
        this.getPartitions(sourceTable, partSpecs, true);
        int counter = this.isPartitionValueContinuous(sourceTable.getPartitionKeys(), partSpecs);
        if (counter < 0) {
            throw new SemanticException(ErrorMsg.PARTITION_VALUE_NOT_CONTINUOUS.getMsg(((Object)partSpecs).toString()));
        }
        List<Partition> destPartitions = null;
        try {
            destPartitions = this.getPartitions(destTable, partSpecs, true);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        if (destPartitions != null) {
            throw new SemanticException(ErrorMsg.PARTITION_EXISTS.getMsg(destPartitions.toString()));
        }
        AlterTableExchangePartition alterTableExchangePartition = new AlterTableExchangePartition(sourceTable, destTable, partSpecs);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTableExchangePartition)));
        this.inputs.add(new ReadEntity(sourceTable));
        this.outputs.add(new WriteEntity(destTable, WriteEntity.WriteType.DDL_SHARED));
    }

    private int isPartitionValueContinuous(List<FieldSchema> partitionKeys, Map<String, String> partSpecs) {
        int counter = 0;
        for (FieldSchema partitionKey : partitionKeys) {
            if (partSpecs.containsKey(partitionKey.getName())) {
                ++counter;
                continue;
            }
            return partSpecs.size() == counter ? counter : -1;
        }
        return counter;
    }

    private void analyzeCreateResourcePlan(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() == 0) {
            throw new SemanticException("Expected name in CREATE RESOURCE PLAN statement");
        }
        String resourcePlanName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        Integer queryParallelism = null;
        String likeName = null;
        block4: for (int i = 1; i < ast.getChildCount(); ++i) {
            Tree child = ast.getChild(i);
            switch (child.getType()) {
                case 958: {
                    if (queryParallelism == null && likeName == null) {
                        queryParallelism = Integer.parseInt(child.getChild(0).getText());
                        continue block4;
                    }
                    throw new SemanticException("Conflicting create arguments " + ast.toStringTree());
                }
                case 887: {
                    if (queryParallelism == null && likeName == null) {
                        likeName = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                        continue block4;
                    }
                    throw new SemanticException("Conflicting create arguments " + ast.toStringTree());
                }
                default: {
                    throw new SemanticException("Invalid create arguments " + ast.toStringTree());
                }
            }
        }
        CreateResourcePlanDesc desc = new CreateResourcePlanDesc(resourcePlanName, queryParallelism, likeName);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeShowResourcePlan(ASTNode ast) throws SemanticException {
        String rpName = null;
        if (ast.getChildCount() > 0) {
            rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        }
        if (ast.getChildCount() > 1) {
            throw new SemanticException("Invalid syntax for SHOW RESOURCE PLAN statement");
        }
        ShowResourcePlanDesc showResourcePlanDesc = new ShowResourcePlanDesc(rpName, this.ctx.getResFile());
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showResourcePlanDesc)));
        this.setFetchTask(this.createFetchTask(showResourcePlanDesc.getSchema(rpName)));
    }

    private void analyzeAlterResourcePlan(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() < 1) {
            throw new SemanticException("Incorrect syntax");
        }
        Tree nameOrGlobal = ast.getChild(0);
        switch (nameOrGlobal.getType()) {
            case 830: {
                throw new SemanticException("Activate a resource plan to enable workload management");
            }
            case 816: {
                WMNullableResourcePlan anyRp = new WMNullableResourcePlan();
                anyRp.setStatus(WMResourcePlanStatus.ENABLED);
                AlterResourcePlanDesc desc = new AlterResourcePlanDesc(anyRp, null, false, false, true, false);
                this.addServiceOutput();
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
                return;
            }
        }
        if (ast.getChildCount() < 2) {
            throw new SemanticException("Invalid syntax for ALTER RESOURCE PLAN statement");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        WMNullableResourcePlan resourcePlan = new WMNullableResourcePlan();
        boolean isEnableActivate = false;
        boolean isReplace = false;
        boolean validate = false;
        block14: for (int i = 1; i < ast.getChildCount(); ++i) {
            Tree child = ast.getChild(i);
            switch (child.getType()) {
                case 1099: {
                    validate = true;
                    continue block14;
                }
                case 712: {
                    if (resourcePlan.getStatus() == WMResourcePlanStatus.ENABLED) {
                        isEnableActivate = true;
                    }
                    if (child.getChildCount() > 1) {
                        throw new SemanticException("Expected 0 or 1 arguments " + ast.toStringTree());
                    }
                    if (child.getChildCount() == 1) {
                        if (child.getChild(0).getType() != 965) {
                            throw new SemanticException("Incorrect syntax " + ast.toStringTree());
                        }
                        isReplace = true;
                        isEnableActivate = false;
                    }
                    resourcePlan.setStatus(WMResourcePlanStatus.ACTIVE);
                    continue block14;
                }
                case 830: {
                    if (resourcePlan.getStatus() == WMResourcePlanStatus.ACTIVE) {
                        isEnableActivate = !isReplace;
                        continue block14;
                    }
                    resourcePlan.setStatus(WMResourcePlanStatus.ENABLED);
                    continue block14;
                }
                case 816: {
                    resourcePlan.setStatus(WMResourcePlanStatus.DISABLED);
                    continue block14;
                }
                case 965: {
                    isReplace = true;
                    if (child.getChildCount() > 1) {
                        throw new SemanticException("Expected 0 or 1 arguments " + ast.toStringTree());
                    }
                    if (child.getChildCount() == 1) {
                        resourcePlan.setName(DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()));
                        continue block14;
                    }
                    resourcePlan.setStatus(WMResourcePlanStatus.ACTIVE);
                    continue block14;
                }
                case 958: {
                    if (child.getChildCount() != 1) {
                        throw new SemanticException("Expected one argument");
                    }
                    Tree val = child.getChild(0);
                    resourcePlan.setIsSetQueryParallelism(true);
                    if (val.getType() == 906) {
                        resourcePlan.unsetQueryParallelism();
                        continue block14;
                    }
                    resourcePlan.setQueryParallelism(Integer.parseInt(val.getText()));
                    continue block14;
                }
                case 806: {
                    if (child.getChildCount() != 1) {
                        throw new SemanticException("Expected one argument");
                    }
                    Tree val = child.getChild(0);
                    resourcePlan.setIsSetDefaultPoolPath(true);
                    if (val.getType() == 906) {
                        resourcePlan.unsetDefaultPoolPath();
                        continue block14;
                    }
                    resourcePlan.setDefaultPoolPath(this.poolPath(child.getChild(0)));
                    continue block14;
                }
                case 964: {
                    if (child.getChildCount() != 1) {
                        throw new SemanticException("Expected one argument");
                    }
                    resourcePlan.setName(DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()));
                    continue block14;
                }
                default: {
                    throw new SemanticException("Unexpected token in alter resource plan statement: " + child.getType());
                }
            }
        }
        AlterResourcePlanDesc desc = new AlterResourcePlanDesc(resourcePlan, rpName, validate, isEnableActivate, false, isReplace);
        if (validate) {
            this.ctx.setResFile(this.ctx.getLocalTmpPath());
            desc.setResFile(this.ctx.getResFile().toString());
        }
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        if (validate) {
            this.setFetchTask(this.createFetchTask(AlterResourcePlanDesc.getSchema()));
        }
    }

    private void analyzeDropResourcePlan(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() == 0) {
            throw new SemanticException("Expected name in DROP RESOURCE PLAN statement");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        DropResourcePlanDesc desc = new DropResourcePlanDesc(rpName);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeCreateTrigger(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() != 4) {
            throw new SemanticException("Invalid syntax for create trigger statement");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String triggerName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        String triggerExpression = this.buildTriggerExpression((ASTNode)ast.getChild(2));
        String actionExpression = this.buildTriggerActionExpression((ASTNode)ast.getChild(3));
        WMTrigger trigger = new WMTrigger(rpName, triggerName);
        trigger.setTriggerExpression(triggerExpression);
        trigger.setActionExpression(actionExpression);
        CreateWMTriggerDesc desc = new CreateWMTriggerDesc(trigger);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private String buildTriggerExpression(ASTNode ast) throws SemanticException {
        if (ast.getType() != 1079 || ast.getChildCount() == 0) {
            throw new SemanticException("Invalid trigger expression.");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ast.getChildCount(); ++i) {
            builder.append(ast.getChild(i).getText());
            builder.append(' ');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private String poolPath(Tree ast) {
        StringBuilder builder = new StringBuilder();
        builder.append(DDLSemanticAnalyzer.unescapeIdentifier(ast.getText()));
        for (int i = 0; i < ast.getChildCount(); ++i) {
            builder.append(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(i).getText()));
        }
        return builder.toString();
    }

    private String buildTriggerActionExpression(ASTNode ast) throws SemanticException {
        switch (ast.getType()) {
            case 172: {
                return "KILL";
            }
            case 201: {
                if (ast.getChildCount() != 1) {
                    throw new SemanticException("Invalid move to clause in trigger action.");
                }
                String poolPath = this.poolPath(ast.getChild(0));
                return "MOVE TO " + poolPath;
            }
        }
        throw new SemanticException("Unknown token in action clause: " + ast.getType());
    }

    private void analyzeAlterTrigger(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() != 4) {
            throw new SemanticException("Invalid syntax for alter trigger statement");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String triggerName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        String triggerExpression = this.buildTriggerExpression((ASTNode)ast.getChild(2));
        String actionExpression = this.buildTriggerActionExpression((ASTNode)ast.getChild(3));
        WMTrigger trigger = new WMTrigger(rpName, triggerName);
        trigger.setTriggerExpression(triggerExpression);
        trigger.setActionExpression(actionExpression);
        AlterWMTriggerDesc desc = new AlterWMTriggerDesc(trigger);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeDropTrigger(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() != 2) {
            throw new SemanticException("Invalid syntax for drop trigger.");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String triggerName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        DropWMTriggerDesc desc = new DropWMTriggerDesc(rpName, triggerName);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeCreatePool(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() < 3) {
            throw new SemanticException("Expected more arguments: " + ast.toStringTree());
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String poolPath = this.poolPath(ast.getChild(1));
        WMPool pool = new WMPool(rpName, poolPath);
        block6: for (int i = 2; i < ast.getChildCount(); ++i) {
            Tree child = ast.getChild(i);
            if (child.getChildCount() != 1) {
                throw new SemanticException("Expected 1 paramter for: " + child.getText());
            }
            String param = child.getChild(0).getText();
            switch (child.getType()) {
                case 717: {
                    pool.setAllocFraction(Double.parseDouble(param));
                    continue block6;
                }
                case 958: {
                    pool.setQueryParallelism(Integer.parseInt(param));
                    continue block6;
                }
                case 985: {
                    String schedulingPolicyStr = PlanUtils.stripQuotes(param);
                    if (!MetaStoreUtils.isValidSchedulingPolicy(schedulingPolicyStr)) {
                        throw new SemanticException("Invalid scheduling policy " + schedulingPolicyStr);
                    }
                    pool.setSchedulingPolicy(schedulingPolicyStr);
                    continue block6;
                }
                case 938: {
                    throw new SemanticException("Invalid parameter path in create pool");
                }
            }
        }
        if (!pool.isSetAllocFraction()) {
            throw new SemanticException("alloc_fraction should be specified for a pool");
        }
        if (!pool.isSetQueryParallelism()) {
            throw new SemanticException("query_parallelism should be specified for a pool");
        }
        CreateOrAlterWMPoolDesc desc = new CreateOrAlterWMPoolDesc(pool, poolPath, false);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeAlterPool(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() < 3) {
            throw new SemanticException("Invalid syntax for alter pool: " + ast.toStringTree());
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        Tree poolTarget = ast.getChild(1);
        boolean isUnmanagedPool = false;
        String poolPath = null;
        if (poolTarget.getType() == 1092) {
            isUnmanagedPool = true;
        } else {
            poolPath = this.poolPath(ast.getChild(1));
        }
        WMNullablePool poolChanges = null;
        boolean hasTrigger = false;
        block6: for (int i = 2; i < ast.getChildCount(); ++i) {
            Tree child = ast.getChild(i);
            if (child.getChildCount() != 1) {
                throw new SemanticException("Invalid syntax in alter pool expected parameter.");
            }
            Tree param = child.getChild(0);
            if (child.getType() == 713 || child.getType() == 829) {
                hasTrigger = true;
                boolean drop = child.getType() == 829;
                String triggerName = DDLSemanticAnalyzer.unescapeIdentifier(param.getText());
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), new CreateOrDropTriggerToPoolMappingDesc(rpName, triggerName, poolPath, drop, isUnmanagedPool))));
                continue;
            }
            if (isUnmanagedPool) {
                throw new SemanticException("Cannot alter the unmanaged pool");
            }
            if (poolChanges == null) {
                poolChanges = new WMNullablePool(rpName, null);
            }
            switch (child.getType()) {
                case 717: {
                    poolChanges.setAllocFraction(Double.parseDouble(param.getText()));
                    continue block6;
                }
                case 958: {
                    poolChanges.setQueryParallelism(Integer.parseInt(param.getText()));
                    continue block6;
                }
                case 985: {
                    poolChanges.setIsSetSchedulingPolicy(true);
                    if (param.getType() == 906) continue block6;
                    poolChanges.setSchedulingPolicy(PlanUtils.stripQuotes(param.getText()));
                    continue block6;
                }
                case 938: {
                    poolChanges.setPoolPath(this.poolPath(param));
                    continue block6;
                }
                default: {
                    throw new SemanticException("Incorrect alter syntax: " + child.toStringTree());
                }
            }
        }
        if (poolChanges != null || hasTrigger) {
            this.addServiceOutput();
        }
        if (poolChanges != null) {
            if (!poolChanges.isSetPoolPath()) {
                poolChanges.setPoolPath(poolPath);
            }
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), new CreateOrAlterWMPoolDesc(poolChanges, poolPath, true))));
        }
    }

    private void analyzeDropPool(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() != 2) {
            throw new SemanticException("Invalid syntax for drop pool.");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String poolPath = this.poolPath(ast.getChild(1));
        DropWMPoolDesc desc = new DropWMPoolDesc(rpName, poolPath);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeCreateOrAlterMapping(ASTNode ast, boolean update) throws SemanticException {
        if (ast.getChildCount() < 4) {
            throw new SemanticException("Invalid syntax for create or alter mapping.");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String entityType = ast.getChild(1).getText();
        String entityName = PlanUtils.stripQuotes(ast.getChild(2).getText());
        WMMapping mapping = new WMMapping(rpName, entityType, entityName);
        Tree dest = ast.getChild(3);
        if (dest.getType() != 1092) {
            mapping.setPoolPath(this.poolPath(dest));
        }
        if (ast.getChildCount() == 5) {
            mapping.setOrdering(Integer.valueOf(ast.getChild(4).getText()));
        }
        CreateOrAlterWMMappingDesc desc = new CreateOrAlterWMMappingDesc(mapping, update);
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeDropMapping(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() != 3) {
            throw new SemanticException("Invalid syntax for drop mapping.");
        }
        String rpName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String entityType = ast.getChild(1).getText();
        String entityName = PlanUtils.stripQuotes(ast.getChild(2).getText());
        DropWMMappingDesc desc = new DropWMMappingDesc(new WMMapping(rpName, entityType, entityName));
        this.addServiceOutput();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeCreateDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        String dbLocation = null;
        HashMap<String, String> dbProps = null;
        block6: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 859: {
                    ifNotExists = true;
                    continue block6;
                }
                case 796: {
                    dbComment = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                case 798: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block6;
                }
                case 797: {
                    dbLocation = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    this.addLocationToOutputs(dbLocation);
                    continue block6;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc(dbName, dbComment, dbLocation, ifNotExists);
        if (dbProps != null) {
            createDatabaseDesc.setDatabaseProperties(dbProps);
        }
        Database database = new Database(dbName, dbComment, dbLocation, dbProps);
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createDatabaseDesc)));
    }

    private void analyzeDropDatabase(ASTNode ast) throws SemanticException {
        Database database;
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        boolean ifCascade = false;
        if (null != ast.getFirstChildWithType(858)) {
            ifExists = true;
        }
        if (null != ast.getFirstChildWithType(773)) {
            ifCascade = true;
        }
        if ((database = this.getDatabase(dbName, !ifExists)) == null) {
            return;
        }
        if (ifCascade) {
            List<String> tableNames;
            try {
                tableNames = this.db.getAllTables(dbName);
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
            if (tableNames != null) {
                for (String tableName : tableNames) {
                    Table table = this.getTable(dbName, tableName, true);
                    this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
                }
            }
        }
        this.inputs.add(new ReadEntity(database));
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_EXCLUSIVE));
        DropDatabaseDesc dropDatabaseDesc = new DropDatabaseDesc(dbName, ifExists, ifCascade, new ReplicationSpec());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropDatabaseDesc)));
    }

    private void analyzeSwitchDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        Database database = this.getDatabase(dbName, true);
        ReadEntity dbReadEntity = new ReadEntity(database);
        dbReadEntity.noLockNeeded();
        this.inputs.add(dbReadEntity);
        SwitchDatabaseDesc switchDatabaseDesc = new SwitchDatabaseDesc(dbName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), switchDatabaseDesc)));
    }

    private void analyzeDropTable(ASTNode ast, TableType expectedType) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        boolean ifExists = ast.getFirstChildWithType(858) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        ReplicationSpec replicationSpec = new ReplicationSpec(ast);
        Table tab = this.getTable(tableName, throwException);
        if (tab != null) {
            this.inputs.add(new ReadEntity(tab));
            this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_EXCLUSIVE));
        }
        boolean ifPurge = ast.getFirstChildWithType(240) != null;
        DropTableDesc dropTblDesc = new DropTableDesc(tableName, expectedType, ifExists, ifPurge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc)));
    }

    private void analyzeTruncateTable(ASTNode ast) throws SemanticException {
        ASTNode root = (ASTNode)ast.getChild(0);
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        Table table = this.getTable(tableName, true);
        if (table.getTableType() != TableType.MANAGED_TABLE) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_MANAGED_TABLE.format(tableName));
        }
        if (table.isNonNative()) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_NATIVE_TABLE.format(tableName));
        }
        if (!table.isPartitioned() && root.getChildCount() > 1) {
            throw new SemanticException(ErrorMsg.PARTSPEC_FOR_NON_PARTITIONED_TABLE.format(tableName));
        }
        HashMap partSpec = DDLSemanticAnalyzer.getPartSpec((ASTNode)root.getChild(1));
        if (partSpec == null) {
            if (!table.isPartitioned()) {
                this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_EXCLUSIVE));
            } else {
                for (Partition partition : this.getPartitions(table, null, false)) {
                    this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
                }
            }
        } else if (DDLSemanticAnalyzer.isFullSpec(table, partSpec)) {
            DDLSemanticAnalyzer.validatePartSpec(table, partSpec, (ASTNode)root.getChild(1), this.conf, true);
            Partition partition = this.getPartition(table, partSpec, true);
            this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
        } else {
            DDLSemanticAnalyzer.validatePartSpec(table, partSpec, (ASTNode)root.getChild(1), this.conf, false);
            for (Partition partition : this.getPartitions(table, partSpec, false)) {
                this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
            }
        }
        TruncateTableDesc truncateTblDesc = new TruncateTableDesc(tableName, partSpec, null);
        DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), truncateTblDesc);
        Task<DDLWork> truncateTask = TaskFactory.get(ddlWork);
        List<String> columnNames = null;
        if (ast.getChildCount() == 2) {
            try {
                columnNames = DDLSemanticAnalyzer.getColumnNames((ASTNode)ast.getChild(1));
                if (AcidUtils.isInsertOnlyTable(table.getParameters())) {
                    throw new SemanticException("Truncating MM table columns not presently supported");
                }
                List<String> bucketCols = null;
                Class<? extends InputFormat> inputFormatClass = null;
                boolean isArchived = false;
                Path newTblPartLoc = null;
                Path oldTblPartLoc = null;
                List<FieldSchema> cols = null;
                ListBucketingCtx lbCtx = null;
                boolean isListBucketed = false;
                List<String> listBucketColNames = null;
                if (table.isPartitioned()) {
                    Partition part = this.db.getPartition(table, partSpec, false);
                    Path tabPath = table.getPath();
                    Path partPath = part.getDataLocation();
                    newTblPartLoc = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                    oldTblPartLoc = partPath;
                    cols = part.getCols();
                    bucketCols = part.getBucketCols();
                    inputFormatClass = part.getInputFormatClass();
                    isArchived = ArchiveUtils.isArchived(part);
                    lbCtx = this.constructListBucketingCtx(part.getSkewedColNames(), part.getSkewedColValues(), part.getSkewedColValueLocationMaps(), part.isStoredAsSubDirectories(), this.conf);
                    isListBucketed = part.isStoredAsSubDirectories();
                    listBucketColNames = part.getSkewedColNames();
                } else {
                    oldTblPartLoc = table.getPath();
                    newTblPartLoc = table.getPath();
                    cols = table.getCols();
                    bucketCols = table.getBucketCols();
                    inputFormatClass = table.getInputFormatClass();
                    lbCtx = this.constructListBucketingCtx(table.getSkewedColNames(), table.getSkewedColValues(), table.getSkewedColValueLocationMaps(), table.isStoredAsSubDirectories(), this.conf);
                    isListBucketed = table.isStoredAsSubDirectories();
                    listBucketColNames = table.getSkewedColNames();
                }
                if (!inputFormatClass.equals(RCFileInputFormat.class)) {
                    throw new SemanticException(ErrorMsg.TRUNCATE_COLUMN_NOT_RC.getMsg());
                }
                if (isArchived) {
                    throw new SemanticException(ErrorMsg.TRUNCATE_COLUMN_ARCHIVED.getMsg());
                }
                HashSet<Integer> columnIndexes = new HashSet<Integer>();
                for (String columnName : columnNames) {
                    boolean found = false;
                    for (int columnIndex = 0; columnIndex < cols.size(); ++columnIndex) {
                        if (!columnName.equalsIgnoreCase(cols.get(columnIndex).getName())) continue;
                        columnIndexes.add(columnIndex);
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(columnName));
                    }
                    for (String bucketCol : bucketCols) {
                        if (!bucketCol.equalsIgnoreCase(columnName)) continue;
                        throw new SemanticException(ErrorMsg.TRUNCATE_BUCKETED_COLUMN.getMsg(columnName));
                    }
                    if (!isListBucketed) continue;
                    for (String listBucketCol : listBucketColNames) {
                        if (!listBucketCol.equalsIgnoreCase(columnName)) continue;
                        throw new SemanticException(ErrorMsg.TRUNCATE_LIST_BUCKETED_COLUMN.getMsg(columnName));
                    }
                }
                truncateTblDesc.setColumnIndexes(new ArrayList<Integer>(columnIndexes));
                truncateTblDesc.setInputDir(oldTblPartLoc);
                truncateTblDesc.setLbCtx(lbCtx);
                this.addInputsOutputsAlterTable(tableName, partSpec, AlterTableDesc.AlterTableTypes.TRUNCATE);
                ddlWork.setNeedLock(true);
                TableDesc tblDesc = Utilities.getTableDesc(table);
                Path queryTmpdir = this.ctx.getExternalTmpPath(newTblPartLoc);
                truncateTblDesc.setOutputDir(queryTmpdir);
                LoadTableDesc ltd = new LoadTableDesc(queryTmpdir, tblDesc, partSpec == null ? new HashMap() : partSpec);
                ltd.setLbCtx(lbCtx);
                Task<MoveWork> moveTsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false));
                truncateTask.addDependentTask(moveTsk);
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                    BasicStatsWork basicStatsWork;
                    if (oldTblPartLoc.equals((Object)newTblPartLoc)) {
                        BaseSemanticAnalyzer.TableSpec tablepart = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, root);
                        basicStatsWork = new BasicStatsWork(tablepart);
                    } else {
                        basicStatsWork = new BasicStatsWork(ltd);
                    }
                    basicStatsWork.setNoStatsAggregator(true);
                    basicStatsWork.setClearAggregatorStats(true);
                    StatsWork columnStatsWork = new StatsWork(table, basicStatsWork, this.conf);
                    Task<StatsWork> statTask = TaskFactory.get(columnStatsWork);
                    moveTsk.addDependentTask(statTask);
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
        }
        this.rootTasks.add(truncateTask);
    }

    public static boolean isFullSpec(Table table, Map<String, String> partSpec) {
        for (FieldSchema partCol : table.getPartCols()) {
            if (partSpec.get(partCol.getName()) != null) continue;
            return false;
        }
        return true;
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes op) throws SemanticException {
        this.validateAlterTableType(tbl, op, false);
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes op, boolean expectView) throws SemanticException {
        block7: {
            block6: {
                if (!tbl.isView()) break block6;
                if (!expectView) {
                    throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_VIEWS.getMsg());
                }
                switch (op) {
                    case ADDPARTITION: 
                    case DROPPARTITION: 
                    case RENAMEPARTITION: 
                    case ADDPROPS: 
                    case DROPPROPS: 
                    case RENAME: {
                        break block7;
                    }
                    default: {
                        throw new SemanticException(ErrorMsg.ALTER_VIEW_DISALLOWED_OP.getMsg(op.toString()));
                    }
                }
            }
            if (expectView) {
                throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_TABLES.getMsg());
            }
        }
        if (tbl.isNonNative() && !AlterTableDesc.AlterTableTypes.nonNativeTableAllowedTypes.contains((Object)op)) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private boolean hasConstraintsEnabled(String tblName) throws SemanticException {
        NotNullConstraint nnc = null;
        DefaultConstraint dc = null;
        try {
            nnc = Hive.get().getEnabledNotNullConstraints(this.db.getDatabaseCurrent().getName(), tblName);
            dc = Hive.get().getEnabledDefaultConstraints(this.db.getDatabaseCurrent().getName(), tblName);
        }
        catch (Exception e) {
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new RuntimeException(e);
        }
        return nnc != null && !nnc.getNotNullConstraints().isEmpty() || dc != null && !dc.getDefaultConstraints().isEmpty();
    }

    private void analyzeAlterTableProps(String[] qualified, HashMap<String, String> partSpec, ASTNode ast, boolean expectView, boolean isUnset) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getDotName(qualified);
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(0).getChild(0));
        EnvironmentContext environmentContext = null;
        boolean changeStatsSucceeded = false;
        for (Map.Entry<String, String> entry : mapProp.entrySet()) {
            if (entry.getKey().equals("numRows") || entry.getKey().equals("rawDataSize")) {
                try {
                    Long.parseLong(entry.getValue());
                    changeStatsSucceeded = true;
                }
                catch (Exception e) {
                    throw new SemanticException("AlterTable " + entry.getKey() + " failed with value " + entry.getValue());
                }
            } else if (entry.getKey().equals("external") && entry.getValue().equals("true")) {
                if (this.hasConstraintsEnabled(qualified[1])) {
                    throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Table: " + tableName + " has constraints enabled.Please remove those constraints to change this property."));
                }
            } else if (this.queryState.getCommandType().equals(HiveOperation.ALTERTABLE_UPDATETABLESTATS.getOperationName()) || this.queryState.getCommandType().equals(HiveOperation.ALTERTABLE_UPDATEPARTSTATS.getOperationName())) {
                throw new SemanticException("AlterTable UpdateStats " + entry.getKey() + " failed because the only valid keys are " + "numRows" + " and " + "rawDataSize");
            }
            if (!changeStatsSucceeded) continue;
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("STATS_GENERATED", "USER");
        }
        AlterTableDesc alterTblDesc = null;
        if (isUnset) {
            alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.DROPPROPS, partSpec, expectView);
            if (ast.getChild(1) != null) {
                alterTblDesc.setDropIfExists(true);
            }
        } else {
            alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, partSpec, expectView);
        }
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setEnvironmentContext(environmentContext);
        alterTblDesc.setOldName(tableName);
        boolean isPotentialMmSwitch = AcidUtils.isTablePropertyTransactional(mapProp) || mapProp.containsKey("transactional_properties");
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc, isPotentialMmSwitch);
        DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc);
        if (isPotentialMmSwitch) {
            this.ddlDescWithWriteId = alterTblDesc;
            ddlWork.setNeedLock(true);
        }
        this.rootTasks.add(TaskFactory.get(ddlWork));
    }

    @Override
    public DDLDesc.DDLDescWithWriteId getAcidDdlDesc() {
        return this.ddlDescWithWriteId;
    }

    private void analyzeAlterTableSerdeProps(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(0).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDEPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableSerde(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String serdeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDE);
        if (ast.getChildCount() > 1) {
            HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
            alterTblDesc.setProps(mapProp);
        }
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setSerdeName(serdeName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableFileFormat(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        StorageFormat format = new StorageFormat(this.conf);
        ASTNode child = (ASTNode)ast.getChild(0);
        if (!format.fillStorageFormat(child)) {
            throw new AssertionError((Object)("Unknown token " + child.getText()));
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, format.getInputFormat(), format.getOutputFormat(), format.getSerde(), format.getStorageHandler(), partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private WriteEntity.WriteType determineAlterTableWriteType(Table tab, AlterTableDesc desc, AlterTableDesc.AlterTableTypes op) {
        boolean convertingToAcid = false;
        if (desc != null && desc.getProps() != null && Boolean.parseBoolean(desc.getProps().get("transactional"))) {
            convertingToAcid = true;
        }
        if (!AcidUtils.isTransactionalTable(tab) && convertingToAcid) {
            return WriteEntity.WriteType.DDL_EXCLUSIVE;
        }
        return WriteEntity.determineAlterTableWriteType(op);
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc.AlterTableTypes op) throws SemanticException {
        this.addInputsOutputsAlterTable(tableName, partSpec, null, op, false);
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc desc, boolean doForceExclusive) throws SemanticException {
        this.addInputsOutputsAlterTable(tableName, partSpec, desc, desc.getOp(), doForceExclusive);
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc desc) throws SemanticException {
        this.addInputsOutputsAlterTable(tableName, partSpec, desc, desc.getOp(), false);
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc desc, AlterTableDesc.AlterTableTypes op, boolean doForceExclusive) throws SemanticException {
        WriteEntity.WriteType writeType;
        boolean alterPartitions;
        boolean isCascade = desc != null && desc.getIsCascade();
        boolean bl = alterPartitions = partSpec != null && !partSpec.isEmpty();
        if (isCascade && alterPartitions) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_PARTITION_CASCADE_NOT_SUPPORTED, op.getName());
        }
        Table tab = this.getTable(tableName, true);
        if (isCascade && !tab.isPartitioned()) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_NON_PARTITIONED_TABLE_CASCADE_NOT_SUPPORTED, new String[0]);
        }
        WriteEntity.WriteType writeType2 = writeType = doForceExclusive ? WriteEntity.WriteType.DDL_EXCLUSIVE : this.determineAlterTableWriteType(tab, desc, op);
        if (!alterPartitions) {
            this.inputs.add(new ReadEntity(tab));
            this.alterTableOutput = new WriteEntity(tab, writeType);
            this.outputs.add(this.alterTableOutput);
            if (isCascade) {
                for (Partition part : this.getPartitions(tab, partSpec, false)) {
                    this.outputs.add(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK));
                }
            }
        } else {
            ReadEntity re = new ReadEntity(tab);
            re.noLockNeeded();
            this.inputs.add(re);
            if (DDLSemanticAnalyzer.isFullSpec(tab, partSpec)) {
                Partition part;
                part = this.getPartition(tab, partSpec, true);
                this.outputs.add(new WriteEntity(part, writeType));
            } else {
                if (!AlterTableDesc.doesAlterTableTypeSupportPartialPartitionSpec(op)) {
                    throw new SemanticException(ErrorMsg.ALTER_TABLE_TYPE_PARTIAL_PARTITION_SPEC_NO_SUPPORTED, op.getName());
                }
                if (!this.conf.getBoolVar(HiveConf.ConfVars.DYNAMICPARTITIONING)) {
                    throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_DISABLED, new String[0]);
                }
                for (Partition part : this.getPartitions(tab, partSpec, true)) {
                    this.outputs.add(new WriteEntity(part, writeType));
                }
            }
        }
        if (desc != null) {
            this.validateAlterTableType(tab, op, desc.getExpectView());
            if (op == AlterTableDesc.AlterTableTypes.DROPPROPS && !desc.getIsDropIfExists()) {
                Map<String, String> tableParams = tab.getTTable().getParameters();
                for (String currKey : desc.getProps().keySet()) {
                    if (tableParams.containsKey(currKey)) continue;
                    String errorMsg = "The following property " + currKey + " does not exist in " + tab.getTableName();
                    throw new SemanticException(ErrorMsg.ALTER_TBL_UNSET_NON_EXIST_PROPERTY.getMsg(errorMsg));
                }
            }
        }
    }

    private void analyzeAlterTableOwner(ASTNode ast, String tableName) throws SemanticException {
        PrincipalDesc ownerPrincipal = AuthorizationParseUtils.getPrincipalDesc((ASTNode)ast.getChild(0));
        if (ownerPrincipal.getType() == null) {
            throw new SemanticException("Owner type can't be null in alter table set owner command");
        }
        if (ownerPrincipal.getName() == null) {
            throw new SemanticException("Owner name can't be null in alter table set owner command");
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, ownerPrincipal);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf));
    }

    private void analyzeAlterTableLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String newLocation = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        try {
            FileSystem.get((URI)new URI(newLocation), (Configuration)this.conf).getFileStatus(new Path(newLocation));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            throw new SemanticException("Cannot connect to namenode, please check if host/port pair for " + newLocation + " is valid", e);
        }
        this.addLocationToOutputs(newLocation);
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, newLocation, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTablePartMergeFiles(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTablePartMergeFilesDesc mergeDesc = new AlterTablePartMergeFilesDesc(tableName, partSpec);
        ArrayList<Path> inputDir = new ArrayList<Path>();
        Path oldTblPartLoc = null;
        Path newTblPartLoc = null;
        Table tblObj = null;
        ListBucketingCtx lbCtx = null;
        try {
            tblObj = this.getTable(tableName);
            if (AcidUtils.isTransactionalTable(tblObj)) {
                LinkedHashMap<String, String> newPartSpec = null;
                if (partSpec != null) {
                    newPartSpec = new LinkedHashMap<String, String>(partSpec);
                }
                boolean isBlocking = !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, false);
                AlterTableSimpleDesc desc = new AlterTableSimpleDesc(tableName, newPartSpec, "MAJOR", isBlocking);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
                return;
            }
            mergeDesc.setTableDesc(Utilities.getTableDesc(tblObj));
            List<String> bucketCols = null;
            Class<? extends InputFormat> inputFormatClass = null;
            boolean isArchived = false;
            if (tblObj.isPartitioned()) {
                if (partSpec == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but no partition desc found.");
                }
                Partition part = this.getPartition(tblObj, partSpec, false);
                if (part == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but partition not found.");
                }
                bucketCols = part.getBucketCols();
                inputFormatClass = part.getInputFormatClass();
                isArchived = ArchiveUtils.isArchived(part);
                Path tabPath = tblObj.getPath();
                Path partPath = part.getDataLocation();
                newTblPartLoc = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                oldTblPartLoc = partPath;
                lbCtx = this.constructListBucketingCtx(part.getSkewedColNames(), part.getSkewedColValues(), part.getSkewedColValueLocationMaps(), part.isStoredAsSubDirectories(), this.conf);
            } else {
                inputFormatClass = tblObj.getInputFormatClass();
                bucketCols = tblObj.getBucketCols();
                oldTblPartLoc = tblObj.getPath();
                newTblPartLoc = tblObj.getPath();
                lbCtx = this.constructListBucketingCtx(tblObj.getSkewedColNames(), tblObj.getSkewedColValues(), tblObj.getSkewedColValueLocationMaps(), tblObj.isStoredAsSubDirectories(), this.conf);
            }
            if (!inputFormatClass.equals(RCFileInputFormat.class) && !inputFormatClass.equals(OrcInputFormat.class)) {
                throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_FILE_FORMAT.getMsg());
            }
            mergeDesc.setInputFormatClass(inputFormatClass);
            if (bucketCols != null && bucketCols.size() > 0) {
                throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_TABLE_BUCKETED.getMsg());
            }
            if (isArchived) {
                throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_PARTITION_ARCHIVED.getMsg());
            }
            if (tblObj.isNonNative()) {
                throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_TABLE_NON_NATIVE.getMsg());
            }
            if (tblObj.getTableType() != TableType.MANAGED_TABLE) {
                throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_TABLE_NOT_MANAGED.getMsg());
            }
            inputDir.add(oldTblPartLoc);
            mergeDesc.setInputDir(inputDir);
            mergeDesc.setLbCtx(lbCtx);
            this.addInputsOutputsAlterTable(tableName, partSpec, AlterTableDesc.AlterTableTypes.MERGEFILES);
            DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), mergeDesc);
            ddlWork.setNeedLock(true);
            Task<DDLWork> mergeTask = TaskFactory.get(ddlWork);
            TableDesc tblDesc = Utilities.getTableDesc(tblObj);
            Path queryTmpdir = this.ctx.getExternalTmpPath(newTblPartLoc);
            mergeDesc.setOutputDir(queryTmpdir);
            LoadTableDesc ltd = new LoadTableDesc(queryTmpdir, tblDesc, (Map<String, String>)(partSpec == null ? new HashMap<String, String>() : partSpec));
            ltd.setLbCtx(lbCtx);
            Task<MoveWork> moveTsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false));
            mergeTask.addDependentTask(moveTsk);
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                BasicStatsWork basicStatsWork;
                if (oldTblPartLoc.equals((Object)newTblPartLoc)) {
                    BaseSemanticAnalyzer.TableSpec tableSpec = new BaseSemanticAnalyzer.TableSpec(this.db, tableName, partSpec);
                    basicStatsWork = new BasicStatsWork(tableSpec);
                } else {
                    basicStatsWork = new BasicStatsWork(ltd);
                }
                basicStatsWork.setNoStatsAggregator(true);
                basicStatsWork.setClearAggregatorStats(true);
                StatsWork columnStatsWork = new StatsWork(tblObj, basicStatsWork, this.conf);
                Task<StatsWork> statTask = TaskFactory.get(columnStatsWork);
                moveTsk.addDependentTask(statTask);
            }
            this.rootTasks.add(mergeTask);
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void analyzeAlterTableClusterSort(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTableDesc alterTblDesc;
        switch (ast.getChild(0).getType()) {
            case 900: {
                alterTblDesc = new AlterTableDesc(tableName, -1, new ArrayList<String>(), new ArrayList<Order>(), partSpec);
                break;
            }
            case 903: {
                alterTblDesc = new AlterTableDesc(tableName, true, partSpec);
                break;
            }
            case 726: {
                ASTNode buckets = (ASTNode)ast.getChild(0);
                List<String> bucketCols = DDLSemanticAnalyzer.getColumnNames((ASTNode)buckets.getChild(0));
                ArrayList<Order> sortCols = new ArrayList();
                int numBuckets = -1;
                if (buckets.getChildCount() == 2) {
                    numBuckets = Integer.parseInt(buckets.getChild(1).getText());
                } else {
                    sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
                    numBuckets = Integer.parseInt(buckets.getChild(2).getText());
                }
                if (numBuckets <= 0) {
                    throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
                }
                alterTblDesc = new AlterTableDesc(tableName, numBuckets, bucketCols, sortCols, partSpec);
                break;
            }
            default: {
                throw new SemanticException("Invalid operation " + ast.getChild(0).getType());
            }
        }
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableCompact(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String type = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText()).toLowerCase();
        if (!type.equals("minor") && !type.equals("major")) {
            throw new SemanticException(ErrorMsg.INVALID_COMPACTION_TYPE.getMsg());
        }
        LinkedHashMap<String, String> newPartSpec = null;
        if (partSpec != null) {
            newPartSpec = new LinkedHashMap<String, String>(partSpec);
        }
        HashMap<String, String> mapProp = null;
        boolean isBlocking = false;
        block4: for (int i = 0; i < ast.getChildCount(); ++i) {
            switch (ast.getChild(i).getType()) {
                case 1049: {
                    mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(i).getChild(0));
                    continue block4;
                }
                case 770: {
                    isBlocking = true;
                }
            }
        }
        AlterTableSimpleDesc desc = new AlterTableSimpleDesc(tableName, newPartSpec, type, isBlocking);
        desc.setProps(mapProp);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeAlterTableDropConstraint(ASTNode ast, String tableName) throws SemanticException {
        String dropConstraintName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, dropConstraintName, (ReplicationSpec)null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableAddConstraint(ASTNode ast, String tableName) throws SemanticException {
        ASTNode parent = (ASTNode)ast.getParent();
        String[] qualifiedTabName = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0));
        String catName = MetaStoreUtils.getDefaultCatalog(this.conf);
        ASTNode child = (ASTNode)ast.getChild(0);
        ArrayList<SQLPrimaryKey> primaryKeys = new ArrayList<SQLPrimaryKey>();
        ArrayList<SQLForeignKey> foreignKeys = new ArrayList<SQLForeignKey>();
        ArrayList<SQLUniqueConstraint> uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
        ArrayList<SQLCheckConstraint> checkConstraints = new ArrayList<SQLCheckConstraint>();
        switch (child.getToken().getType()) {
            case 1088: {
                BaseSemanticAnalyzer.processUniqueConstraints(catName, qualifiedTabName[0], qualifiedTabName[1], child, uniqueConstraints);
                break;
            }
            case 940: {
                BaseSemanticAnalyzer.processPrimaryKeys(qualifiedTabName[0], qualifiedTabName[1], child, primaryKeys);
                break;
            }
            case 842: {
                BaseSemanticAnalyzer.processForeignKeys(qualifiedTabName[0], qualifiedTabName[1], child, foreignKeys);
                break;
            }
            case 776: {
                BaseSemanticAnalyzer.processCheckConstraints(catName, qualifiedTabName[0], qualifiedTabName[1], child, null, checkConstraints, child, this.ctx.getTokenRewriteStream());
                break;
            }
            default: {
                throw new SemanticException(ErrorMsg.NOT_RECOGNIZED_CONSTRAINT.getMsg(child.getToken().getText()));
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, primaryKeys, foreignKeys, uniqueConstraints, null, null, checkConstraints, null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableUpdateColumns(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        boolean isCascade = false;
        if (null != ast.getFirstChildWithType(773)) {
            isCascade = true;
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.UPDATECOLUMNS);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setIsCascade(isCascade);
        alterTblDesc.setPartSpec(partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf));
    }

    static HashMap<String, String> getProps(ASTNode prop) {
        LinkedHashMap<String, String> mapProp = new LinkedHashMap<String, String>();
        DDLSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private void validateDatabase(String databaseName) throws SemanticException {
        try {
            if (!this.db.databaseExists(databaseName)) {
                throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName), e);
        }
    }

    private void validateTable(String tableName, Map<String, String> partSpec) throws SemanticException {
        Table tab = this.getTable(tableName);
        if (partSpec != null) {
            this.getPartition(tab, partSpec, true);
        }
    }

    private void analyzeDescribeTable(ASTNode ast) throws SemanticException {
        ASTNode tableTypeExpr = (ASTNode)ast.getChild(0);
        String dbName = null;
        String tableName = null;
        String colPath = null;
        Map<String, String> partSpec = null;
        ASTNode tableNode = null;
        if (((ASTNode)tableTypeExpr.getChild(0)).getType() == 1064) {
            tableNode = (ASTNode)tableTypeExpr.getChild(0);
            if (tableNode.getChildCount() == 1) {
                tableName = ((ASTNode)tableNode.getChild(0)).getText();
            } else {
                dbName = ((ASTNode)tableNode.getChild(0)).getText();
                tableName = dbName + "." + ((ASTNode)tableNode.getChild(1)).getText();
            }
        } else {
            throw new SemanticException(((ASTNode)tableTypeExpr.getChild(0)).getText() + " is not an expected token type");
        }
        partSpec = QualifiedNameUtil.getPartitionSpec(this.db, tableTypeExpr, tableName);
        colPath = QualifiedNameUtil.getColPath(this.db, tableTypeExpr, dbName, tableName, partSpec);
        if (dbName != null) {
            this.validateDatabase(dbName);
        }
        if (partSpec != null) {
            this.validateTable(tableName, partSpec);
        }
        DescTableDesc descTblDesc = new DescTableDesc(this.ctx.getResFile(), tableName, partSpec, colPath);
        boolean showColStats = false;
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            descTblDesc.setFormatted(descOptions == 139);
            descTblDesc.setExt(descOptions == 124);
            if (!colPath.equalsIgnoreCase(tableName) && descTblDesc.isFormatted()) {
                showColStats = true;
            }
        }
        this.inputs.add(new ReadEntity(this.getTable(tableName)));
        Task<DDLWork> ddlTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc));
        this.rootTasks.add(ddlTask);
        String schema = DescTableDesc.getSchema(showColStats);
        this.setFetchTask(this.createFetchTask(schema));
        LOG.info("analyzeDescribeTable done");
    }

    private void analyzeDescDatabase(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String dbName;
        if (ast.getChildCount() == 1) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE DATABASE");
        }
        DescDatabaseDesc descDbDesc = new DescDatabaseDesc(this.ctx.getResFile(), dbName, isExtended);
        this.inputs.add(new ReadEntity(this.getDatabase(dbName)));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descDbDesc)));
        this.setFetchTask(this.createFetchTask(descDbDesc.getSchema()));
    }

    public static HashMap<String, String> getPartSpec(ASTNode partspec) throws SemanticException {
        if (partspec == null) {
            return null;
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            ASTNode partspec_val = (ASTNode)partspec.getChild(i);
            String key = partspec_val.getChild(0).getText();
            String val = null;
            if (partspec_val.getChildCount() > 1) {
                val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            }
            partSpec.put(key.toLowerCase(), val);
        }
        return partSpec;
    }

    public static HashMap<String, String> getValidatedPartSpec(Table table, ASTNode astNode, HiveConf conf, boolean shouldBeFull) throws SemanticException {
        HashMap<String, String> partSpec = DDLSemanticAnalyzer.getPartSpec(astNode);
        if (partSpec != null && !partSpec.isEmpty()) {
            DDLSemanticAnalyzer.validatePartSpec(table, partSpec, astNode, conf, shouldBeFull);
        }
        return partSpec;
    }

    private void analyzeShowPartitions(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        this.validateTable(tableName, null);
        ShowPartitionsDesc showPartsDesc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec);
        this.inputs.add(new ReadEntity(this.getTable(tableName)));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc)));
        this.setFetchTask(this.createFetchTask(showPartsDesc.getSchema()));
    }

    private void analyzeShowCreateDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowCreateDatabaseDesc showCreateDbDesc = new ShowCreateDatabaseDesc(dbName, this.ctx.getResFile().toString());
        Database database = this.getDatabase(dbName);
        this.inputs.add(new ReadEntity(database));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showCreateDbDesc)));
        this.setFetchTask(this.createFetchTask(showCreateDbDesc.getSchema()));
    }

    private void analyzeShowCreateTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowCreateTableDesc showCreateTblDesc = new ShowCreateTableDesc(tableName, this.ctx.getResFile().toString());
        Table tab = this.getTable(tableName);
        this.inputs.add(new ReadEntity(tab));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showCreateTblDesc)));
        this.setFetchTask(this.createFetchTask(showCreateTblDesc.getSchema()));
    }

    private void analyzeShowDatabases(ASTNode ast) throws SemanticException {
        ShowDatabasesDesc showDatabasesDesc;
        if (ast.getChildCount() == 1) {
            String databasePattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile(), databasePattern);
        } else {
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showDatabasesDesc)));
        this.setFetchTask(this.createFetchTask(showDatabasesDesc.getSchema()));
    }

    private void analyzeShowTables(ASTNode ast) throws SemanticException {
        ShowTablesDesc showTblsDesc;
        String dbName = SessionState.get().getCurrentDatabase();
        String tableNames = null;
        if (ast.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg(ast.toStringTree()));
        }
        switch (ast.getChildCount()) {
            case 1: {
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 843);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                this.validateDatabase(dbName);
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 843);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                this.validateDatabase(dbName);
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            default: {
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
            }
        }
        this.inputs.add(new ReadEntity(this.getDatabase(dbName)));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblsDesc)));
        this.setFetchTask(this.createFetchTask(showTblsDesc.getSchema()));
    }

    private void analyzeShowColumns(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() > 4 || ast.getChildCount() < 1) {
            throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg(ast.toStringTree()));
        }
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowColumnsDesc showColumnsDesc = null;
        String pattern = null;
        switch (ast.getChildCount()) {
            case 1: {
                showColumnsDesc = new ShowColumnsDesc(this.ctx.getResFile(), tableName);
                break;
            }
            case 2: {
                pattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
                showColumnsDesc = new ShowColumnsDesc(this.ctx.getResFile(), tableName, pattern);
                break;
            }
            case 3: {
                if (tableName.contains(".")) {
                    throw new SemanticException("Duplicates declaration for database name");
                }
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(2)) + "." + tableName;
                showColumnsDesc = new ShowColumnsDesc(this.ctx.getResFile(), tableName);
                break;
            }
            case 4: {
                if (tableName.contains(".")) {
                    throw new SemanticException("Duplicates declaration for database name");
                }
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(2)) + "." + tableName;
                pattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(3).getText());
                showColumnsDesc = new ShowColumnsDesc(this.ctx.getResFile(), tableName, pattern);
                break;
            }
        }
        Table tab = this.getTable(tableName);
        this.inputs.add(new ReadEntity(tab));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showColumnsDesc)));
        this.setFetchTask(this.createFetchTask(showColumnsDesc.getSchema()));
    }

    private void analyzeShowTableStatus(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String dbName = SessionState.get().getCurrentDatabase();
        int children = ast.getChildCount();
        HashMap<String, String> partSpec = null;
        if (children >= 2) {
            if (children > 3) {
                throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg());
            }
            for (int i = 1; i < children; ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getToken().getType() == 25) {
                    dbName = DDLSemanticAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 936) {
                    partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(this.getTable(tableNames), child, this.conf, false);
                    continue;
                }
                throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg(child.toStringTree() + " , Invalid token " + child.getToken().getType()));
            }
        }
        if (partSpec != null) {
            this.validateTable(tableNames, partSpec);
        }
        ShowTableStatusDesc showTblStatusDesc = new ShowTableStatusDesc(this.ctx.getResFile().toString(), dbName, tableNames, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblStatusDesc)));
        this.setFetchTask(this.createFetchTask(showTblStatusDesc.getSchema()));
    }

    private void analyzeShowTableProperties(ASTNode ast) throws SemanticException {
        String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String propertyName = null;
        if (ast.getChildCount() > 1) {
            propertyName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        }
        String tableNames = DDLSemanticAnalyzer.getDotName(qualified);
        this.validateTable(tableNames, null);
        ShowTblPropertiesDesc showTblPropertiesDesc = new ShowTblPropertiesDesc(this.ctx.getResFile().toString(), tableNames, propertyName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblPropertiesDesc)));
        this.setFetchTask(this.createFetchTask(showTblPropertiesDesc.getSchema()));
    }

    private void analyzeShowFunctions(ASTNode ast) throws SemanticException {
        ShowFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames);
        } else if (ast.getChildCount() == 2) {
            assert (ast.getChild(0).getType() == 178);
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(1).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames, true);
        } else {
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc)));
        this.setFetchTask(this.createFetchTask(showFuncsDesc.getSchema()));
    }

    private void analyzeShowLocks(ASTNode ast) throws SemanticException {
        String tableName = null;
        HashMap<String, String> partSpec = null;
        boolean isExtended = false;
        if (ast.getChildCount() >= 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getType() == 1069) {
                    ASTNode tableTypeExpr = child;
                    tableName = QualifiedNameUtil.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
                    if (tableTypeExpr.getChildCount() != 2) continue;
                    ASTNode partSpecNode = (ASTNode)tableTypeExpr.getChild(1);
                    partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(this.getTable(tableName), partSpecNode, this.conf, false);
                    continue;
                }
                if (child.getType() != 124) continue;
                isExtended = true;
            }
        }
        HiveTxnManager txnManager = null;
        try {
            txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        }
        catch (LockException e) {
            throw new SemanticException(e.getMessage());
        }
        ShowLocksDesc showLocksDesc = new ShowLocksDesc(this.ctx.getResFile(), tableName, partSpec, isExtended, txnManager.useNewShowLocksFormat());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showLocksDesc)));
        this.setFetchTask(this.createFetchTask(showLocksDesc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeShowDbLocks(ASTNode ast) throws SemanticException {
        boolean isExtended = ast.getChildCount() > 1;
        String dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
        HiveTxnManager txnManager = null;
        try {
            txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        }
        catch (LockException e) {
            throw new SemanticException(e.getMessage());
        }
        ShowLocksDesc showLocksDesc = new ShowLocksDesc(this.ctx.getResFile(), dbName, isExtended, txnManager.useNewShowLocksFormat());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showLocksDesc)));
        this.setFetchTask(this.createFetchTask(showLocksDesc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeShowConf(ASTNode ast) throws SemanticException {
        String confName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
        ShowConfDesc showConfDesc = new ShowConfDesc(this.ctx.getResFile(), confName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showConfDesc)));
        this.setFetchTask(this.createFetchTask(showConfDesc.getSchema()));
    }

    private void analyzeShowViews(ASTNode ast) throws SemanticException {
        ShowTablesDesc showViewsDesc;
        String dbName = SessionState.get().getCurrentDatabase();
        String viewNames = null;
        if (ast.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
        }
        switch (ast.getChildCount()) {
            case 1: {
                viewNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                showViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, viewNames, TableType.VIRTUAL_VIEW);
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 843);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                this.validateDatabase(dbName);
                showViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                showViewsDesc.setType(TableType.VIRTUAL_VIEW);
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 843);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                viewNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                this.validateDatabase(dbName);
                showViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, viewNames, TableType.VIRTUAL_VIEW);
                break;
            }
            default: {
                showViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                showViewsDesc.setType(TableType.VIRTUAL_VIEW);
            }
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showViewsDesc)));
        this.setFetchTask(this.createFetchTask(showViewsDesc.getSchema()));
    }

    private void analyzeShowMaterializedViews(ASTNode ast) throws SemanticException {
        ShowTablesDesc showMaterializedViewsDesc;
        String dbName = SessionState.get().getCurrentDatabase();
        String materializedViewNames = null;
        if (ast.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
        }
        switch (ast.getChildCount()) {
            case 1: {
                materializedViewNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                showMaterializedViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, materializedViewNames, TableType.MATERIALIZED_VIEW);
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 843);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                this.validateDatabase(dbName);
                showMaterializedViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                showMaterializedViewsDesc.setType(TableType.MATERIALIZED_VIEW);
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 843);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                materializedViewNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                this.validateDatabase(dbName);
                showMaterializedViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, materializedViewNames, TableType.MATERIALIZED_VIEW);
                break;
            }
            default: {
                showMaterializedViewsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                showMaterializedViewsDesc.setType(TableType.MATERIALIZED_VIEW);
            }
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showMaterializedViewsDesc)));
        this.setFetchTask(this.createFetchTask(showMaterializedViewsDesc.getSchema()));
    }

    private void analyzeLockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0)).toLowerCase();
        String mode = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText().toUpperCase());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        LockTableDesc lockTblDesc = new LockTableDesc(tableName, mode, partSpec, HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYID));
        lockTblDesc.setQueryStr(this.ctx.getCmd());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), lockTblDesc)));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeShowCompactions(ASTNode ast) throws SemanticException {
        ShowCompactionsDesc desc = new ShowCompactionsDesc(this.ctx.getResFile());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
    }

    private void analyzeShowTxns(ASTNode ast) throws SemanticException {
        ShowTxnsDesc desc = new ShowTxnsDesc(this.ctx.getResFile());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
    }

    private void analyzeAbortTxns(ASTNode ast) throws SemanticException {
        ArrayList<Long> txnids = new ArrayList<Long>();
        int numChildren = ast.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            txnids.add(Long.parseLong(ast.getChild(i).getText()));
        }
        AbortTxnsDesc desc = new AbortTxnsDesc(txnids);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void analyzeKillQuery(ASTNode ast) throws SemanticException {
        ArrayList<String> queryIds = new ArrayList<String>();
        int numChildren = ast.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            queryIds.add(DDLSemanticAnalyzer.stripQuotes(ast.getChild(i).getText()));
        }
        this.addServiceOutput();
        KillQueryDesc desc = new KillQueryDesc(queryIds);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void addServiceOutput() throws SemanticException {
        String hs2Hostname = this.getHS2Host();
        if (hs2Hostname != null) {
            this.outputs.add(new WriteEntity(hs2Hostname, Entity.Type.SERVICE_NAME));
        }
    }

    private String getHS2Host() throws SemanticException {
        if (SessionState.get().isHiveServerQuery()) {
            return SessionState.get().getHiveServer2Host();
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_AUTHORIZATION_SQLSTD_HS2_MODE)) {
            return "dummyHostnameForTest";
        }
        throw new SemanticException("Kill query is only supported in HiveServer2 (not hive cli)");
    }

    private void analyzeUnlockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        UnlockTableDesc unlockTblDesc = new UnlockTableDesc(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), unlockTblDesc)));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeLockDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String mode = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText().toUpperCase());
        this.inputs.add(new ReadEntity(this.getDatabase(dbName)));
        this.outputs.add(new WriteEntity(this.getDatabase(dbName), WriteEntity.WriteType.DDL_NO_LOCK));
        LockDatabaseDesc lockDatabaseDesc = new LockDatabaseDesc(dbName, mode, HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYID));
        lockDatabaseDesc.setQueryStr(this.ctx.getCmd());
        DDLWork work = new DDLWork(this.getInputs(), this.getOutputs(), lockDatabaseDesc);
        this.rootTasks.add(TaskFactory.get(work));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeUnlockDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        this.inputs.add(new ReadEntity(this.getDatabase(dbName)));
        this.outputs.add(new WriteEntity(this.getDatabase(dbName), WriteEntity.WriteType.DDL_NO_LOCK));
        UnlockDatabaseDesc unlockDatabaseDesc = new UnlockDatabaseDesc(dbName);
        DDLWork work = new DDLWork(this.getInputs(), this.getOutputs(), unlockDatabaseDesc);
        this.rootTasks.add(TaskFactory.get(work));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeDescFunction(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        DescFunctionDesc descFuncDesc = new DescFunctionDesc(this.ctx.getResFile(), funcName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc)));
        this.setFetchTask(this.createFetchTask(descFuncDesc.getSchema()));
    }

    private void analyzeAlterTableRename(String[] source, ASTNode ast, boolean expectView) throws SemanticException {
        String[] target = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String sourceName = DDLSemanticAnalyzer.getDotName(source);
        String targetName = DDLSemanticAnalyzer.getDotName(target);
        AlterTableDesc alterTblDesc = new AlterTableDesc(sourceName, targetName, expectView, null);
        this.addInputsOutputsAlterTable(sourceName, null, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableRenameCol(String catName, String[] qualified, ASTNode ast, HashMap<String, String> partSpec) throws SemanticException {
        String newComment = null;
        boolean first = false;
        String flagCol = null;
        boolean isCascade = false;
        String oldColName = ast.getChild(0).getText();
        String newColName = ast.getChild(1).getText();
        String newType = DDLSemanticAnalyzer.getTypeStringFromAST((ASTNode)ast.getChild(2));
        ASTNode constraintChild = null;
        int childCount = ast.getChildCount();
        block15: for (int i = 3; i < childCount; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            switch (child.getToken().getType()) {
                case 380: {
                    newComment = DDLSemanticAnalyzer.unescapeSQLString(child.getText());
                    continue block15;
                }
                case 727: {
                    flagCol = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    continue block15;
                }
                case 132: {
                    first = true;
                    continue block15;
                }
                case 773: {
                    isCascade = true;
                    continue block15;
                }
                case 975: {
                    continue block15;
                }
                default: {
                    constraintChild = child;
                }
            }
        }
        ArrayList<SQLPrimaryKey> primaryKeys = null;
        ArrayList<SQLForeignKey> foreignKeys = null;
        ArrayList<SQLUniqueConstraint> uniqueConstraints = null;
        ArrayList<SQLNotNullConstraint> notNullConstraints = null;
        ArrayList<SQLDefaultConstraint> defaultConstraints = null;
        ArrayList<SQLCheckConstraint> checkConstraints = null;
        if (constraintChild != null) {
            switch (constraintChild.getToken().getType()) {
                case 776: {
                    checkConstraints = new ArrayList<SQLCheckConstraint>();
                    DDLSemanticAnalyzer.processCheckConstraints(catName, qualified[0], qualified[1], constraintChild, ImmutableList.of(newColName), checkConstraints, (ASTNode)ast.getChild(2), this.ctx.getTokenRewriteStream());
                    break;
                }
                case 807: {
                    defaultConstraints = new ArrayList<SQLDefaultConstraint>();
                    DDLSemanticAnalyzer.processDefaultConstraints(catName, qualified[0], qualified[1], constraintChild, ImmutableList.of(newColName), defaultConstraints, (ASTNode)ast.getChild(2), this.ctx.getTokenRewriteStream());
                    break;
                }
                case 902: {
                    notNullConstraints = new ArrayList<SQLNotNullConstraint>();
                    DDLSemanticAnalyzer.processNotNullConstraints(catName, qualified[0], qualified[1], constraintChild, ImmutableList.of(newColName), notNullConstraints);
                    break;
                }
                case 1088: {
                    uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
                    DDLSemanticAnalyzer.processUniqueConstraints(catName, qualified[0], qualified[1], constraintChild, ImmutableList.of(newColName), uniqueConstraints);
                    break;
                }
                case 940: {
                    primaryKeys = new ArrayList<SQLPrimaryKey>();
                    DDLSemanticAnalyzer.processPrimaryKeys(qualified[0], qualified[1], constraintChild, ImmutableList.of(newColName), primaryKeys);
                    break;
                }
                case 842: {
                    foreignKeys = new ArrayList<SQLForeignKey>();
                    DDLSemanticAnalyzer.processForeignKeys(qualified[0], qualified[1], constraintChild, foreignKeys);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.NOT_RECOGNIZED_CONSTRAINT.getMsg(constraintChild.getToken().getText()));
                }
            }
        }
        Table tab = this.getTable(qualified);
        if (checkConstraints != null && !checkConstraints.isEmpty()) {
            DDLSemanticAnalyzer.validateCheckConstraint(tab.getCols(), checkConstraints, this.ctx.getConf());
        }
        if (tab.getTableType() == TableType.EXTERNAL_TABLE && this.hasEnabledOrValidatedConstraints(notNullConstraints, defaultConstraints, checkConstraints)) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Constraints are disallowed with External tables. Only RELY is allowed."));
        }
        SkewedInfo skewInfo = tab.getTTable().getSd().getSkewedInfo();
        if (null != skewInfo && null != skewInfo.getSkewedColNames() && skewInfo.getSkewedColNames().contains(oldColName)) {
            throw new SemanticException(oldColName + ErrorMsg.ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN.getMsg());
        }
        String tblName = DDLSemanticAnalyzer.getDotName(qualified);
        AlterTableDesc alterTblDesc = primaryKeys == null && foreignKeys == null && uniqueConstraints == null && notNullConstraints == null && defaultConstraints == null && checkConstraints == null ? new AlterTableDesc(tblName, partSpec, DDLSemanticAnalyzer.unescapeIdentifier(oldColName), DDLSemanticAnalyzer.unescapeIdentifier(newColName), newType, newComment, first, flagCol, isCascade) : new AlterTableDesc(tblName, partSpec, DDLSemanticAnalyzer.unescapeIdentifier(oldColName), DDLSemanticAnalyzer.unescapeIdentifier(newColName), newType, newComment, first, flagCol, isCascade, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
        this.addInputsOutputsAlterTable(tblName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableRenamePart(ASTNode ast, String tblName, HashMap<String, String> oldPartSpec) throws SemanticException {
        Table tab = this.getTable(tblName, true);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.RENAMEPARTITION);
        HashMap<String, String> newPartSpec = DDLSemanticAnalyzer.getValidatedPartSpec(tab, (ASTNode)ast.getChild(0), this.conf, false);
        if (newPartSpec == null) {
            throw new SemanticException("RENAME PARTITION Missing Destination" + ast);
        }
        ReadEntity re = new ReadEntity(tab);
        re.noLockNeeded();
        this.inputs.add(re);
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        partSpecs.add(oldPartSpec);
        partSpecs.add(newPartSpec);
        this.addTablePartsOutputs(tab, partSpecs, WriteEntity.WriteType.DDL_EXCLUSIVE);
        RenamePartitionDesc renamePartitionDesc = new RenamePartitionDesc(tblName, oldPartSpec, newPartSpec, null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), renamePartitionDesc)));
    }

    private void analyzeAlterTableBucketNum(ASTNode ast, String tblName, HashMap<String, String> partSpec) throws SemanticException {
        Table tab = this.getTable(tblName, true);
        if (tab.getBucketCols() == null || tab.getBucketCols().isEmpty()) {
            throw new SemanticException(ErrorMsg.ALTER_BUCKETNUM_NONBUCKETIZED_TBL.getMsg());
        }
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ALTERBUCKETNUM);
        this.inputs.add(new ReadEntity(tab));
        int bucketNum = Integer.parseInt(ast.getChild(0).getText());
        AlterTableDesc alterBucketNum = new AlterTableDesc(tblName, partSpec, bucketNum);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterBucketNum)));
    }

    private void analyzeAlterTableModifyCols(String[] qualified, ASTNode ast, HashMap<String, String> partSpec, AlterTableDesc.AlterTableTypes alterType) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getDotName(qualified);
        List<FieldSchema> newCols = this.getColumns((ASTNode)ast.getChild(0));
        boolean isCascade = false;
        if (null != ast.getFirstChildWithType(773)) {
            isCascade = true;
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, partSpec, newCols, alterType, isCascade);
        this.addInputsOutputsAlterTable(tblName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void analyzeAlterTableDropParts(String[] qualified, ASTNode ast, boolean expectView) throws SemanticException {
        boolean ifExists;
        boolean canGroupExprs = ifExists = ast.getFirstChildWithType(858) != null || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        boolean mustPurge = ast.getFirstChildWithType(240) != null;
        ReplicationSpec replicationSpec = new ReplicationSpec(ast);
        Table tab = null;
        try {
            tab = this.getTable(qualified);
        }
        catch (SemanticException se) {
            if (replicationSpec.isInReplicationScope() && (se.getCause() instanceof InvalidTableException || se.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg()))) {
                return;
            }
            throw se;
        }
        Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = this.getFullPartitionSpecs(ast, tab, canGroupExprs);
        if (partSpecs.isEmpty()) {
            return;
        }
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.DROPPARTITION, expectView);
        ReadEntity re = new ReadEntity(tab);
        re.noLockNeeded();
        this.inputs.add(re);
        this.addTableDropPartsOutputs(tab, partSpecs.values(), !ifExists);
        DropTableDesc dropTblDesc = new DropTableDesc(DDLSemanticAnalyzer.getDotName(qualified), partSpecs, expectView ? TableType.VIRTUAL_VIEW : null, mustPurge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc)));
    }

    private void analyzeAlterTablePartColType(String[] qualified, ASTNode ast) throws SemanticException {
        Table tab = this.getTable(qualified);
        this.inputs.add(new ReadEntity(tab));
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ALTERPARTITION, false);
        ASTNode colAst = (ASTNode)ast.getChild(0);
        FieldSchema newCol = new FieldSchema();
        String name = colAst.getChild(0).getText().toLowerCase();
        newCol.setName(DDLSemanticAnalyzer.unescapeIdentifier(name));
        ASTNode typeChild = (ASTNode)colAst.getChild(1);
        newCol.setType(DDLSemanticAnalyzer.getTypeStringFromAST(typeChild));
        if (colAst.getChildCount() == 3) {
            newCol.setComment(DDLSemanticAnalyzer.unescapeSQLString(colAst.getChild(2).getText()));
        }
        boolean fFoundColumn = false;
        for (FieldSchema col : tab.getTTable().getPartitionKeys()) {
            if (col.getName().compareTo(newCol.getName()) != 0) continue;
            fFoundColumn = true;
        }
        if (!fFoundColumn) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(newCol.getName()));
        }
        AlterTableAlterPartDesc alterTblAlterPartDesc = new AlterTableAlterPartDesc(DDLSemanticAnalyzer.getDotName(qualified), newCol);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblAlterPartDesc)));
    }

    private void analyzeAlterTableAddParts(String[] qualified, CommonTree ast, boolean expectView) throws SemanticException {
        boolean ifNotExists = ast.getChild(0).getType() == 859;
        Table tab = this.getTable(qualified);
        boolean isView = tab.isView();
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ADDPARTITION, expectView);
        this.outputs.add(new WriteEntity(tab, ifNotExists && AcidUtils.isTransactionalTable(tab) ? WriteEntity.WriteType.DDL_EXCLUSIVE : WriteEntity.WriteType.DDL_SHARED));
        int numCh = ast.getChildCount();
        int start = ifNotExists ? 1 : 0;
        String currentLocation = null;
        HashMap<String, String> currentPart = null;
        AddPartitionDesc addPartitionDesc = new AddPartitionDesc(tab.getDbName(), tab.getTableName(), ifNotExists);
        block4: for (int num = start; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 936: {
                    if (currentPart != null) {
                        addPartitionDesc.addPartition(currentPart, currentLocation);
                        currentLocation = null;
                    }
                    currentPart = DDLSemanticAnalyzer.getValidatedPartSpec(tab, child, this.conf, true);
                    this.validatePartitionValues(currentPart);
                    continue block4;
                }
                case 935: {
                    if (isView) {
                        throw new SemanticException("LOCATION clause illegal for view partition");
                    }
                    currentLocation = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    this.inputs.add(this.toReadEntity(currentLocation));
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            addPartitionDesc.addPartition(currentPart, currentLocation);
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            for (int index = 0; index < addPartitionDesc.getPartitionCount(); ++index) {
                AddPartitionDesc.OnePartitionDesc desc = addPartitionDesc.getPartition(index);
                if (desc.getLocation() != null) continue;
                if (desc.getPartParams() == null) {
                    desc.setPartParams(new HashMap<String, String>());
                }
                StatsSetupConst.setStatsStateForCreateTable(desc.getPartParams(), MetaStoreUtils.getColumnNames(tab.getCols()), "true");
            }
        }
        if (addPartitionDesc.getPartitionCount() == 0) {
            return;
        }
        Task<DDLWork> ddlTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc));
        this.rootTasks.add(ddlTask);
        this.handleTransactionalTable(tab, addPartitionDesc, ddlTask);
        if (isView) {
            StringBuilder cmd = new StringBuilder();
            cmd.append("SELECT * FROM ");
            cmd.append(HiveUtils.unparseIdentifier(DDLSemanticAnalyzer.getDotName(qualified)));
            cmd.append(" WHERE ");
            boolean firstOr = true;
            for (int i = 0; i < addPartitionDesc.getPartitionCount(); ++i) {
                AddPartitionDesc.OnePartitionDesc partitionDesc = addPartitionDesc.getPartition(i);
                if (firstOr) {
                    firstOr = false;
                } else {
                    cmd.append(" OR ");
                }
                boolean firstAnd = true;
                cmd.append("(");
                for (Map.Entry<String, String> entry : partitionDesc.getPartSpec().entrySet()) {
                    if (firstAnd) {
                        firstAnd = false;
                    } else {
                        cmd.append(" AND ");
                    }
                    cmd.append(HiveUtils.unparseIdentifier(entry.getKey()));
                    cmd.append(" = '");
                    cmd.append(HiveUtils.escapeString(entry.getValue()));
                    cmd.append("'");
                }
                cmd.append(")");
            }
            SessionState ss = SessionState.get();
            String uName = ss == null ? null : ss.getUserName();
            Driver driver = new Driver(this.conf, uName, this.queryState.getLineageState());
            int rc = driver.compile(cmd.toString(), false);
            if (rc != 0) {
                throw new SemanticException(ErrorMsg.NO_VALID_PARTN.getMsg());
            }
            this.inputs.addAll(driver.getPlan().getInputs());
        }
    }

    private void handleTransactionalTable(Table tab, AddPartitionDesc addPartitionDesc, Task ddlTask) throws SemanticException {
        if (!AcidUtils.isTransactionalTable(tab)) {
            return;
        }
        Long writeId = null;
        int stmtId = 0;
        for (int index = 0; index < addPartitionDesc.getPartitionCount(); ++index) {
            Partition oldPart;
            AddPartitionDesc.OnePartitionDesc desc = addPartitionDesc.getPartition(index);
            if (desc.getLocation() == null || addPartitionDesc.isIfNotExists() && (oldPart = this.getPartition(tab, desc.getPartSpec(), false)) != null) continue;
            if (writeId == null) {
                try {
                    writeId = this.getTxnMgr().getTableWriteId(tab.getDbName(), tab.getTableName());
                }
                catch (LockException ex) {
                    throw new SemanticException("Failed to allocate the write id", ex);
                }
                stmtId = this.getTxnMgr().getStmtIdAndIncrement();
            }
            LoadTableDesc loadTableWork = new LoadTableDesc(new Path(desc.getLocation()), Utilities.getTableDesc(tab), desc.getPartSpec(), LoadTableDesc.LoadFileType.KEEP_EXISTING, writeId);
            loadTableWork.setStmtId(stmtId);
            loadTableWork.setInheritTableSpecs(true);
            try {
                desc.setLocation(new Path(tab.getDataLocation(), Warehouse.makePartPath(desc.getPartSpec())).toString());
            }
            catch (MetaException ex) {
                throw new SemanticException("Could not determine partition path due to: " + ex.getMessage(), (Throwable)((Object)ex));
            }
            Task<MoveWork> moveTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, true, false));
            ddlTask.addDependentTask(moveTask);
        }
    }

    private void analyzeAlterTableTouch(String[] qualified, CommonTree ast) throws SemanticException {
        Table tab = this.getTable(qualified);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.TOUCH);
        this.inputs.add(new ReadEntity(tab));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(tab, ast);
        if (partSpecs.size() == 0) {
            AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(DDLSemanticAnalyzer.getDotName(qualified), null, AlterTableDesc.AlterTableTypes.TOUCH);
            this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_NO_LOCK));
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc)));
        } else {
            this.addTablePartsOutputs(tab, partSpecs, WriteEntity.WriteType.DDL_NO_LOCK);
            for (Map<String, String> partSpec : partSpecs) {
                AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(DDLSemanticAnalyzer.getDotName(qualified), partSpec, AlterTableDesc.AlterTableTypes.TOUCH);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc)));
            }
        }
    }

    private void analyzeAlterTableArchive(String[] qualified, CommonTree ast, boolean isUnArchive) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEARCHIVEENABLED)) {
            throw new SemanticException(ErrorMsg.ARCHIVE_METHODS_DISABLED.getMsg());
        }
        Table tab = this.getTable(qualified);
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(tab, ast);
        this.addTablePartsOutputs(tab, partSpecs, true, WriteEntity.WriteType.DDL_NO_LOCK);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.inputs.add(new ReadEntity(tab));
        if (partSpecs.size() > 1) {
            throw new SemanticException(isUnArchive ? ErrorMsg.UNARCHIVE_ON_MULI_PARTS.getMsg() : ErrorMsg.ARCHIVE_ON_MULI_PARTS.getMsg());
        }
        if (partSpecs.size() == 0) {
            throw new SemanticException(ErrorMsg.ARCHIVE_ON_TABLE.getMsg());
        }
        Map<String, String> partSpec = partSpecs.get(0);
        try {
            this.isValidPrefixSpec(tab, partSpec);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        AlterTableSimpleDesc archiveDesc = new AlterTableSimpleDesc(DDLSemanticAnalyzer.getDotName(qualified), partSpec, isUnArchive ? AlterTableDesc.AlterTableTypes.UNARCHIVE : AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), archiveDesc)));
    }

    private static boolean isMsckAddPartition(int keyWord) {
        switch (keyWord) {
            case 109: {
                return false;
            }
        }
        return true;
    }

    private static boolean isMsckDropPartition(int keyWord) {
        switch (keyWord) {
            case 109: 
            case 301: {
                return true;
            }
        }
        return false;
    }

    private void analyzeMetastoreCheck(CommonTree ast) throws SemanticException {
        String tableName = null;
        boolean addPartitions = true;
        boolean dropPartitions = false;
        boolean repair = false;
        if (ast.getChildCount() > 0) {
            boolean bl = repair = ast.getChild(0).getType() == 257;
            if (!repair) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                if (ast.getChildCount() > 1) {
                    addPartitions = DDLSemanticAnalyzer.isMsckAddPartition(ast.getChild(1).getType());
                    dropPartitions = DDLSemanticAnalyzer.isMsckDropPartition(ast.getChild(1).getType());
                }
            } else if (ast.getChildCount() > 1) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
                if (ast.getChildCount() > 2) {
                    addPartitions = DDLSemanticAnalyzer.isMsckAddPartition(ast.getChild(2).getType());
                    dropPartitions = DDLSemanticAnalyzer.isMsckDropPartition(ast.getChild(2).getType());
                }
            }
        }
        Table tab = this.getTable(tableName);
        List<Map<String, String>> specs = this.getPartitionSpecs(tab, ast);
        this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_SHARED));
        MsckDesc checkDesc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair, addPartitions, dropPartitions);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), checkDesc)));
    }

    private List<Map<String, String>> getPartitionSpecs(Table tbl, CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            ASTNode partSpecNode = (ASTNode)ast.getChild(childIndex);
            if (partSpecNode.getType() != 936) continue;
            HashMap<String, String> partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(tbl, partSpecNode, this.conf, false);
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    private Map<Integer, List<ExprNodeGenericFuncDesc>> getFullPartitionSpecs(CommonTree ast, Table tab, boolean canGroupExprs) throws SemanticException {
        String defaultPartitionName = HiveConf.getVar(this.conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        HashMap<String, String> colTypes = new HashMap<String, String>();
        for (FieldSchema fs : tab.getPartitionKeys()) {
            colTypes.put(fs.getName().toLowerCase(), fs.getType());
        }
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> result = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        for (int childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partSpecTree = ast.getChild(childIndex);
            if (partSpecTree.getType() != 936) continue;
            ExprNodeGenericFuncDesc expr = null;
            HashSet<String> names = new HashSet<String>(partSpecTree.getChildCount());
            for (int i = 0; i < partSpecTree.getChildCount(); ++i) {
                ExprNodeGenericFuncDesc op;
                CommonTree partSpecSingleKey = (CommonTree)partSpecTree.getChild(i);
                assert (partSpecSingleKey.getType() == 937);
                String key = DDLSemanticAnalyzer.stripIdentifierQuotes(partSpecSingleKey.getChild(0).getText()).toLowerCase();
                String operator = partSpecSingleKey.getChild(1).getText();
                ASTNode partValNode = (ASTNode)partSpecSingleKey.getChild(2);
                TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
                ExprNodeConstantDesc valExpr = (ExprNodeConstantDesc)TypeCheckProcFactory.genExprNode(partValNode, typeCheckCtx).get(partValNode);
                Object val = valExpr.getValue();
                boolean isDefaultPartitionName = val.equals(defaultPartitionName);
                String type = (String)colTypes.get(key);
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo(type);
                if (type == null) {
                    throw new SemanticException("Column " + key + " not found");
                }
                if (!isDefaultPartitionName && !valExpr.getTypeString().equals(type)) {
                    ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(valExpr.getTypeInfo()), TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(pti));
                    val = converter.convert(valExpr.getValue());
                }
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(pti, key, null, true);
                if (!isDefaultPartitionName) {
                    op = DDLSemanticAnalyzer.makeBinaryPredicate(operator, column, new ExprNodeConstantDesc(pti, val));
                } else {
                    String fnName;
                    GenericUDF originalOp = FunctionRegistry.getFunctionInfo(operator).getGenericUDF();
                    if (FunctionRegistry.isEq(originalOp)) {
                        fnName = "isnull";
                    } else if (FunctionRegistry.isNeq(originalOp)) {
                        fnName = "isnotnull";
                    } else {
                        throw new SemanticException("Cannot use " + operator + " in a default partition spec; only '=' and '!=' are allowed.");
                    }
                    op = DDLSemanticAnalyzer.makeUnaryPredicate(fnName, column);
                }
                expr = expr == null ? op : DDLSemanticAnalyzer.makeBinaryPredicate("and", expr, op);
                names.add(key);
            }
            if (expr == null) continue;
            int prefixLength = this.calculatePartPrefix(tab, names);
            List orExpr = (List)result.get(prefixLength);
            if (orExpr == null) {
                result.put(prefixLength, Lists.newArrayList(expr));
                continue;
            }
            if (canGroupExprs) {
                orExpr.set(0, DDLSemanticAnalyzer.makeBinaryPredicate("or", expr, (ExprNodeDesc)orExpr.get(0)));
                continue;
            }
            orExpr.add(expr);
        }
        return result;
    }

    public static ExprNodeGenericFuncDesc makeBinaryPredicate(String fn, ExprNodeDesc left, ExprNodeDesc right) throws SemanticException {
        return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo(fn).getGenericUDF(), Lists.newArrayList(left, right));
    }

    public static ExprNodeGenericFuncDesc makeUnaryPredicate(String fn, ExprNodeDesc arg) throws SemanticException {
        return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo(fn).getGenericUDF(), Lists.newArrayList(arg));
    }

    private int calculatePartPrefix(Table tbl, HashSet<String> partSpecKeys) {
        int partPrefixToDrop = 0;
        for (FieldSchema fs : tbl.getPartCols()) {
            if (!partSpecKeys.contains(fs.getName())) break;
            ++partPrefixToDrop;
        }
        return partPrefixToDrop;
    }

    private void validatePartitionValues(Map<String, String> partSpec) throws SemanticException {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : this.reservedPartitionValues) {
                String value = e.getValue();
                if (value == null || !value.contains(s)) continue;
                throw new SemanticException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    private void addTablePartsOutputs(Table table, List<Map<String, String>> partSpecs, WriteEntity.WriteType writeType) throws SemanticException {
        this.addTablePartsOutputs(table, partSpecs, false, false, null, writeType);
    }

    private void addTablePartsOutputs(Table table, List<Map<String, String>> partSpecs, boolean allowMany, WriteEntity.WriteType writeType) throws SemanticException {
        this.addTablePartsOutputs(table, partSpecs, false, allowMany, null, writeType);
    }

    private void addTablePartsOutputs(Table table, List<Map<String, String>> partSpecs, boolean throwIfNonExistent, boolean allowMany, ASTNode ast, WriteEntity.WriteType writeType) throws SemanticException {
        Iterator<Map<String, String>> i = partSpecs.iterator();
        int index = 1;
        while (i.hasNext()) {
            Map<String, String> partSpec = i.next();
            List<Object> parts = null;
            if (allowMany) {
                try {
                    parts = this.db.getPartitions(table, partSpec);
                }
                catch (HiveException e) {
                    LOG.error("Got HiveException during obtaining list of partitions" + StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
            }
            parts = new ArrayList();
            try {
                Partition p = this.db.getPartition(table, partSpec, false);
                if (p != null) {
                    parts.add(p);
                }
            }
            catch (HiveException e) {
                LOG.debug("Wrong specification" + StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
            if (parts.isEmpty() && throwIfNonExistent) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(index)));
            }
            for (Partition partition : parts) {
                this.outputs.add(new WriteEntity(partition, writeType));
            }
            ++index;
        }
    }

    private void addTableDropPartsOutputs(Table tab, Collection<List<ExprNodeGenericFuncDesc>> partSpecs, boolean throwIfNonExistent) throws SemanticException {
        for (List<ExprNodeGenericFuncDesc> specs : partSpecs) {
            for (ExprNodeGenericFuncDesc partSpec : specs) {
                ArrayList<Partition> parts = new ArrayList<Partition>();
                boolean hasUnknown = false;
                try {
                    hasUnknown = this.db.getPartitionsByExpr(tab, partSpec, this.conf, parts);
                }
                catch (Exception e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.getExprString()), e);
                }
                if (hasUnknown) {
                    throw new SemanticException("Unexpected unknown partitions for " + partSpec.getExprString());
                }
                if (parts.isEmpty() && throwIfNonExistent) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.getExprString()));
                }
                for (Partition p : parts) {
                    this.outputs.add(new WriteEntity(p, WriteEntity.WriteType.DDL_EXCLUSIVE));
                }
            }
        }
    }

    private void analyzeAltertableSkewedby(String[] qualified, ASTNode ast) throws SemanticException {
        HiveConf hiveConf = SessionState.get().getConf();
        Table tab = this.getTable(qualified);
        this.inputs.add(new ReadEntity(tab));
        this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_EXCLUSIVE));
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ADDSKEWEDBY);
        String tableName = DDLSemanticAnalyzer.getDotName(qualified);
        if (ast.getChildCount() == 0) {
            AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, true, new ArrayList<String>(), new ArrayList<List<String>>());
            alterTblDesc.setStoredAsSubDirectories(false);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
        } else {
            switch (((ASTNode)ast.getChild(0)).getToken().getType()) {
                case 1059: {
                    this.handleAlterTableSkewedBy(ast, tableName, tab);
                    break;
                }
                case 1025: {
                    this.handleAlterTableDisableStoredAsDirs(tableName, tab);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void handleAlterTableDisableStoredAsDirs(String tableName, Table tab) throws SemanticException {
        List<String> skewedColNames = tab.getSkewedColNames();
        List<List<String>> skewedColValues = tab.getSkewedColValues();
        if (skewedColNames == null || skewedColNames.size() == 0 || skewedColValues == null || skewedColValues.size() == 0) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_STOREDASDIR_NOT_SKEWED.getMsg(tableName));
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, false, skewedColNames, skewedColValues);
        alterTblDesc.setStoredAsSubDirectories(false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void handleAlterTableSkewedBy(ASTNode ast, String tableName, Table tab) throws SemanticException {
        List<String> skewedColNames = new ArrayList<String>();
        ArrayList<List<String>> skewedValues = new ArrayList<List<String>>();
        ASTNode skewedNode = (ASTNode)ast.getChild(0);
        skewedColNames = this.analyzeSkewedTablDDLColNames(skewedColNames, skewedNode);
        this.analyzeDDLSkewedValues(skewedValues, skewedNode);
        boolean storedAsDirs = this.analyzeStoredAdDirs(skewedNode);
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, false, skewedColNames, skewedValues);
        alterTblDesc.setStoredAsSubDirectories(storedAsDirs);
        alterTblDesc.setTable(tab);
        alterTblDesc.validate();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private List<String> analyzeAlterTableSkewedColNames(List<String> skewedColNames, ASTNode child) throws SemanticException {
        Tree nNode = child.getChild(0);
        if (nNode == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        ASTNode nAstNode = (ASTNode)nNode;
        if (nAstNode.getToken().getType() != 1040) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        skewedColNames = DDLSemanticAnalyzer.getColumnNames(nAstNode);
        return skewedColNames;
    }

    private List<String> getColumnValues(ASTNode ast) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            colList.add(DDLSemanticAnalyzer.stripQuotes(child.getText()).toLowerCase());
        }
        return colList;
    }

    private void analyzeAlterTableSkewedLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HiveConf hiveConf = SessionState.get().getConf();
        HashMap<List<String>, String> locations = new HashMap<List<String>, String>();
        List locNodes = ast.getChildren();
        if (null == locNodes) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
        }
        for (Node locNode : locNodes) {
            ASTNode locAstNode = (ASTNode)locNode;
            List locListNodes = locAstNode.getChildren();
            if (null == locListNodes) {
                throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
            }
            for (Node locListNode : locListNodes) {
                ASTNode locListAstNode = (ASTNode)locListNode;
                List locMapNodes = locListAstNode.getChildren();
                if (null == locMapNodes) {
                    throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
                }
                for (Node locMapNode : locMapNodes) {
                    ASTNode locMapAstNode = (ASTNode)locMapNode;
                    List locMapAstNodeMaps = locMapAstNode.getChildren();
                    if (null == locMapAstNodeMaps || ((ArrayList)locMapAstNodeMaps).size() != 2) {
                        throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_MAP.getMsg());
                    }
                    List<Object> keyList = new LinkedList();
                    ASTNode node = (ASTNode)((ArrayList)locMapAstNodeMaps).get(0);
                    if (node.getToken().getType() == 1042) {
                        keyList = this.getSkewedValuesFromASTNode(node);
                    } else if (this.isConstant(node)) {
                        keyList.add(PlanUtils.stripQuotes(node.getText()));
                    } else {
                        throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
                    }
                    String newLocation = PlanUtils.stripQuotes(DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)((ArrayList)locMapAstNodeMaps).get(1)).getText()));
                    this.validateSkewedLocationString(newLocation);
                    locations.put(keyList, newLocation);
                    this.addLocationToOutputs(newLocation);
                }
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, locations, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private void addLocationToOutputs(String newLocation) throws SemanticException {
        this.outputs.add(this.toWriteEntity(newLocation));
    }

    private boolean isConstant(ASTNode node) {
        switch (node.getToken().getType()) {
            case 13: 
            case 26: 
            case 127: 
            case 319: 
            case 368: 
            case 369: 
            case 380: {
                return true;
            }
        }
        return false;
    }

    private void validateSkewedLocationString(String newLocation) throws SemanticException {
        try {
            URI locUri = new URI(newLocation);
            if (!locUri.isAbsolute() || locUri.getScheme() == null || locUri.getScheme().trim().equals("")) {
                throw new SemanticException(newLocation + " is not absolute or has no scheme information. Please specify a complete absolute uri with scheme information.");
            }
        }
        catch (URISyntaxException e) {
            throw new SemanticException(e);
        }
    }

    private HiveAuthorizationTaskFactory createAuthorizationTaskFactory(HiveConf conf, Hive db) {
        Class authProviderClass = conf.getClass(HiveConf.ConfVars.HIVE_AUTHORIZATION_TASK_FACTORY.varname, HiveAuthorizationTaskFactoryImpl.class, HiveAuthorizationTaskFactory.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor constructor = authProviderClass.getConstructor(HiveConf.class, Hive.class);
            return (HiveAuthorizationTaskFactory)constructor.newInstance(new Object[]{conf, db});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    private void analyzeAlterMaterializedViewRewrite(String mvName, ASTNode ast) throws SemanticException {
        boolean enableFlag;
        switch (ast.getChild(0).getType()) {
            case 979: {
                enableFlag = true;
                break;
            }
            case 978: {
                enableFlag = false;
                break;
            }
            default: {
                throw new SemanticException("Invalid alter materialized view expression");
            }
        }
        AlterMaterializedViewDesc alterMVDesc = new AlterMaterializedViewDesc(AlterMaterializedViewDesc.AlterMaterializedViewTypes.UPDATE_REWRITE_FLAG);
        alterMVDesc.setMaterializedViewName(mvName);
        alterMVDesc.setRewriteEnableFlag(enableFlag);
        Table materializedViewTable = this.getTable(mvName, true);
        if (enableFlag) {
            for (String tableName : materializedViewTable.getCreationMetadata().getTablesUsed()) {
                Table table = this.getTable(tableName, true);
                if (AcidUtils.isTransactionalTable(table)) continue;
                throw new SemanticException("Automatic rewriting for materialized view cannot be enabled if the materialized view uses non-transactional tables");
            }
        }
        this.inputs.add(new ReadEntity(materializedViewTable));
        this.outputs.add(new WriteEntity(materializedViewTable, WriteEntity.WriteType.DDL_EXCLUSIVE));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterMVDesc)));
    }

    static {
        TokenToTypeName.put(771, "boolean");
        TokenToTypeName.put(1075, "tinyint");
        TokenToTypeName.put(1021, "smallint");
        TokenToTypeName.put(864, "int");
        TokenToTypeName.put(768, "bigint");
        TokenToTypeName.put(841, "float");
        TokenToTypeName.put(818, "double");
        TokenToTypeName.put(1026, "string");
        TokenToTypeName.put(774, "char");
        TokenToTypeName.put(1100, "varchar");
        TokenToTypeName.put(769, "binary");
        TokenToTypeName.put(799, "date");
        TokenToTypeName.put(801, "datetime");
        TokenToTypeName.put(1071, "timestamp");
        TokenToTypeName.put(1073, "timestamp with local time zone");
        TokenToTypeName.put(875, "interval_year_month");
        TokenToTypeName.put(868, "interval_day_time");
        TokenToTypeName.put(805, "decimal");
    }

    static class QualifiedNameUtil {
        static final String delimiter = "\\.";

        QualifiedNameUtil() {
        }

        public static String getFullyQualifiedName(ASTNode ast) {
            if (ast.getChildCount() == 0) {
                return ast.getText();
            }
            if (ast.getChildCount() == 2) {
                return QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(1));
            }
            if (ast.getChildCount() == 3) {
                return QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(1)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(2));
            }
            return null;
        }

        public static String getColPath(Hive db, ASTNode node, String dbName, String tableName, Map<String, String> partSpec) throws SemanticException {
            if (node.getChildCount() == 1) {
                return tableName;
            }
            ASTNode columnNode = null;
            if (node.getChildCount() > 1) {
                columnNode = partSpec == null ? (ASTNode)node.getChild(1) : (ASTNode)node.getChild(2);
            }
            if (columnNode != null) {
                if (dbName == null) {
                    return tableName + "." + QualifiedNameUtil.getFullyQualifiedName(columnNode);
                }
                return tableName.substring(dbName.length() + 1, tableName.length()) + "." + QualifiedNameUtil.getFullyQualifiedName(columnNode);
            }
            return tableName;
        }

        public static Map<String, String> getPartitionSpec(Hive db, ASTNode ast, String tableName) throws SemanticException {
            ASTNode partNode = null;
            if (ast.getChildCount() == 1) {
                return null;
            }
            if (ast.getChildCount() > 2 && ((ASTNode)ast.getChild(1)).getType() != 936) {
                throw new SemanticException(((ASTNode)ast.getChild(1)).getType() + " is not a partition specification");
            }
            if (((ASTNode)ast.getChild(1)).getType() == 936) {
                partNode = (ASTNode)ast.getChild(1);
            }
            if (partNode != null) {
                Table tab = null;
                try {
                    tab = db.getTable(tableName);
                }
                catch (InvalidTableException e) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName), e);
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage(), e);
                }
                HashMap<String, String> partSpec = null;
                try {
                    partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(tab, partNode, db.getConf(), false);
                }
                catch (SemanticException e) {
                    return null;
                }
                if (partSpec != null) {
                    Partition part = null;
                    try {
                        part = db.getPartition(tab, partSpec, false);
                    }
                    catch (HiveException e) {
                        return null;
                    }
                    if (part == null) {
                        throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.toString()));
                    }
                    return partSpec;
                }
            }
            return null;
        }
    }
}

