/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionError;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSources;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.apache.hadoop.hive.ql.stats.OperatorStatsReaderHook;

public class ReOptimizePlugin
implements IReExecutionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ReOptimizePlugin.class);
    private boolean retryPossible;
    private Driver coreDriver;
    private OperatorStatsReaderHook statsReaderHook;
    private boolean alwaysCollectStats;

    @Override
    public void initialize(Driver driver) {
        this.coreDriver = driver;
        this.coreDriver.getHookRunner().addOnFailureHook(new LocalHook());
        this.statsReaderHook = new OperatorStatsReaderHook();
        this.coreDriver.getHookRunner().addOnFailureHook(this.statsReaderHook);
        this.coreDriver.getHookRunner().addPostHook(this.statsReaderHook);
        this.alwaysCollectStats = driver.getConf().getBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ALWAYS_COLLECT_OPERATOR_STATS);
        this.statsReaderHook.setCollectOnSuccess(this.alwaysCollectStats);
        this.coreDriver.setStatsSource(StatsSources.getStatsSource(driver.getConf()));
    }

    @Override
    public boolean shouldReExecute(int executionNum) {
        return this.retryPossible;
    }

    @Override
    public void prepareToReExecute() {
        this.statsReaderHook.setCollectOnSuccess(true);
        this.retryPossible = false;
        if (!this.alwaysCollectStats) {
            this.coreDriver.setStatsSource(StatsSources.getStatsSourceContaining(this.coreDriver.getStatsSource(), this.coreDriver.getPlanMapper()));
        }
    }

    @Override
    public boolean shouldReExecute(int executionNum, PlanMapper oldPlanMapper, PlanMapper newPlanMapper) {
        boolean planDidChange = !this.planEquals(oldPlanMapper, newPlanMapper);
        LOG.info("planDidChange: {}", (Object)planDidChange);
        return planDidChange;
    }

    private boolean planEquals(PlanMapper pmL, PlanMapper pmR) {
        List<Operator> opsL = this.getRootOps(pmL);
        List<Operator> opsR = this.getRootOps(pmR);
        Iterator<Operator> itL = opsL.iterator();
        block0: while (itL.hasNext()) {
            Operator opL = itL.next();
            Iterator<Operator> itR = opsR.iterator();
            while (itR.hasNext()) {
                Operator opR = itR.next();
                if (!opL.logicalEqualsTree(opR)) continue;
                itL.remove();
                itR.remove();
                continue block0;
            }
        }
        return opsL.isEmpty() && opsR.isEmpty();
    }

    private List<Operator> getRootOps(PlanMapper pmL) {
        List<Operator> ops = pmL.getAll(Operator.class);
        Iterator<Operator> iterator = ops.iterator();
        while (iterator.hasNext()) {
            Operator o = iterator.next();
            if (o.getNumChild() == 0) continue;
            iterator.remove();
        }
        return ops;
    }

    @Override
    public void beforeExecute(int executionIndex, boolean explainReOptimization) {
        if (explainReOptimization) {
            this.statsReaderHook.setCollectOnSuccess(true);
        }
    }

    @Override
    public void afterExecute(PlanMapper planMapper, boolean success) {
        if (this.alwaysCollectStats) {
            this.coreDriver.setStatsSource(StatsSources.getStatsSourceContaining(this.coreDriver.getStatsSource(), planMapper));
        }
    }

    class LocalHook
    implements ExecuteWithHookContext {
        LocalHook() {
        }

        @Override
        public void run(HookContext hookContext) throws Exception {
            if (hookContext.getHookType() == HookContext.HookType.ON_FAILURE_HOOK) {
                String message;
                Throwable exception = hookContext.getException();
                if (exception != null && (message = exception.getMessage()) != null) {
                    boolean isOOM;
                    boolean bl = isOOM = message.contains(MapJoinMemoryExhaustionError.class.getName()) || message.contains(OutOfMemoryError.class.getName());
                    if (message.contains("Vertex failed,") && isOOM) {
                        ReOptimizePlugin.this.retryPossible = true;
                    }
                }
                LOG.info("ReOptimization: retryPossible: {}", (Object)ReOptimizePlugin.this.retryPossible);
            }
        }
    }
}

