/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.$internal.org.apache.commons.codec.binary.Hex;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFParamUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="sha2", value="_FUNC_(string/binary, len) - Calculates the SHA-2 family of hash functions (SHA-224, SHA-256, SHA-384, and SHA-512).", extended="The first argument is the string or binary to be hashed. The second argument indicates the desired bit length of the result, which must have a value of 224, 256, 384, 512, or 0 (which is equivalent to 256). SHA-224 is supported starting from Java 8. If either argument is NULL or the hash length is not one of the permitted values, the return value is NULL.\nExample: > SELECT _FUNC_('ABC', 256);\n 'b5d4045c3f466fa91fe2cc6abe79232a1a57cdf104f7a26e716e0a1e2789df78'")
public class GenericUDFSha2
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private final Text output = new Text();
    private transient boolean isStr;
    private transient MessageDigest digest;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.BINARY_GROUP);
        this.checkArgGroups(arguments, 1, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP);
        if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputTypes[0]) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            this.obtainStringConverter(arguments, 0, this.inputTypes, this.converters);
            this.isStr = true;
        } else {
            GenericUDFParamUtils.obtainBinaryConverter(arguments, 0, this.inputTypes, this.converters);
            this.isStr = false;
        }
        if (arguments[1] instanceof ConstantObjectInspector) {
            Integer lenObj = this.getConstantIntValue(arguments, 1);
            if (lenObj != null) {
                int len = lenObj;
                if (len == 0) {
                    len = 256;
                }
                try {
                    this.digest = MessageDigest.getInstance("SHA-" + len);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
        } else {
            throw new UDFArgumentTypeException(1, this.getFuncName() + " only takes constant as " + this.getArgOrder(1) + " argument");
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.digest == null) {
            return null;
        }
        this.digest.reset();
        if (this.isStr) {
            Text n = GenericUDFParamUtils.getTextValue(arguments, 0, this.converters);
            if (n == null) {
                return null;
            }
            this.digest.update(n.getBytes(), 0, n.getLength());
        } else {
            BytesWritable bWr = GenericUDFParamUtils.getBinaryValue(arguments, 0, this.converters);
            if (bWr == null) {
                return null;
            }
            this.digest.update(bWr.getBytes(), 0, bWr.getLength());
        }
        byte[] resBin = this.digest.digest();
        String resStr = Hex.encodeHexString(resBin);
        this.output.set(resStr);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "sha2";
    }
}

