/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetIndex$$anonfun$kafka$log$OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011Q\"\u00112tiJ\f7\r^%oI\u0016D\b\u0002C\u0007\u0001\u0005\u0003\u0005\u000b\u0011\u0002\b\u0002\u000b}3\u0017\u000e\\3\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012AA5p\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\t\u0019KG.\u001a\u0005\n/\u0001\u0011\t\u0011)A\u00051y\t!BY1tK>3gm]3u!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0011auN\\4\n\u0005]Q\u0001\"\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011%\u00031i\u0017\r_%oI\u0016D8+\u001b>f!\tI\"%\u0003\u0002$5\t\u0019\u0011J\u001c;\n\u0005\u0001R\u0001\"\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014+\u0003!9(/\u001b;bE2,\u0007CA\r)\u0013\tI#DA\u0004C_>dW-\u00198\n\u0005\u0019R\u0001\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0003/_A\n$\u0007\u0005\u0002\n\u0001!)Qb\u000ba\u0001\u001d!)qc\u000ba\u00011!9\u0001e\u000bI\u0001\u0002\u0004\t\u0003b\u0002\u0014,!\u0003\u0005\ra\n\u0005\u0006i\u0001!\t%N\u0001\nK:$(/_*ju\u0016,\u0012!\t\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\r\u0002\u0017}c\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\u0006s\u0001!IAO\u0001\nY\u0006\u001cH/\u00128uef,\u0012a\u000f\t\u0003\u0013qJ!!\u0010\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\")q\b\u0001C\u0001\u0001\u0006QA.Y:u\u001f\u001a47/\u001a;\u0016\u0003aAQA\u0011\u0001\u0005\u0002\r\u000ba\u0001\\8pWV\u0004HCA\u001eE\u0011\u0015)\u0015\t1\u0001\u0019\u00031!\u0018M]4fi>3gm]3u\u0011\u00159\u0005\u0001\"\u0001I\u0003U1W\r^2i+B\u0004XM\u001d\"pk:$wJ\u001a4tKR$2!\u0013'O!\rI\"jO\u0005\u0003\u0017j\u0011aa\u00149uS>t\u0007\"B'G\u0001\u0004Y\u0014a\u00034fi\u000eDwJ\u001a4tKRDQa\u0014$A\u0002\u0005\n\u0011BZ3uG\"\u001c\u0016N_3\t\u000bE\u0003A\u0011\u0002*\u0002\u001dI,G.\u0019;jm\u0016|eMZ:fiR\u0019\u0011eU.\t\u000bQ\u0003\u0006\u0019A+\u0002\r\t,hMZ3s!\t1\u0016,D\u0001X\u0015\tA&#A\u0002oS>L!AW,\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003]!\u0002\u0007\u0011%A\u0001o\u0011\u0015q\u0006\u0001\"\u0003`\u0003!\u0001\b._:jG\u0006dGcA\u0011aC\")A+\u0018a\u0001+\")A,\u0018a\u0001C!)1\r\u0001C)I\u0006Q\u0001/\u0019:tK\u0016sGO]=\u0015\u0007m*g\rC\u0003UE\u0002\u0007Q\u000bC\u0003]E\u0002\u0007\u0011\u0005C\u0003i\u0001\u0011\u0005\u0011.A\u0003f]R\u0014\u0018\u0010\u0006\u0002<U\")Al\u001aa\u0001C!)A\u000e\u0001C\u0001[\u00061\u0011\r\u001d9f]\u0012$2A\\9t!\tIr.\u0003\u0002q5\t!QK\\5u\u0011\u0015\u00118\u000e1\u0001\u0019\u0003\u0019ygMZ:fi\")Ao\u001ba\u0001C\u0005A\u0001o\\:ji&|g\u000eC\u0003w\u0001\u0011\u0005s/\u0001\u0005ueVt7-\u0019;f)\u0005q\u0007\"B=\u0001\t\u0003R\u0018A\u0003;sk:\u001c\u0017\r^3U_R\u0011an\u001f\u0005\u0006eb\u0004\r\u0001\u0007\u0005\u0006{\u0002!IA`\u0001\u0012iJ,hnY1uKR{WI\u001c;sS\u0016\u001cHC\u00018\u0000\u0011\u0019\t\t\u0001 a\u0001C\u00059QM\u001c;sS\u0016\u001c\bBBA\u0003\u0001\u0011\u0005s/A\u0006tC:LG/_\"iK\u000e\\\u0007\u0002DA\u0005\u0001A\u0005\u0019\u0011!A\u0005\nU\"\u0013AE:va\u0016\u0014H%\\1y\u0013:$W\r_*ju\u0016DA\"!\u0004\u0001!\u0003\r\t\u0011!C\u0005\u0001z\t\u0001c];qKJ$#-Y:f\u001f\u001a47/\u001a;\b\u000f\u0005E!\u0001#\u0001\u0002\u0014\u0005YqJ\u001a4tKRLe\u000eZ3y!\rI\u0011Q\u0003\u0004\u0007\u0003\tA\t!a\u0006\u0014\r\u0005U\u0011\u0011DA\u0010!\rI\u00121D\u0005\u0004\u0003;Q\"AB!osJ+g\r\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)\u0003B\u0001\u0006kRLGn]\u0005\u0005\u0003S\t\u0019CA\u0004M_\u001e<\u0017N\\4\t\u000f1\n)\u0002\"\u0001\u0002.Q\u0011\u00111\u0003\u0005\u000b\u0003c\t)B1A\u0005B\u0005M\u0012A\u00037pO\u001e,'OT1nKV\u0011\u0011Q\u0007\t\u0005\u0003o\tiDD\u0002\u001a\u0003sI1!a\u000f\u001b\u0003\u0019\u0001&/\u001a3fM&!\u0011qHA!\u0005\u0019\u0019FO]5oO*\u0019\u00111\b\u000e\t\u0013\u0005\u0015\u0013Q\u0003Q\u0001\n\u0005U\u0012a\u00037pO\u001e,'OT1nK\u0002B!\"!\u0013\u0002\u0016E\u0005I\u0011AA&\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\n\u0016\u0004C\u0005=3FAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m#$\u0001\u0006b]:|G/\u0019;j_:LA!a\u0018\u0002V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\r\u0014QCI\u0001\n\u0003\t)'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003OR3aJA(\u0001")
public class OffsetIndex
extends AbstractIndex {
    public long kafka$log$OffsetIndex$$_lastOffset = this.kafka$log$OffsetIndex$$lastEntry().offset();

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        OffsetIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        OffsetIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        OffsetIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        OffsetIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        OffsetIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return OffsetIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return OffsetIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        OffsetIndex$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return OffsetIndex$.MODULE$.msgWithLogIdent(string);
    }

    public static void logIdent_$eq(String string) {
        OffsetIndex$.MODULE$.logIdent_$eq(string);
    }

    public static String logIdent() {
        return OffsetIndex$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return OffsetIndex$.MODULE$.logger();
    }

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return OffsetIndex$.MODULE$.loggerName();
    }

    public /* synthetic */ int kafka$log$OffsetIndex$$super$maxIndexSize() {
        return super.maxIndexSize();
    }

    public /* synthetic */ long kafka$log$OffsetIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    public OffsetPosition kafka$log$OffsetIndex$$lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        offsetPosition = this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        offsetPosition = new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0);
                    }
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public long lastOffset() {
        return this.kafka$log$OffsetIndex$$_lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.targetOffset$1, IndexSearchType$.MODULE$.KEY());
                return slot == -1 ? new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0) : this.$outer.parseEntry(idx, slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), new Serializable(this, fetchOffset, fetchSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final OffsetPosition fetchOffset$1;
            private final int fetchSize$1;

            public final Option<OffsetPosition> apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.smallestUpperBoundSlotFor(idx, this.fetchOffset$1.position() + this.fetchSize$1, IndexSearchType$.MODULE$.VALUE());
                return slot == -1 ? None$.MODULE$ : new Some((Object)this.$outer.parseEntry(idx, slot));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchOffset$1 = fetchOffset$1;
                this.fetchSize$1 = fetchSize$1;
            }
        });
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public OffsetPosition parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.kafka$log$OffsetIndex$$relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to fetch the ", "th entry from index ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), this.$outer.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which has size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).toString());
                }
                return this.$outer.parseEntry(this.$outer.mmap(), this.n$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    public void append(long offset2, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2, position){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.$outer._entries() == 0 || this.offset$1 > this.$outer.kafka$log$OffsetIndex$$_lastOffset) {
                    OffsetIndex$.MODULE$.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding index entry ", " => ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.mmap().putInt(this.$outer.relativeOffset(this.offset$1));
                    this.$outer.mmap().putInt(this.position$1);
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.offset$1;
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new InvalidOffsetException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to append an offset (", ") to position ", " no larger than"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.entries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" the last offset appended (", ") to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), this.$outer.file().getAbsolutePath()}))).toString());
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.position$1 = position$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.KEY());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer._entries_$eq(this.entries$1);
                this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
                this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.$outer.kafka$log$OffsetIndex$$lastEntry().offset();
                OffsetIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$kafka$log$OffsetIndex$$truncateToEntries$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated index ", " to ", " entries;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.entries$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" position is now ", " and last offset is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().mmap().position()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$_lastOffset)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        if (this._entries() != 0 && this.kafka$log$OffsetIndex$$_lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the last offset is ", " which is less than the base offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToLong((long)super.baseOffset())}))).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index file ", " is corrupt, found ", " bytes which is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"neither positive nor a multiple of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.entrySize())}))).toString());
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        OffsetIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded index file ", " with maxEntries = ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxIndexSize = ", ", entries = ", ", lastOffset = ", ", file position = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$super$maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer._entries()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToInteger((int)this.$outer.mmap().position())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

