/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\t\rv!B\u0001\u0003\u0011\u00039\u0011!\u0007#fY\u0006LX\rZ(qKJ\fG/[8o!V\u0014x-\u0019;pefT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u001a\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u0004VO]4bi>\u0014\u0018p\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000fYI!\u0019!C\u0005/\u000511\u000b[1sIN,\u0012\u0001\u0007\t\u0003\u001beI!A\u0007\b\u0003\u0007%sG\u000f\u0003\u0004\u001d\u0013\u0001\u0006I\u0001G\u0001\b'\"\f'\u000fZ:!\u0011\u0015q\u0012\u0002\"\u0001 \u0003\u0015\t\u0007\u000f\u001d7z+\r\u0001#Q\b\u000b\fC\t}\"\u0011\tB\"\u0005\u000b\u00129\u0005\u0005\u0003\tE\tmb\u0001\u0002\u0006\u0003\u0005\r*\"\u0001\n*\u0014\t\tbQe\u000b\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\tQ!\u001e;jYNL!AK\u0014\u0003\u000f1{wmZ5oOB\u0011AfL\u0007\u0002[)\u0011a\u0006B\u0001\b[\u0016$(/[2t\u0013\t\u0001TFA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001B\r\u0012\u0003\u0002\u0003\u0006IaM\u0001\u000eaV\u0014x-\u0019;peft\u0015-\\3\u0011\u0005Q:dBA\u00076\u0013\t1d\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c\u000f\u0011!Y$E!A!\u0002\u0013a\u0014\u0001\u0004;j[\u0016|W\u000f\u001e+j[\u0016\u0014\bCA\u001fA\u001b\u0005q$BA (\u0003\u0015!\u0018.\\3s\u0013\t\teHA\u0003US6,'\u000f\u0003\u0005DE\t\u0005\t\u0015!\u0003\u0019\u0003!\u0011'o\\6fe&#\u0007\u0002C##\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u001bA,(oZ3J]R,'O^1m\u0011!9%E!A!\u0002\u0013A\u0015!\u0004:fCB,'/\u00128bE2,G\r\u0005\u0002\u000e\u0013&\u0011!J\u0004\u0002\b\u0005>|G.Z1o\u0011!a%E!A!\u0002\u0013A\u0015\u0001\u0004;j[\u0016\u0014XI\\1cY\u0016$\u0007\"B\n#\t\u0003qEcB(\\9vsv\f\u0019\t\u0004\u0011\t\u0002\u0006CA)S\u0019\u0001!Qa\u0015\u0012C\u0002Q\u0013\u0011\u0001V\t\u0003+b\u0003\"!\u0004,\n\u0005]s!a\u0002(pi\"Lgn\u001a\t\u0003\u0011eK!A\u0017\u0002\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007\"\u0002\u001aN\u0001\u0004\u0019\u0004\"B\u001eN\u0001\u0004a\u0004bB\"N!\u0003\u0005\r\u0001\u0007\u0005\b\u000b6\u0003\n\u00111\u0001\u0019\u0011\u001d9U\n%AA\u0002!Cq\u0001T'\u0011\u0002\u0003\u0007\u0001J\u0002\u0003cE\u0011\u0019'aC,bi\u000eDWM\u001d'jgR\u001c\"!\u0019\u0007\t\u000bM\tG\u0011A3\u0015\u0003\u0019\u0004\"aZ1\u000e\u0003\tBq![1C\u0002\u0013\u0005!.A\u0007xCR\u001c\u0007.\u001a:t\u0005f\\U-_\u000b\u0002WB!a\u0005\u001c8r\u0013\tiwE\u0001\u0003Q_>d\u0007CA\u0007p\u0013\t\u0001hBA\u0002B]f\u0004\"a\u001a:\u0007\tM\u0014C\u0001\u001e\u0002\t/\u0006$8\r[3sgN\u0011!\u000f\u0004\u0005\tmJ\u0014)\u0019!C\u0001o\u0006\u00191.Z=\u0016\u00039D\u0001\"\u001f:\u0003\u0002\u0003\u0006IA\\\u0001\u0005W\u0016L\b\u0005C\u0003\u0014e\u0012\u00051\u0010\u0006\u0002ry\")aO\u001fa\u0001]\"1aP\u001dQ\u0001\n}\f!b\u001c9fe\u0006$\u0018n\u001c8t!\u0015\t\t!a\u0004Q\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AC2p]\u000e,(O]3oi*!\u0011\u0011BA\u0006\u0003\u0011)H/\u001b7\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006LA!!\u0005\u0002\u0004\t)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007BBA\u000be\u0012\u0005q#\u0001\u0007d_VtGoV1uG\",G\rC\u0004\u0002\u001aI$\t!a\u0007\u0002\u000f%\u001cX)\u001c9usV\t\u0001\nC\u0004\u0002 I$\t!!\t\u0002\u000b]\fGo\u00195\u0015\t\u0005\r\u0012\u0011\u0006\t\u0004\u001b\u0005\u0015\u0012bAA\u0014\u001d\t!QK\\5u\u0011\u001d\tY#!\bA\u0002A\u000b\u0011\u0001\u001e\u0005\b\u0003_\u0011H\u0011AA\u0019\u0003I!(/_\"p[BdW\r^3XCR\u001c\u0007.\u001a3\u0015\u0003aAq!!\u000es\t\u0003\t9$\u0001\u0004dC:\u001cW\r\u001c\u000b\u0003\u0003s\u0001R!a\u000f\u0002LAsA!!\u0010\u0002H9!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D\u0019\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0007\u0005%c\"A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0013q\n\u0002\u0005\u0019&\u001cHOC\u0002\u0002J9Aq!a\u0015s\t\u0003\t\t$\u0001\bqkJ<WmQ8na2,G/\u001a3\t\u000f\u0005]\u0013\r)A\u0005W\u0006qq/\u0019;dQ\u0016\u00148OQ=LKf\u0004\u0003\"CA.C\n\u0007I\u0011AA/\u000319\u0018\r^2iKJ\u001cHj\\2l+\t\ty\u0006\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\u0011\t)'a\u0001\u0002\u000b1|7m[:\n\t\u0005%\u00141\r\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\u0011\u00055\u0014\r)A\u0005\u0003?\nQb^1uG\",'o\u001d'pG.\u0004\u0003bBA9C\u0012\u0005\u00111O\u0001\fC2dw+\u0019;dQ\u0016\u00148/\u0006\u0002\u0002vA)\u00111HA<c&!\u0011\u0011PA(\u0005!IE/\u001a:bE2,\u0007\"CA?E\t\u0007I\u0011BA@\u000319\u0018\r^2iKJd\u0015n\u001d;t+\t\t\t\t\u0005\u0003\u000e\u0003\u00073\u0017bAAC\u001d\t)\u0011I\u001d:bs\"A\u0011\u0011\u0012\u0012!\u0002\u0013\t\t)A\u0007xCR\u001c\u0007.\u001a:MSN$8\u000f\t\u0005\b\u0003\u001b\u0013C\u0011BAH\u0003-9\u0018\r^2iKJd\u0015n\u001d;\u0015\u0007\u0019\f\t\n\u0003\u0004w\u0003\u0017\u0003\rA\u001c\u0005\t\u0003+\u0013\u0003\u0015!\u0003\u0002\u0018\u0006ARm\u001d;j[\u0006$X\r\u001a+pi\u0006dw\n]3sCRLwN\\:\u0011\t\u0005e\u0015qT\u0007\u0003\u00037SA!!(\u0002\u0004\u00051\u0011\r^8nS\u000eLA!!)\u0002\u001c\ni\u0011\t^8nS\u000eLe\u000e^3hKJD\u0011\"!*#\u0005\u0004%I!a*\u0002!\u0015D\b/\u001b:bi&|gNU3ba\u0016\u0014XCAAU!\r9\u00171\u0016\u0004\u0007\u0003[\u0013C!a,\u0003-\u0015C\b/\u001b:fI>\u0003XM]1uS>t'+Z1qKJ\u001cB!a+\u00022B\u0019a%a-\n\u0007\u0005UvE\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007bB\n\u0002,\u0012\u0005\u0011\u0011\u0018\u000b\u0003\u0003SC\u0001\"!0\u0002,\u0012\u0005\u0013qX\u0001\u0007I><vN]6\u0015\u0005\u0005\r\u0002\u0002CAbE\u0001\u0006I!!+\u0002#\u0015D\b/\u001b:bi&|gNU3ba\u0016\u0014\b\u0005C\u0005\u0002H\n\u0012\r\u0011\"\u0003\u0002J\u0006YQ.\u001a;sS\u000e\u001cH+Y4t+\t\tY\rE\u0004\u0002N\u0006M\u0017q[\u001a\u000e\u0005\u0005='bAAi\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0017q\u001a\u0002\u0004\u001b\u0006\u0004\b\u0003BAm\u0003?l!!a7\u000b\t\u0005u\u00171B\u0001\u0005Y\u0006tw-C\u00029\u00037D\u0001\"a9#A\u0003%\u00111Z\u0001\r[\u0016$(/[2t)\u0006<7\u000f\t\u0005\b\u0003O\u0014C\u0011AAu\u0003Q!(/_\"p[BdW\r^3FYN,w+\u0019;dQR)\u0001*a;\u0002p\"9\u0011Q^As\u0001\u0004\u0001\u0016!C8qKJ\fG/[8o\u0011!\t\t0!:A\u0002\u0005M\u0018!C<bi\u000eD7*Z=t!\u0015\ti-!>o\u0013\u0011\t90a4\u0003\u0007M+\u0017\u000fC\u0004\u0002|\n\"\t!!@\u0002!\rDWmY6B]\u0012\u001cu.\u001c9mKR,Gc\u0001\r\u0002\u0000\"1a/!?A\u00029DaAa\u0001#\t\u00039\u0012aB<bi\u000eDW\r\u001a\u0005\u0007\u0005\u000f\u0011C\u0011A\f\u0002\u00159,X\u000eR3mCf,G\rC\u0004\u0003\f\t\"\tA!\u0004\u0002\u0019\r\fgnY3m\r>\u00148*Z=\u0015\t\u0005e\"q\u0002\u0005\u0007m\n%\u0001\u0019\u00018\t\u000f\tM!\u0005\"\u0003\u0003\u0016\u0005\tr/\u0019;dQ\u001a{'o\u00149fe\u0006$\u0018n\u001c8\u0015\r\u0005\r\"q\u0003B\r\u0011\u00191(\u0011\u0003a\u0001]\"9\u0011Q\u001eB\t\u0001\u0004\u0001\u0006b\u0002B\u000fE\u0011%!qD\u0001\u0011e\u0016lwN^3LKfLe-R7qif$b!a\t\u0003\"\t\r\u0002B\u0002<\u0003\u001c\u0001\u0007a\u000eC\u0004\u0003&\tm\u0001\u0019A9\u0002\u0011]\fGo\u00195feNDqA!\u000b#\t\u0003\ty,\u0001\u0005tQV$Hm\\<o\u0011\u001d\u0011iC\tC\u0001\u0005_\tA\"\u00193wC:\u001cWm\u00117pG.$B!a\t\u00032!A!1\u0007B\u0016\u0001\u0004\u0011)$A\u0005uS6,w.\u001e;NgB\u0019QBa\u000e\n\u0007\tebB\u0001\u0003M_:<\u0007cA)\u0003>\u0011)1+\bb\u0001)\")!'\ba\u0001g!91)\bI\u0001\u0002\u0004A\u0002bB#\u001e!\u0003\u0005\r\u0001\u0007\u0005\b\u000fv\u0001\n\u00111\u0001I\u0011\u001daU\u0004%AA\u0002!C\u0011Ba\u0013\n#\u0003%\tA!\u0014\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*BAa\u0014\u0003fU\u0011!\u0011\u000b\u0016\u00041\tM3F\u0001B+!\u0011\u00119F!\u0019\u000e\u0005\te#\u0002\u0002B.\u0005;\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}c\"\u0001\u0006b]:|G/\u0019;j_:LAAa\u0019\u0003Z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\rM\u0013IE1\u0001U\u0011%\u0011I'CI\u0001\n\u0003\u0011Y'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011yE!\u001c\u0005\rM\u00139G1\u0001U\u0011%\u0011\t(CI\u0001\n\u0003\u0011\u0019(A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011)H!\u001f\u0016\u0005\t]$f\u0001%\u0003T\u001111Ka\u001cC\u0002QC\u0011B! \n#\u0003%\tAa \u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU*BA!\u001e\u0003\u0002\u001211Ka\u001fC\u0002QC\u0011B!\"\n#\u0003%\tAa\"\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011yE!#\u0005\rM\u0013\u0019I1\u0001U\u0011%\u0011i)CI\u0001\n\u0003\u0011y)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0005\u0005\u001f\u0012\t\n\u0002\u0004T\u0005\u0017\u0013\r\u0001\u0016\u0005\n\u0005+K\u0011\u0013!C\u0001\u0005/\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T\u0003\u0002B;\u00053#aa\u0015BJ\u0005\u0004!\u0006\"\u0003BO\u0013E\u0005I\u0011\u0001BP\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU!!Q\u000fBQ\t\u0019\u0019&1\u0014b\u0001)\u0002")
public final class DelayedOperationPurgatory<T extends DelayedOperation>
implements KafkaMetricsGroup {
    public final String kafka$server$DelayedOperationPurgatory$$purgatoryName;
    private final Timer timeoutTimer;
    public final int kafka$server$DelayedOperationPurgatory$$brokerId;
    private final int purgeInterval;
    private final boolean reaperEnabled;
    private final boolean timerEnabled;
    private final WatcherList[] watcherLists;
    public final AtomicInteger kafka$server$DelayedOperationPurgatory$$estimatedTotalOperations;
    private final ExpiredOperationReaper expirationReaper;
    private final Map<String, String> metricsTags;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends DelayedOperation> boolean $lessinit$greater$default$6() {
        return DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T extends DelayedOperation> boolean $lessinit$greater$default$5() {
        return DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T extends DelayedOperation> int $lessinit$greater$default$4() {
        return DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T extends DelayedOperation> int $lessinit$greater$default$3() {
        return DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T extends DelayedOperation> boolean apply$default$5() {
        return DelayedOperationPurgatory$.MODULE$.apply$default$5();
    }

    public static <T extends DelayedOperation> boolean apply$default$4() {
        return DelayedOperationPurgatory$.MODULE$.apply$default$4();
    }

    public static <T extends DelayedOperation> int apply$default$3() {
        return DelayedOperationPurgatory$.MODULE$.apply$default$3();
    }

    public static <T extends DelayedOperation> int apply$default$2() {
        return DelayedOperationPurgatory$.MODULE$.apply$default$2();
    }

    public static <T extends DelayedOperation> DelayedOperationPurgatory<T> apply(String string, int n, int n2, boolean bl, boolean bl2) {
        return DelayedOperationPurgatory$.MODULE$.apply(string, n, n2, bl, bl2);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public com.yammer.metrics.core.Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    private Logger logger$lzycompute() {
        DelayedOperationPurgatory delayedOperationPurgatory = this;
        synchronized (delayedOperationPurgatory) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private WatcherList[] watcherLists() {
        return this.watcherLists;
    }

    private WatcherList watcherList(Object key) {
        return this.watcherLists()[Math.abs(key.hashCode() % this.watcherLists().length)];
    }

    private ExpiredOperationReaper expirationReaper() {
        return this.expirationReaper;
    }

    private Map<String, String> metricsTags() {
        return this.metricsTags;
    }

    public boolean tryCompleteElseWatch(T operation, Seq<Object> watchKeys) {
        NonLocalReturnControl nonLocalReturnControl2;
        block7: {
            boolean bl;
            Object object = new Object();
            try {
                Predef$.MODULE$.assert(watchKeys.nonEmpty(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "The watch key list can't be empty";
                    }
                });
                boolean isCompletedByMe = ((DelayedOperation)operation).tryComplete();
                if (isCompletedByMe) {
                    return true;
                }
                BooleanRef watchCreated = BooleanRef.create((boolean)false);
                watchKeys.foreach((Function1)new Serializable(this, operation, watchCreated, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DelayedOperationPurgatory $outer;
                    private final DelayedOperation operation$1;
                    private final BooleanRef watchCreated$1;
                    private final Object nonLocalReturnKey1$1;

                    public final Object apply(Object key) {
                        Object object;
                        if (this.operation$1.isCompleted()) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                        }
                        this.$outer.kafka$server$DelayedOperationPurgatory$$watchForOperation(key, this.operation$1);
                        if (this.watchCreated$1.elem) {
                            object = BoxedUnit.UNIT;
                        } else {
                            this.watchCreated$1.elem = true;
                            object = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$DelayedOperationPurgatory$$estimatedTotalOperations.incrementAndGet());
                        }
                        return object;
                    }
                    {
                        void var4_4;
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.operation$1 = operation$1;
                        this.watchCreated$1 = var3_3;
                        this.nonLocalReturnKey1$1 = var4_4;
                    }
                });
                isCompletedByMe = ((DelayedOperation)operation).maybeTryComplete();
                if (isCompletedByMe) {
                    return true;
                }
                if (!((DelayedOperation)operation).isCompleted()) {
                    if (this.timerEnabled) {
                        this.timeoutTimer.add((TimerTask)operation);
                    }
                    if (((DelayedOperation)operation).isCompleted()) {
                        ((DelayedOperation)operation).cancel();
                    }
                }
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block7;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public int checkAndComplete(Object key) {
        WatcherList wl = this.watcherList(key);
        Watchers watchers = (Watchers)CoreUtils$.MODULE$.inLock(wl.watchersLock(), new Serializable(this, key, wl){
            public static final long serialVersionUID = 0L;
            private final Object key$1;
            private final WatcherList wl$1;

            public final Watchers apply() {
                return this.wl$1.watchersByKey().get(this.key$1);
            }
            {
                void var3_3;
                this.key$1 = key$1;
                this.wl$1 = var3_3;
            }
        });
        int numCompleted = watchers == null ? 0 : watchers.tryCompleteWatched();
        this.debug((Function0<String>)new Serializable(this, key, numCompleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationPurgatory $outer;
            private final Object key$1;
            private final int numCompleted$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " ", " operations"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, BoxesRunTime.boxToInteger((int)this.numCompleted$1), this.$outer.kafka$server$DelayedOperationPurgatory$$purgatoryName}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
                this.numCompleted$1 = numCompleted$1;
            }
        });
        return numCompleted;
    }

    public int watched() {
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.refArrayOps((Object[])this.watcherLists()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x0$1, WatcherList x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
                if (tuple2 != null) {
                    int sum = tuple2._1$mcI$sp();
                    WatcherList watcherList = (WatcherList)tuple2._2();
                    int n = sum + BoxesRunTime.unboxToInt((Object)((TraversableOnce)watcherList.allWatchers().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Watchers x$1) {
                            return x$1.countWatched();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    return n;
                }
                throw new MatchError((Object)tuple2);
            }
        }));
    }

    public int numDelayed() {
        return this.timeoutTimer.size();
    }

    public List<T> cancelForKey(Object key) {
        WatcherList wl = this.watcherList(key);
        return (List)CoreUtils$.MODULE$.inLock(wl.watchersLock(), new Serializable(this, key, wl){
            public static final long serialVersionUID = 0L;
            private final Object key$2;
            private final WatcherList wl$2;

            public final List<T> apply() {
                Watchers watchers = this.wl$2.watchersByKey().remove(this.key$2);
                return watchers == null ? Nil$.MODULE$ : watchers.cancel();
            }
            {
                void var3_3;
                this.key$2 = key$2;
                this.wl$2 = var3_3;
            }
        });
    }

    public void kafka$server$DelayedOperationPurgatory$$watchForOperation(Object key, T operation) {
        WatcherList wl = this.watcherList(key);
        CoreUtils$.MODULE$.inLock(wl.watchersLock(), new Serializable(this, key, operation, wl){
            public static final long serialVersionUID = 0L;
            private final Object key$3;
            private final DelayedOperation operation$2;
            private final WatcherList wl$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Watchers watcher = this.wl$3.watchersByKey().getAndMaybePut(this.key$3);
                watcher.watch(this.operation$2);
            }
            {
                void var4_4;
                void var3_3;
                this.key$3 = key$3;
                this.operation$2 = var3_3;
                this.wl$3 = var4_4;
            }
        });
    }

    public void kafka$server$DelayedOperationPurgatory$$removeKeyIfEmpty(Object key, Watchers watchers) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                WatcherList wl = this.watcherList(key);
                CoreUtils$.MODULE$.inLock(wl.watchersLock(), new Serializable(this, key, watchers, wl, object){
                    public static final long serialVersionUID = 0L;
                    private final Object key$4;
                    private final Watchers watchers$1;
                    private final WatcherList wl$4;
                    private final Object nonLocalReturnKey2$1;

                    public final Object apply() {
                        Watchers watchers = this.wl$4.watchersByKey().get(this.key$4);
                        Watchers watchers2 = this.watchers$1;
                        if (!(watchers != null ? !watchers.equals(watchers2) : watchers2 != null)) {
                            return this.watchers$1 != null && this.watchers$1.isEmpty() ? this.wl$4.watchersByKey().remove(this.key$4) : BoxedUnit.UNIT;
                        }
                        throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey2$1, BoxedUnit.UNIT);
                    }
                    {
                        void var5_5;
                        void var4_4;
                        void var3_3;
                        this.key$4 = key$4;
                        this.watchers$1 = var3_3;
                        this.wl$4 = var4_4;
                        this.nonLocalReturnKey2$1 = var5_5;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void shutdown() {
        if (this.reaperEnabled) {
            this.expirationReaper().shutdown();
        }
        this.timeoutTimer.shutdown();
        this.removeMetric("PurgatorySize", this.metricsTags());
        this.removeMetric("NumDelayedOperations", this.metricsTags());
    }

    public void advanceClock(long timeoutMs) {
        this.timeoutTimer.advanceClock(timeoutMs);
        if (this.kafka$server$DelayedOperationPurgatory$$estimatedTotalOperations.get() - this.numDelayed() > this.purgeInterval) {
            this.kafka$server$DelayedOperationPurgatory$$estimatedTotalOperations.getAndSet(this.numDelayed());
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Begin purging watch lists";
                }
            });
            int purged = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.refArrayOps((Object[])this.watcherLists()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x0$2, WatcherList x1$2) {
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$2);
                    if (tuple2 != null) {
                        int sum = tuple2._1$mcI$sp();
                        WatcherList watcherList = (WatcherList)tuple2._2();
                        int n = sum + BoxesRunTime.unboxToInt((Object)((TraversableOnce)watcherList.allWatchers().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Watchers x$2) {
                                return x$2.purgeCompleted();
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                        return n;
                    }
                    throw new MatchError((Object)tuple2);
                }
            }));
            this.debug((Function0<String>)new Serializable(this, purged){
                public static final long serialVersionUID = 0L;
                private final int purged$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Purged %d elements from watch lists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.purged$1)}));
                }
                {
                    this.purged$1 = purged$1;
                }
            });
        }
    }

    public DelayedOperationPurgatory(String purgatoryName, Timer timeoutTimer, int brokerId, int purgeInterval, boolean reaperEnabled, boolean timerEnabled) {
        this.kafka$server$DelayedOperationPurgatory$$purgatoryName = purgatoryName;
        this.timeoutTimer = timeoutTimer;
        this.kafka$server$DelayedOperationPurgatory$$brokerId = brokerId;
        this.purgeInterval = purgeInterval;
        this.reaperEnabled = reaperEnabled;
        this.timerEnabled = timerEnabled;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.watcherLists = (WatcherList[])Array$.MODULE$.fill(DelayedOperationPurgatory$.MODULE$.kafka$server$DelayedOperationPurgatory$$Shards(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationPurgatory $outer;

            public final WatcherList apply() {
                return this.$outer.new WatcherList();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(WatcherList.class));
        this.kafka$server$DelayedOperationPurgatory$$estimatedTotalOperations = new AtomicInteger(0);
        this.expirationReaper = new ExpiredOperationReaper();
        this.metricsTags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delayedOperation"), (Object)purgatoryName)}));
        this.newGauge("PurgatorySize", new Gauge<Object>(this){
            private final /* synthetic */ DelayedOperationPurgatory $outer;

            public int value() {
                return this.$outer.watched();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.metricsTags());
        this.newGauge("NumDelayedOperations", new Gauge<Object>(this){
            private final /* synthetic */ DelayedOperationPurgatory $outer;

            public int value() {
                return this.$outer.numDelayed();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.metricsTags());
        if (reaperEnabled) {
            this.expirationReaper().start();
        }
    }

    public class Watchers {
        private final Object key;
        private final ConcurrentLinkedQueue<T> operations;
        public final /* synthetic */ DelayedOperationPurgatory $outer;

        public Object key() {
            return this.key;
        }

        public int countWatched() {
            return this.operations.size();
        }

        public boolean isEmpty() {
            return this.operations.isEmpty();
        }

        public void watch(T t) {
            this.operations.add(t);
        }

        /*
         * WARNING - void declaration
         */
        public int tryCompleteWatched() {
            void var1_1;
            int completed = 0;
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                DelayedOperation curr = (DelayedOperation)iter.next();
                if (curr.isCompleted()) {
                    iter.remove();
                    continue;
                }
                if (!curr.maybeTryComplete()) continue;
                iter.remove();
                ++completed;
            }
            if (this.operations.isEmpty()) {
                this.kafka$server$DelayedOperationPurgatory$Watchers$$$outer().kafka$server$DelayedOperationPurgatory$$removeKeyIfEmpty(this.key(), this);
            }
            return (int)var1_1;
        }

        public List<T> cancel() {
            Iterator iter = this.operations.iterator();
            ListBuffer cancelled = new ListBuffer();
            while (iter.hasNext()) {
                DelayedOperation curr = (DelayedOperation)iter.next();
                curr.cancel();
                iter.remove();
                cancelled.$plus$eq((Object)curr);
            }
            return cancelled.toList();
        }

        /*
         * WARNING - void declaration
         */
        public int purgeCompleted() {
            void var1_1;
            int purged = 0;
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                DelayedOperation curr = (DelayedOperation)iter.next();
                if (!curr.isCompleted()) continue;
                iter.remove();
                ++purged;
            }
            if (this.operations.isEmpty()) {
                this.kafka$server$DelayedOperationPurgatory$Watchers$$$outer().kafka$server$DelayedOperationPurgatory$$removeKeyIfEmpty(this.key(), this);
            }
            return (int)var1_1;
        }

        public /* synthetic */ DelayedOperationPurgatory kafka$server$DelayedOperationPurgatory$Watchers$$$outer() {
            return this.$outer;
        }

        public Watchers(DelayedOperationPurgatory<T> $outer, Object key) {
            this.key = key;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.operations = new ConcurrentLinkedQueue();
        }
    }

    public class WatcherList {
        private final Pool<Object, Watchers> watchersByKey;
        private final ReentrantLock watchersLock;

        public Pool<Object, Watchers> watchersByKey() {
            return this.watchersByKey;
        }

        public ReentrantLock watchersLock() {
            return this.watchersLock;
        }

        public Iterable<Watchers> allWatchers() {
            return this.watchersByKey().values();
        }

        public /* synthetic */ DelayedOperationPurgatory kafka$server$DelayedOperationPurgatory$WatcherList$$$outer() {
            return DelayedOperationPurgatory.this;
        }

        public WatcherList() {
            if (DelayedOperationPurgatory.this == null) {
                throw null;
            }
            this.watchersByKey = new Pool(new Some((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WatcherList $outer;

                public final Watchers apply(Object key) {
                    return new Watchers(this.$outer.kafka$server$DelayedOperationPurgatory$WatcherList$$$outer(), key);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            this.watchersLock = new ReentrantLock();
        }
    }

    public class ExpiredOperationReaper
    extends ShutdownableThread {
        @Override
        public void doWork() {
            this.kafka$server$DelayedOperationPurgatory$ExpiredOperationReaper$$$outer().advanceClock(200L);
        }

        public /* synthetic */ DelayedOperationPurgatory kafka$server$DelayedOperationPurgatory$ExpiredOperationReaper$$$outer() {
            return DelayedOperationPurgatory.this;
        }

        public ExpiredOperationReaper() {
            if (DelayedOperationPurgatory.this == null) {
                throw null;
            }
            super(new StringOps(Predef$.MODULE$.augmentString("ExpirationReaper-%d-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DelayedOperationPurgatory.this.kafka$server$DelayedOperationPurgatory$$brokerId), DelayedOperationPurgatory.this.kafka$server$DelayedOperationPurgatory$$purgatoryName})), false);
        }
    }
}

